/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.core.placement;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.apexstudios.apexcore.lib.level.FakeLevel;
import dev.apexstudios.apexcore.lib.placement.BlockPlacementRenderer;
import dev.apexstudios.apexcore.lib.placement.PlacementRenderEvent;
import dev.apexstudios.apexcore.lib.util.ApexTags;
import dev.apexstudios.apexcore.mixin.BlockItemAccessor;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

final class BlockItemPlacementRenderer
implements BlockPlacementRenderer {
    BlockItemPlacementRenderer() {
    }

    @Override
    public boolean renderForHand(Level level, Player player, InteractionHand hand, BlockHitResult hitResult, Camera camera, PoseStack pose, MultiBufferSource.BufferSource buffers) {
        ItemStack stack = player.getItemInHand(hand);
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return false;
        }
        BlockItem item2 = (BlockItem)item;
        if (!item2.getBlock().builtInRegistryHolder().is(ApexTags.Blocks.RENDER_PLACEMENT_WHITELIST)) {
            return false;
        }
        AtomicBoolean canBePlaced = new AtomicBoolean(stack.isItemEnabled(level.enabledFeatures()));
        BlockPlaceContext context = this.buildContext(level, player, hand, stack, item2, hitResult, canBePlaced);
        this.placeBlock((LevelReader)level, context, item2, canBePlaced);
        if (canBePlaced.get()) {
            List<BlockPos> contextPositions = this.copyContextBlockStates((LevelReader)level, context);
            this.updateContexts(context, contextPositions);
            this.validatePlacement(context, canBePlaced, item2);
            contextPositions.forEach(pos -> context.getLevel().setBlock(pos, Blocks.AIR.defaultBlockState(), 260));
        }
        BlockPlacementRenderer.renderAt(camera, pose, () -> BlockPlacementRenderer.renderLevel(context, pose, canBePlaced.get()));
        return true;
    }

    private BlockPlaceContext buildContext(Level level, Player player, InteractionHand hand, ItemStack stack, BlockItem item, BlockHitResult hitResult, AtomicBoolean canBePlaced) {
        BlockPlaceContext context;
        FakeLevel fakeLevel = new FakeLevel(level);
        BlockPlaceContext originalContext = new BlockPlaceContext((Level)fakeLevel, player, hand, stack.copy(), hitResult);
        if (!originalContext.canPlace()) {
            canBePlaced.set(false);
        }
        if ((context = item.updatePlacementContext(originalContext)) == null) {
            context = originalContext;
            canBePlaced.set(false);
        }
        return context;
    }

    private void placeBlock(LevelReader realLevel, BlockPlaceContext context, BlockItem item, AtomicBoolean canBePlaced) {
        FakeLevel level = (FakeLevel)context.getLevel();
        BlockPos pos = context.getClickedPos();
        ItemStack stack = context.getItemInHand();
        BlockItemAccessor accessor = (BlockItemAccessor)item;
        BlockState blockState = accessor.ApexCore$getPlacementState(context);
        if (blockState == null) {
            blockState = BlockPlacementRenderer.getDefaultBlockState(realLevel, context, item.getBlock().defaultBlockState());
            canBePlaced.set(false);
        }
        if ((blockState = PlacementRenderEvent.modifyBlockState(realLevel, context, blockState)).hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        accessor.ApexCore$placeBlock(context, blockState);
        BlockState fBlockState = accessor.ApexCore$updateBlockStateFromTag(pos, level, stack, blockState);
        level.runAsServerSide(() -> accessor.ApexCore$updateCustomBlockEntityTag(pos, level, context.getPlayer(), stack, fBlockState));
        BlockItem.updateBlockEntityComponents((Level)level, (BlockPos)pos, (ItemStack)stack);
        level.runAsServerSide(() -> {
            fBlockState.getBlock().setPlacedBy((Level)level, pos, fBlockState, (LivingEntity)context.getPlayer(), stack);
            fBlockState.onPlace((Level)level, pos, Blocks.AIR.defaultBlockState(), false);
        });
        this.validatePlacement(context, canBePlaced, item);
    }

    private List<BlockPos> copyContextBlockStates(LevelReader realLevel, BlockPlaceContext context) {
        FakeLevel level = (FakeLevel)context.getLevel();
        List<BlockPos> renderPositions = level.positions().toList();
        BlockPos.breadthFirstTraversal((BlockPos)context.getClickedPos(), (int)4, (int)64, (pos, childConsumer) -> {
            for (Direction direction : Direction.values()) {
                childConsumer.accept(pos.relative(direction));
            }
            if (!renderPositions.contains(pos)) {
                level.setBlock((BlockPos)pos, realLevel.getBlockState(pos), 260);
            }
        }, pos -> BlockPos.TraversalNodeStatus.ACCEPT);
        return level.positions().filter(Predicate.not(renderPositions::contains)).collect(Collectors.toList());
    }

    private void updateContexts(BlockPlaceContext context, List<BlockPos> contextPositions) {
        Level level = context.getLevel();
        Iterator<BlockPos> itr = contextPositions.iterator();
        while (itr.hasNext()) {
            BlockPos pos = itr.next();
            BlockState blockState = level.getBlockState(pos);
            BlockState newBlockState = Block.updateFromNeighbourShapes((BlockState)blockState, (LevelAccessor)level, (BlockPos)pos);
            if (newBlockState == blockState) continue;
            itr.remove();
            BlockEntity blockEntity = level.getBlockEntity(pos);
            level.setBlock(pos, newBlockState, 260);
            if (blockEntity == null) continue;
            level.setBlockEntity(blockEntity);
        }
    }

    private void validatePlacement(BlockPlaceContext context, AtomicBoolean canBePlaced, BlockItem item) {
        BlockPos origin;
        Level level = context.getLevel();
        BlockState blockState = level.getBlockState(origin = context.getClickedPos());
        if (!((BlockItemAccessor)item).ApexCore$canPlace(context, blockState)) {
            canBePlaced.set(false);
        }
    }
}

