/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.core.placement;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.apexstudios.apexcore.core.placement.BlockItemPlacementRenderer;
import dev.apexstudios.apexcore.core.placement.BucketItemPlacementRenderer;
import dev.apexstudios.apexcore.lib.placement.BlockPlacementRenderer;
import dev.apexstudios.apexcore.lib.placement.PlacementRenderEvent;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.NeoForge;

public interface PlacementRendererRegistry {
    public static void register() {
        Iterable<BlockPlacementRenderer> renderers = PlacementRenderEvent.registerRenderers(registrar -> {
            registrar.accept(new BlockItemPlacementRenderer());
            registrar.accept(new BucketItemPlacementRenderer());
        });
        NeoForge.EVENT_BUS.addListener(RenderLevelStageEvent.AfterParticles.class, event -> {
            BlockHitResult hitResult;
            Camera camera = event.getCamera();
            PoseStack pose = event.getPoseStack();
            Minecraft client = Minecraft.getInstance();
            Level level = event.getLevel();
            LocalPlayer player = client.player;
            if (!1.$assertionsDisabled && player == null) {
                throw new AssertionError();
            }
            boolean alwaysRender = false;
            HitResult patt0$temp = client.hitResult;
            if (!(patt0$temp instanceof BlockHitResult) || (hitResult = (BlockHitResult)patt0$temp).getType() != HitResult.Type.BLOCK && !alwaysRender) {
                return;
            }
            MultiBufferSource.BufferSource buffers = client.renderBuffers().bufferSource();
            if (PlacementRendererRegistry.renderForHand(renderers, level, (Player)player, InteractionHand.MAIN_HAND, hitResult, camera, pose, buffers)) {
                return;
            }
            PlacementRendererRegistry.renderForHand(renderers, level, (Player)player, InteractionHand.OFF_HAND, hitResult, camera, pose, buffers);
        });
    }

    private static boolean renderForHand(Iterable<BlockPlacementRenderer> renderers, Level level, Player player, InteractionHand hand, BlockHitResult hitResult, Camera camera, PoseStack pose, MultiBufferSource.BufferSource buffers) {
        for (BlockPlacementRenderer renderer : renderers) {
            if (!renderer.renderForHand(level, player, hand, hitResult, camera, pose, buffers)) continue;
            return true;
        }
        return false;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

