/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.block;

import dev.apexstudios.apexcore.lib.block.TemplateClientMultiBlockExtensions;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public final class DoorClientBlockExtensions
extends TemplateClientMultiBlockExtensions {
    private final DoorBlock block;

    public DoorClientBlockExtensions(DoorBlock block) {
        this.block = block;
    }

    @Override
    protected boolean shouldApplyCrack(BlockGetter level, BlockPos pos, BlockState blockState) {
        return blockState.is((Block)this.block);
    }

    @Override
    protected void translate(BlockGetter level, BlockPos pos, BlockState blockState, BiConsumer<BlockPos, BlockState> consumer) {
        DoubleBlockHalf half = (DoubleBlockHalf)blockState.getValue((Property)DoorBlock.HALF);
        BlockPos otherPos = pos.relative(half.getDirectionToOther());
        BlockState otherBlockState = level.getBlockState(otherPos);
        consumer.accept(otherPos, otherBlockState);
    }
}

