/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.block;

import dev.apexstudios.apexcore.lib.block.IRenderBreakingTextureExtension;
import java.util.function.BiConsumer;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;

public abstract class TemplateClientMultiBlockExtensions
implements IClientBlockExtensions,
IRenderBreakingTextureExtension {
    protected abstract boolean shouldApplyCrack(BlockGetter var1, BlockPos var2, BlockState var3);

    protected boolean shouldApplySound(BlockGetter level, BlockPos pos, BlockState blockState) {
        return false;
    }

    @Override
    public boolean shouldRenderBreakingTexture(BlockAndTintGetter level, BlockPos originPos, BlockState originBlockState, BlockPos otherPos, BlockState otherBlockState) {
        return this.shouldApplyCrack((BlockGetter)level, originPos, originBlockState);
    }

    @Override
    public boolean shouldApplyBreakingTexture(BlockAndTintGetter level, BlockPos pos, BlockState blockState) {
        return this.shouldApplyCrack((BlockGetter)level, pos, blockState);
    }

    protected abstract void translate(BlockGetter var1, BlockPos var2, BlockState var3, BiConsumer<BlockPos, BlockState> var4);

    public boolean addHitEffects(BlockState blockState, Level level, HitResult target, ParticleEngine manager) {
        BlockHitResult blockHit = (BlockHitResult)target;
        BlockPos pos = blockHit.getBlockPos();
        if (this.shouldApplyCrack((BlockGetter)level, pos, blockState)) {
            Direction side = blockHit.getDirection();
            this.translate((BlockGetter)level, pos, blockState, (otherPos, otherBlockState) -> {
                if (this.shouldApplyCrack((BlockGetter)level, (BlockPos)otherPos, (BlockState)otherBlockState)) {
                    manager.crack(otherPos, side);
                }
            });
            return true;
        }
        return super.addHitEffects(blockState, level, target, manager);
    }

    public boolean playBreakSound(BlockState blockState, Level level, BlockPos pos) {
        return this.shouldApplySound((BlockGetter)level, pos, blockState);
    }

    @Override
    public final void translateBreakingTexture(BlockAndTintGetter level, BlockPos pos, BlockState blockState, BiConsumer<BlockPos, BlockState> consumer) {
        this.translate((BlockGetter)level, pos, blockState, consumer);
    }
}

