/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.block.entity;

import dev.apexstudios.apexcore.lib.menu.SimpleMenu;
import dev.apexstudios.apexcore.lib.multiblock.MultiBlock;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class InventoryBlockEntity
extends BlockEntity
implements MenuProvider {
    public static final String TAG_NAME = "CustomName";
    public static final String TAG_ITEMS = "Items";
    public static final String TAG_SIZE = "Size";
    protected final ItemStackHandler inventory;
    @Nullable
    protected Component customName;

    protected InventoryBlockEntity(BlockEntityType<? extends InventoryBlockEntity> blockEntityType, BlockPos pos, BlockState blockState, int rows, int cols) {
        this(blockEntityType, pos, blockState, rows * cols);
    }

    protected InventoryBlockEntity(BlockEntityType<? extends InventoryBlockEntity> blockEntityType, BlockPos pos, BlockState blockState, int slots) {
        super(blockEntityType, pos, blockState);
        this.inventory = new ItemStackHandler(slots){

            public int getSlotLimit(int slot) {
                return InventoryBlockEntity.this.getSlotLimit(slot);
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return InventoryBlockEntity.this.canExtract(slot) ? super.extractItem(slot, amount, simulate) : ItemStack.EMPTY;
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                return InventoryBlockEntity.this.canInsert(slot, stack);
            }

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                InventoryBlockEntity.this.onSlotChanged(slot);
                InventoryBlockEntity.this.setChanged();
            }
        };
    }

    @Nullable
    protected MenuType<?> menuType() {
        return null;
    }

    public void setCustomName(@Nullable Component customName) {
        if (this.customName != customName) {
            this.customName = customName;
            this.setChanged();
        }
    }

    public Component getDisplayName() {
        return Objects.requireNonNullElseGet(this.customName, this::getDefaultName);
    }

    protected Component getDefaultName() {
        return this.getBlockState().getBlock().getName();
    }

    public IItemHandlerModifiable getItemHandler() {
        return this.inventory;
    }

    public NonNullList<ItemStack> getItems() {
        NonNullList items = NonNullList.withSize((int)this.inventory.getSlots(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            items.set(i, (Object)this.inventory.getStackInSlot(i));
        }
        return items;
    }

    protected int getSlotLimit(int slot) {
        return 99;
    }

    protected boolean canExtract(int slot) {
        return true;
    }

    protected boolean canInsert(int slot, ItemStack stack) {
        return true;
    }

    protected void onSlotChanged(int slot) {
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.customName = InventoryBlockEntity.parseCustomNameSafe((ValueInput)input, (String)TAG_NAME);
        this.inventory.deserialize(input);
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.storeNullable(TAG_NAME, ComponentSerialization.CODEC, (Object)this.customName);
        this.inventory.serialize(output);
    }

    protected void applyImplicitComponents(DataComponentGetter components) {
        super.applyImplicitComponents(components);
        this.customName = (Component)components.get(DataComponents.CUSTOM_NAME);
        ItemContainerContents contents = (ItemContainerContents)components.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
        for (int i = 0; i < contents.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, contents.getStackInSlot(i));
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(DataComponents.CUSTOM_NAME, (Object)this.customName);
        components.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.getItems()));
    }

    public void removeComponentsFromTag(ValueOutput output) {
        super.removeComponentsFromTag(output);
        output.discard(TAG_NAME);
        output.discard(TAG_ITEMS);
        output.discard(TAG_SIZE);
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState blockState) {
        super.preRemoveSideEffects(pos, blockState);
        if (this.level != null) {
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                Containers.dropItemStack((Level)this.level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
            }
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        MenuType<?> menuType = this.menuType();
        return menuType == null ? null : new SimpleMenu(menuType, windowId, playerInventory, (IItemHandler)this.inventory);
    }

    @Nullable
    public static IItemHandler inventoryProvider(Level level, BlockPos pos, BlockState blockState, @Nullable BlockEntity blockEntity, @Nullable Direction facing) {
        if (blockEntity == null) {
            blockEntity = MultiBlock.getBlockEntity((BlockGetter)level, pos, blockState);
        }
        if (blockEntity instanceof InventoryBlockEntity) {
            InventoryBlockEntity inventory = (InventoryBlockEntity)blockEntity;
            return inventory.getItemHandler();
        }
        return null;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event, Supplier<? extends BlockEntityType<? extends InventoryBlockEntity>> blockEntityType) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, blockEntityType.get(), (blockEntity, facing) -> blockEntity.getItemHandler());
        Set validBlocks = blockEntityType.get().getValidBlocks();
        if (!validBlocks.isEmpty()) {
            event.registerBlock(Capabilities.ItemHandler.BLOCK, InventoryBlockEntity::inventoryProvider, (Block[])validBlocks.toArray(Block[]::new));
        }
    }
}

