/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.data.provider.model;

import dev.apexstudios.apexcore.core.ApexCore;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.data.models.model.TexturedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public interface ApexModelTemplates {
    public static final TextureSlot SLOT_ALL_TINTED = TextureSlot.create((String)"all_tinted", (TextureSlot)TextureSlot.ALL);
    public static final TextureSlot SLOT_WOOL_TINTED = TextureSlot.create((String)"wool_tinted", (TextureSlot)TextureSlot.WOOL);
    public static final ModelTemplate CUBE_ALL_TINTED = ModelTemplates.create((String)ApexCore.id("cube_all_tinted"), (TextureSlot[])new TextureSlot[]{TextureSlot.ALL, SLOT_ALL_TINTED});
    public static final ModelTemplate CARPET_TINTED = ModelTemplates.create((String)ApexCore.id("carpet_tinted"), (TextureSlot[])new TextureSlot[]{TextureSlot.WOOL, SLOT_WOOL_TINTED});

    public static interface Textured {
        public static final TexturedModel.Provider CUBE_ALL_TINTED = TexturedModel.createDefault(Textured::cubeTinted, (ModelTemplate)CUBE_ALL_TINTED);
        public static final TexturedModel.Provider CARPET_TINTED = TexturedModel.createDefault(Textured::woolTinted, (ModelTemplate)CARPET_TINTED);

        public static TextureMapping cubeTinted(Block block) {
            ResourceLocation blockTexture = TextureMapping.getBlockTexture((Block)block);
            return new TextureMapping().put(TextureSlot.ALL, blockTexture).put(SLOT_ALL_TINTED, blockTexture.withSuffix("_tint"));
        }

        public static TextureMapping woolTinted(Block block) {
            ResourceLocation blockTexture = TextureMapping.getBlockTexture((Block)block);
            return new TextureMapping().put(TextureSlot.WOOL, blockTexture).put(SLOT_WOOL_TINTED, blockTexture.withSuffix("_tint"));
        }
    }
}

