/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.level;

import dev.apexstudios.apexcore.mixin.LevelAccessor;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.RecipeAccess;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.ticks.BlackholeTickAccess;
import net.minecraft.world.ticks.LevelTickAccess;
import net.neoforged.neoforge.entity.PartEntity;
import org.jetbrains.annotations.Nullable;

public final class FakeLevel
extends Level {
    private final Level delegate;
    private final Long2ObjectMap<BlockState> blockStates = new Long2ObjectOpenHashMap();
    private final Long2ObjectMap<BlockEntity> blockEntities = new Long2ObjectOpenHashMap();

    public FakeLevel(Level delegate) {
        super((WritableLevelData)delegate.getLevelData(), delegate.dimension(), delegate.registryAccess(), delegate.dimensionTypeRegistration(), delegate.isClientSide, delegate.isDebug(), 0L, 0);
        this.delegate = delegate;
    }

    public Stream<BlockPos> positions() {
        return this.blockStates.keySet().longStream().mapToObj(BlockPos::of);
    }

    private void isClientSide(boolean isClientSide) {
        ((LevelAccessor)((Object)this)).ApexCore$setIsClientSide(isClientSide);
    }

    public void runAsServerSide(Runnable runnable) {
        boolean isClientSide = this.isClientSide();
        this.isClientSide(false);
        runnable.run();
        this.isClientSide(isClientSide);
    }

    public boolean setBlock(BlockPos pos, BlockState state, int flags, int recursionLeft) {
        BlockEntity entity;
        long key = pos.asLong();
        BlockState old = (BlockState)this.blockStates.getOrDefault(key, (Object)Blocks.AIR.defaultBlockState());
        if (old == state) {
            return false;
        }
        if (state.isAir()) {
            this.blockStates.remove(key);
        } else {
            this.blockStates.put(key, (Object)state);
            if ((flags & 0x104) != 0) {
                this.runAsServerSide(() -> {
                    this.updateNeighbourForOutputSignal(pos, state.getBlock());
                    old.updateIndirectNeighbourShapes((net.minecraft.world.level.LevelAccessor)this, pos, flags & 0xFFFFFFDE, recursionLeft - 1);
                    state.onPlace((Level)this, pos, old, (flags & 0x40) != 0);
                });
            }
        }
        BlockEntity blockEntity = this.getBlockEntity(pos);
        if (blockEntity != null && !blockEntity.getBlockState().is(state.getBlock())) {
            this.removeBlockEntity(pos);
        } else if (state.hasBlockEntity() && (entity = ((EntityBlock)state.getBlock()).newBlockEntity(pos, state)) != null) {
            this.setBlockEntity(entity);
        }
        return true;
    }

    public BlockState getBlockState(BlockPos pos) {
        long key = pos.asLong();
        return this.blockStates.containsKey(key) ? (BlockState)this.blockStates.get(key) : super.getBlockState(pos);
    }

    protected LevelEntityGetter<Entity> getEntities() {
        return ((LevelAccessor)this.delegate).ApexCore$getEntities();
    }

    public List<? extends Player> players() {
        return this.delegate.players();
    }

    @Nullable
    public Entity getEntity(int id) {
        return this.delegate.getEntity(id);
    }

    public Collection<PartEntity<?>> dragonParts() {
        return this.delegate.dragonParts();
    }

    public FluidState getFluidState(BlockPos pos) {
        return this.getBlockState(pos).getFluidState();
    }

    public void setBlockEntity(BlockEntity blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        this.removeBlockEntity(pos);
        blockEntity.setLevel((Level)this);
        blockEntity.clearRemoved();
        this.blockEntities.put(pos.asLong(), (Object)blockEntity);
    }

    public void removeBlockEntity(BlockPos pos) {
        long key = pos.asLong();
        BlockEntity blockEntity = (BlockEntity)this.blockEntities.get(key);
        if (blockEntity != null) {
            blockEntity.setRemoved();
            this.blockEntities.remove(key);
        }
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos pos) {
        return this.blockEntities != null ? (BlockEntity)this.blockEntities.get(pos.asLong()) : null;
    }

    public void neighborShapeChanged(Direction p_220385_, BlockPos p_220387_, BlockPos p_220388_, BlockState p_220386_, int p_220389_, int p_220390_) {
    }

    public void sendBlockUpdated(BlockPos pos, BlockState oldState, BlockState newState, int flags) {
    }

    public void playSeededSound(@Nullable Entity player, double x, double y, double z, Holder<SoundEvent> sound, SoundSource category, float volume, float pitch, long seed) {
    }

    public void playSeededSound(@Nullable Entity player, Entity entity, Holder<SoundEvent> sound, SoundSource category, float volume, float pitch, long seed) {
    }

    public void explode(@Nullable Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double x, double y, double z, float radius, boolean fire, Level.ExplosionInteraction explosionInteraction, ParticleOptions smallExplosionParticles, ParticleOptions largeExplosionParticles, Holder<SoundEvent> explosionSound) {
    }

    public String gatherChunkSourceStats() {
        return this.delegate.gatherChunkSourceStats();
    }

    public TickRateManager tickRateManager() {
        return this.delegate.tickRateManager();
    }

    @Nullable
    public MapItemSavedData getMapData(MapId mapId) {
        return null;
    }

    public void destroyBlockProgress(int breakerId, BlockPos pos, int progress) {
    }

    public Scoreboard getScoreboard() {
        return this.delegate.getScoreboard();
    }

    public RecipeAccess recipeAccess() {
        return this.delegate.recipeAccess();
    }

    public PotionBrewing potionBrewing() {
        return this.delegate.potionBrewing();
    }

    public FuelValues fuelValues() {
        return this.delegate.fuelValues();
    }

    public void setDayTimeFraction(float dayTimeFraction) {
    }

    public float getDayTimeFraction() {
        return this.delegate.getDayTimeFraction();
    }

    public float getDayTimePerTick() {
        return this.delegate.getDayTimePerTick();
    }

    public void setDayTimePerTick(float dayTimePerTick) {
    }

    public ChunkSource getChunkSource() {
        return this.delegate.getChunkSource();
    }

    public void levelEvent(@Nullable Entity player, int type, BlockPos pos, int data) {
    }

    public void gameEvent(Holder<GameEvent> gameEvent, Vec3 pos, GameEvent.Context context) {
    }

    public float getShade(Direction direction, boolean shade) {
        return this.delegate.getShade(direction, shade);
    }

    public Holder<Biome> getUncachedNoiseBiome(int x, int y, int z) {
        return this.delegate.getUncachedNoiseBiome(x, y, z);
    }

    public int getSeaLevel() {
        return this.delegate.getSeaLevel();
    }

    public FeatureFlagSet enabledFeatures() {
        return this.delegate.enabledFeatures();
    }

    public LevelTickAccess<Block> getBlockTicks() {
        return BlackholeTickAccess.emptyLevelList();
    }

    public LevelTickAccess<Fluid> getFluidTicks() {
        return BlackholeTickAccess.emptyLevelList();
    }
}

