/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.multiblock;

import dev.apexstudios.apexcore.lib.block.SimpleBedBlock;
import dev.apexstudios.apexcore.lib.multiblock.MultiBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public abstract class BedMultiBlock
extends SimpleBedBlock
implements MultiBlock {
    public BedMultiBlock(@Nullable DyeColor color, BlockBehaviour.Properties properties) {
        super(color, properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)this.getMultiBlockProperty(), (Comparable)Integer.valueOf(0)));
    }

    public BedMultiBlock(BlockBehaviour.Properties properties) {
        this(null, properties);
    }

    protected boolean isHead(BlockState blockState) {
        int index = MultiBlock.getIndex(blockState);
        return index == 1 || index == 2;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{this.getMultiBlockProperty()});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState placementBlockState = super.getStateForPlacement(context);
        if (placementBlockState == null || !MultiBlock.canPlace(context, placementBlockState)) {
            return null;
        }
        return placementBlockState;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState blockState, @Nullable LivingEntity placer, ItemStack stack) {
        MultiBlock.setBlockStates(level, pos, blockState, otherBlockState -> {
            BedPart part = this.isHead((BlockState)otherBlockState) ? BedPart.HEAD : BedPart.FOOT;
            return (BlockState)otherBlockState.setValue((Property)PART, (Comparable)part);
        });
    }

    public void destroy(LevelAccessor level, BlockPos pos, BlockState blockState) {
        super.destroy(level, pos, blockState);
        MultiBlock.destroyBlocks(level, pos, blockState);
    }

    protected void spawnDestroyParticles(Level level, Player player, BlockPos pos, BlockState blockState) {
        super.spawnDestroyParticles(level, player, pos, blockState);
        MultiBlock.spawnDestroyParticles((LevelAccessor)level, pos, blockState, (Entity)player);
    }

    protected BlockState updateShape(BlockState blockState, LevelReader p_374508_, ScheduledTickAccess p_374420_, BlockPos p_49529_, Direction p_49526_, BlockPos p_49530_, BlockState p_49527_, RandomSource p_374423_) {
        return blockState;
    }

    public void setBedOccupied(BlockState blockState, Level level, BlockPos pos, LivingEntity sleeper, boolean occupied) {
        super.setBedOccupied(blockState, level, pos, sleeper, occupied);
        Direction direction = BedMultiBlock.getConnectedDirection((BlockState)blockState);
        BlockPos otherPos = pos.relative(direction);
        BlockState otherBlockState = level.getBlockState(otherPos);
        if (otherBlockState.is(blockState.getBlock())) {
            super.setBedOccupied(otherBlockState, level, otherPos, sleeper, occupied);
        }
    }
}

