/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.apexstudios.apexcore.lib.block.IRenderBreakingTextureExtension;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockRenderDispatcher.class})
public class BlockRenderDispatcherMixin {
    @Shadow
    @Final
    private BlockModelShaper blockModelShaper;
    @Shadow
    @Final
    private RandomSource singleThreadRandom;
    @Shadow
    @Final
    private List<BlockModelPart> singleThreadPartList;
    @Shadow
    @Final
    private ModelBlockRenderer modelRenderer;

    @Inject(method={"renderBreakingTexture"}, at={@At(value="TAIL")})
    private void ApexCore$renderBreakingTexture(BlockState blockState, BlockPos pos, BlockAndTintGetter level, PoseStack pose, VertexConsumer consumer, CallbackInfo ci) {
        IRenderBreakingTextureExtension extension = IRenderBreakingTextureExtension.of(blockState);
        if (extension == null || !extension.shouldApplyBreakingTexture(level, pos, blockState)) {
            return;
        }
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        Vec3 camPos = camera.getPosition();
        double camX = camPos.x();
        double camY = camPos.y();
        double camZ = camPos.z();
        double camOffsetX = (double)pos.getX() - camX;
        double camOffsetY = (double)pos.getY() - camY;
        double camOffsetZ = (double)pos.getZ() - camZ;
        pose.pushPose();
        pose.translate(-camOffsetX, -camOffsetY, -camOffsetZ);
        extension.translateBreakingTexture(level, pos, blockState, (otherPos, otherBlockState) -> {
            if (extension.shouldRenderBreakingTexture(level, pos, blockState, (BlockPos)otherPos, (BlockState)otherBlockState)) {
                pose.pushPose();
                pose.translate((double)otherPos.getX() - camX, (double)otherPos.getY() - camY, (double)otherPos.getZ() - camZ);
                BlockStateModel model = this.blockModelShaper.getBlockModel(otherBlockState);
                this.singleThreadRandom.setSeed(otherBlockState.getSeed(otherPos));
                this.singleThreadPartList.clear();
                model.collectParts(level, otherPos, otherBlockState, this.singleThreadRandom, this.singleThreadPartList);
                this.modelRenderer.tesselateBlock(level, this.singleThreadPartList, otherBlockState, otherPos, pose, $ -> consumer, true, OverlayTexture.NO_OVERLAY);
                pose.popPose();
            }
        });
        pose.popPose();
    }
}

