/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.block;

import dev.apexstudios.fantasyfurniture.block.InventoryBlock;
import dev.apexstudios.fantasyfurniture.block.property.CounterConnection;
import dev.apexstudios.fantasyfurniture.util.FurnitureUtil;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CounterBlock
extends InventoryBlock {
    private final Map<Direction, VoxelShape> cornerShapes;
    private final Map<Direction, VoxelShape> shapes;

    public CounterBlock(BlockBehaviour.Properties properties, VoxelShape baseShape, VoxelShape cornerShape) {
        super(properties);
        this.shapes = Shapes.rotateHorizontal((VoxelShape)baseShape);
        this.cornerShapes = Shapes.rotateHorizontal((VoxelShape)cornerShape);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(CounterConnection.PROPERTY, (Comparable)((Object)CounterConnection.NONE)));
    }

    protected VoxelShape getShape(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext context) {
        Map<Direction, VoxelShape> shapes = ((CounterConnection)((Object)blockState.getValue(CounterConnection.PROPERTY))).isCorner() ? this.cornerShapes : this.shapes;
        return FurnitureUtil.getShape(shapes, blockState, pos);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CounterConnection.PROPERTY});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockState = super.getStateForPlacement(context);
        if (blockState == null) {
            return null;
        }
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        return CounterConnection.setConnection((BlockGetter)level, pos, blockState);
    }

    public BlockState updateShape(BlockState blockState, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction facing, BlockPos neighborPos, BlockState neighborBlockState, RandomSource random) {
        BlockState result = blockState;
        if (facing.getAxis().isHorizontal()) {
            result = CounterConnection.setConnection((BlockGetter)level, pos, result);
        }
        return super.updateShape(result, level, tickAccess, pos, facing, neighborPos, neighborBlockState, random);
    }
}

