/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.block;

import dev.apexstudios.fantasyfurniture.block.SeatBlock;
import dev.apexstudios.fantasyfurniture.block.property.SofaConnection;
import dev.apexstudios.fantasyfurniture.util.FurnitureUtil;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SofaBlock
extends SeatBlock {
    private final Map<Direction, VoxelShape> leftShapes;
    private final Map<Direction, VoxelShape> rightShapes;
    private final Map<Direction, VoxelShape> centerShapes;
    private final Map<Direction, VoxelShape> cornerShapes;
    private final Map<Direction, VoxelShape> singleShapes;

    public SofaBlock(BlockBehaviour.Properties properties, VoxelShape leftShape, VoxelShape rightShape, VoxelShape centerShape, VoxelShape cornerShape, VoxelShape singleShape) {
        super(properties);
        this.leftShapes = Shapes.rotateHorizontal((VoxelShape)leftShape);
        this.rightShapes = Shapes.rotateHorizontal((VoxelShape)rightShape);
        this.centerShapes = Shapes.rotateHorizontal((VoxelShape)centerShape);
        this.cornerShapes = Shapes.rotateHorizontal((VoxelShape)cornerShape);
        this.singleShapes = Shapes.rotateHorizontal((VoxelShape)singleShape);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(SofaConnection.PROPERTY, (Comparable)((Object)SofaConnection.BOTH)));
    }

    protected VoxelShape getShape(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext context) {
        Map<Direction, VoxelShape> shapes = switch ((SofaConnection)((Object)blockState.getValue(SofaConnection.PROPERTY))) {
            default -> throw new MatchException(null, null);
            case SofaConnection.LEFT -> this.leftShapes;
            case SofaConnection.RIGHT -> this.rightShapes;
            case SofaConnection.BOTH -> this.centerShapes;
            case SofaConnection.NONE -> this.singleShapes;
            case SofaConnection.CORNER_INNER, SofaConnection.CORNER_OUTER -> this.cornerShapes;
        };
        return FurnitureUtil.getShape(shapes, blockState, pos);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{SofaConnection.PROPERTY});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockState = super.getStateForPlacement(context);
        if (blockState == null) {
            return null;
        }
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        return SofaConnection.setConnection((BlockGetter)level, pos, blockState);
    }

    public BlockState updateShape(BlockState blockState, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction facing, BlockPos neighborPos, BlockState neighborBlockState, RandomSource random) {
        BlockState result = blockState;
        if (facing.getAxis().isHorizontal()) {
            result = SofaConnection.setConnection((BlockGetter)level, pos, blockState);
        }
        return super.updateShape(result, level, tickAccess, pos, facing, neighborPos, neighborBlockState, random);
    }
}

