/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.ctm;

import com.google.gson.JsonObject;
import dev.apexstudios.apexcore.lib.data.provider.context.ProviderOutputContext;
import dev.apexstudios.fantasyfurniture.ctm.SimpleJsonProvider;
import java.nio.file.Path;
import java.util.function.Consumer;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.Block;

public class ExtendedBlockStateProvider
extends SimpleJsonProvider {
    @Override
    protected Path path(ProviderOutputContext context, Block block) {
        return context.outputPath(PackOutput.Target.RESOURCE_PACK, ExtendedBlockStateProvider.blockStatePath(block));
    }

    @Override
    protected JsonObject json(ProviderOutputContext context, Block block, Consumer<JsonObject> consumer) {
        JsonObject root = super.json(context, block, consumer);
        ResourceManager resourceManager = context.getResourceManager(PackType.CLIENT_RESOURCES);
        JsonObject blockState = ExtendedBlockStateProvider.existing(resourceManager, ExtendedBlockStateProvider.blockStatePath(block));
        ExtendedBlockStateProvider.copyInto(blockState, root);
        return root;
    }

    private static ResourceLocation blockStatePath(Block block) {
        return ExtendedBlockStateProvider.registryName(block).withPath(path -> "blockstates/" + path + ".json");
    }
}

