/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.ctm;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.apexstudios.apexcore.core.ApexCore;
import dev.apexstudios.apexcore.lib.data.ProviderType;
import dev.apexstudios.apexcore.lib.data.provider.context.ProviderOutputContext;
import dev.apexstudios.apexcore.lib.registree.Registree;
import dev.apexstudios.fantasyfurniture.FantasyFurniture;
import dev.apexstudios.fantasyfurniture.ctm.SimpleJsonProvider;
import dev.apexstudios.fantasyfurniture.util.FurnitureUtil;
import java.nio.file.Path;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

final class FusionProvider
extends SimpleJsonProvider {
    public static final String ID = "fusion";
    public static final ProviderType<FusionProvider> PROVIDER_TYPE = ProviderType.register((ResourceLocation)FantasyFurniture.identifier("ctm/fusion"), FusionProvider::new);
    private final Set<ResourceLocation> textures = Sets.newHashSet();

    FusionProvider() {
    }

    public void with(Registree registree) {
        FurnitureUtil.Names.block(registree, "carpet", carpet -> {
            Block wool = (Block)registree.getValueOrThrow(Registries.BLOCK, "wool");
            boolean tinted = FusionProvider.isDyeable(registree);
            this.with(wool, root -> this.model((JsonObject)root, wool, tinted, "minecraft:block/cube_all", ApexCore.id((String)"block/cube_all_tinted"), "all"));
            this.with((Block)carpet, root -> this.model((JsonObject)root, wool, tinted, "minecraft:block/carpet", ApexCore.id((String)"block/carpet_tinted"), "wool"));
        });
    }

    private void model(JsonObject root, Block wool, boolean tinted, String model, String tintModel, String textureKey) {
        root.addProperty("parent", tinted ? tintModel : model);
        root.add("textures", (JsonElement)Util.make((Object)new JsonObject(), texturesJson -> {
            ResourceLocation texture = FusionProvider.registryName(wool).withPath(path -> "block/ctm/" + path + "_simple_vertical");
            this.textures.add(texture);
            texturesJson.addProperty(textureKey, texture.toString());
            if (tinted) {
                ResourceLocation textureTint = FusionProvider.registryName(wool).withPath(path -> "block/ctm/" + path + "_tint_simple_vertical");
                this.textures.add(textureTint);
                texturesJson.addProperty(textureKey + "_tinted", textureTint.toString());
            }
        }));
    }

    private JsonObject texture(ResourceLocation texture) {
        JsonObject root = new JsonObject();
        root.addProperty("type", "connecting");
        root.addProperty("layout", "pieced");
        if (texture.getPath().contains("tint")) {
            root.addProperty("render_type", "cutout");
        }
        return root;
    }

    @Override
    protected JsonObject json(ProviderOutputContext context, Block block, Consumer<JsonObject> consumer) {
        JsonObject root = super.json(context, block, consumer);
        root.addProperty("type", "connecting");
        root.addProperty("loader", "fusion:model");
        root.add("connections", (JsonElement)Util.make((Object)new JsonArray(), $ -> $.add((JsonElement)Util.make((Object)new JsonObject(), $$ -> $$.addProperty("type", "is_same_block")))));
        return root;
    }

    @Override
    protected Path path(ProviderOutputContext context, Block block) {
        return context.outputPath(PackOutput.Target.RESOURCE_PACK, FusionProvider.registryName(block).withPath(path -> "models/block/" + path + ".json"));
    }

    @Override
    public CompletableFuture<?> generate(CachedOutput cache, ProviderOutputContext context) {
        return CompletableFuture.allOf(super.generate(cache, context), this.generateTextures(cache, context));
    }

    private CompletableFuture<?> generateTextures(CachedOutput cache, ProviderOutputContext context) {
        PackOutput.PathProvider pathProvider = context.pathProvider(PackOutput.Target.RESOURCE_PACK, "textures");
        return CompletableFuture.allOf((CompletableFuture[])this.textures.stream().map(texture -> DataProvider.saveStable((CachedOutput)cache, (JsonElement)((JsonElement)Util.make((Object)new JsonObject(), root -> root.add(ID, (JsonElement)this.texture((ResourceLocation)texture)))), (Path)pathProvider.file(texture, "png.mcmeta"))).toArray(CompletableFuture[]::new));
    }
}

