/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.station;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Runnables;
import dev.apexstudios.fantasyfurniture.station.FurnitureStationRecipe;
import dev.apexstudios.fantasyfurniture.station.FurnitureStationRecipeInput;
import dev.apexstudios.fantasyfurniture.station.FurnitureStationSetup;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public final class FurnitureStationMenu
extends AbstractContainerMenu {
    private final ContainerLevelAccess levelAccess;
    private final Player player;
    private final Container inputContainer = new SimpleContainer(3);
    private final Container resultContainer = new ResultContainer();
    private final DataSlot selectedRecipe = DataSlot.standalone();
    private Runnable listener = Runnables.doNothing();
    private long lastSoundTime = 0L;
    private final List<FurnitureStationRecipe> recipes = Lists.newArrayList();

    FurnitureStationMenu(int windowId, Inventory inventory, final ContainerLevelAccess levelAccess) {
        super((MenuType)FurnitureStationSetup.MENU.value(), windowId);
        this.levelAccess = levelAccess;
        this.player = inventory.player;
        int slotX = 8;
        this.addSlot(new InputSlot(0, slotX + 8 + 18, FurnitureStationRecipe::planks));
        this.addSlot(new InputSlot(1, slotX + 8 + 36, recipe -> recipe.wool().orElse(null)));
        this.addSlot(new InputSlot(2, slotX, FurnitureStationRecipe::bindingAgent));
        this.addSlot(new Slot(this.resultContainer, 0, 150, 8){

            public void onTake(Player player, ItemStack stack) {
                stack.onCraftedBy(player, stack.getCount());
                FurnitureStationMenu.this.inputContainer.removeItem(0, 1);
                FurnitureStationMenu.this.inputContainer.removeItem(1, 1);
                FurnitureStationMenu.this.inputContainer.removeItem(2, 1);
                FurnitureStationMenu.this.setupResultSlot();
                levelAccess.execute((level, pos) -> {
                    long gameTime = level.getGameTime();
                    if (FurnitureStationMenu.this.lastSoundTime != gameTime) {
                        FurnitureStationMenu.this.lastSoundTime = gameTime;
                        level.playSound(null, pos, SoundEvents.UI_STONECUTTER_TAKE_RESULT, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                });
                super.onTake(player, stack);
            }

            public boolean mayPlace(ItemStack stack) {
                return false;
            }
        });
        this.addStandardInventorySlots((Container)inventory, 8, 115);
        this.addDataSlot(this.selectedRecipe);
        this.selectedRecipe.set(-1);
    }

    FurnitureStationMenu(int windowId, Inventory inventory) {
        this(windowId, inventory, ContainerLevelAccess.NULL);
    }

    public int selectedRecipe() {
        return this.selectedRecipe.get();
    }

    public List<FurnitureStationRecipe> recipes() {
        return this.recipes;
    }

    public boolean hasInput() {
        return !this.inputContainer.isEmpty();
    }

    public void registerListener(Runnable listener) {
        this.listener = listener;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack stack2 = slot.getItem();
            Item item = stack2.getItem();
            stack = stack2.copy();
            int result = 3;
            int playerStart = result + 1;
            int playerEnd = playerStart + 27 - 1;
            int hotbarStart = playerEnd + 1;
            int hotbarEnd = hotbarStart + 8;
            if (index == result) {
                item.onCraftedBy(stack2, player);
                if (!this.moveItemStackTo(stack2, playerStart, hotbarEnd, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(stack2, stack);
            } else if (index >= 0 && index < result) {
                if (!this.moveItemStackTo(stack2, playerStart, hotbarEnd, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (index >= playerStart && index < hotbarStart) {
                if (!this.moveItemStackTo(stack2, 0, result, false)) {
                    return ItemStack.EMPTY;
                }
                if (!this.moveItemStackTo(stack2, hotbarStart, hotbarEnd, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (index >= hotbarStart && index < hotbarEnd) {
                if (!this.moveItemStackTo(stack2, 0, result, false)) {
                    return ItemStack.EMPTY;
                }
                if (!this.moveItemStackTo(stack2, playerStart, playerEnd, false)) {
                    return ItemStack.EMPTY;
                }
            }
            if (stack2.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            }
            slot.setChanged();
            if (stack2.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, stack2);
            this.broadcastChanges();
        }
        return stack;
    }

    public boolean stillValid(Player player) {
        return FurnitureStationMenu.stillValid((ContainerLevelAccess)this.levelAccess, (Player)player, (Block)((Block)FurnitureStationSetup.BLOCK.value()));
    }

    public boolean clickMenuButton(Player player, int id) {
        if (FurnitureStationMenu.isValidRecipeIndex(this.recipes, id)) {
            this.selectedRecipe.set(id);
            this.setupResultSlot();
        }
        return true;
    }

    public void removed(Player player) {
        super.removed(player);
        this.resultContainer.setItem(0, ItemStack.EMPTY);
        this.clearContainer(player, this.inputContainer);
    }

    private FurnitureStationRecipeInput asInput() {
        return new FurnitureStationRecipeInput(this.inputContainer.getItem(0), this.inputContainer.getItem(1), this.inputContainer.getItem(2));
    }

    private void setupRecipes() {
        this.resultContainer.setItem(0, ItemStack.EMPTY);
        this.selectedRecipe.set(-1);
        this.recipes.clear();
        FurnitureStationSetup.recipes(this.asInput(), this.player.level()).map(RecipeHolder::value).forEach(this.recipes::add);
        this.broadcastChanges();
    }

    private void setupResultSlot() {
        int index = this.selectedRecipe();
        this.resultContainer.setItem(0, ItemStack.EMPTY);
        if (this.hasInput() && FurnitureStationMenu.isValidRecipeIndex(this.recipes, index)) {
            FurnitureStationRecipe recipe = this.recipes.get(index);
            ItemStack result = recipe.assemble(this.asInput(), (HolderLookup.Provider)this.player.registryAccess());
            this.resultContainer.setItem(0, result);
        } else {
            this.setupRecipes();
        }
        this.broadcastChanges();
    }

    public static boolean isValidRecipeIndex(List<FurnitureStationRecipe> recipes, int index) {
        return index >= 0 && index < recipes.size();
    }

    private class InputSlot
    extends Slot {
        private final Function<FurnitureStationRecipe, @Nullable Ingredient> ingredientGetter;

        private InputSlot(int index, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable int x, Function<FurnitureStationRecipe, Ingredient> ingredientGetter) {
            super(FurnitureStationMenu.this.inputContainer, index, x, 8);
            this.ingredientGetter = ingredientGetter;
        }

        public void setChanged() {
            super.setChanged();
            FurnitureStationMenu.this.setupRecipes();
            FurnitureStationMenu.this.listener.run();
        }

        public boolean mayPlace(ItemStack stack) {
            Player player = FurnitureStationMenu.this.player;
            if (!(player instanceof ServerPlayer)) {
                return false;
            }
            ServerPlayer sPlayer = (ServerPlayer)player;
            Collection recipes = sPlayer.level().recipeAccess().recipeMap().byType((RecipeType)FurnitureStationSetup.RECIPE_TYPE.value());
            for (RecipeHolder holder : recipes) {
                Ingredient ingredient = this.ingredientGetter.apply((FurnitureStationRecipe)holder.value());
                if (ingredient == null || !ingredient.test(stack)) continue;
                return true;
            }
            return false;
        }
    }
}

