/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.station;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.apexstudios.apexcore.lib.registree.holder.DeferredBlock;
import dev.apexstudios.apexcore.lib.registree.holder.DeferredItem;
import dev.apexstudios.apexcore.lib.registree.holder.DeferredMenu;
import dev.apexstudios.apexcore.lib.registree.holder.DeferredRecipeSerializer;
import dev.apexstudios.fantasyfurniture.FantasyFurniture;
import dev.apexstudios.fantasyfurniture.station.FurnitureStationBlock;
import dev.apexstudios.fantasyfurniture.station.FurnitureStationClientSetup;
import dev.apexstudios.fantasyfurniture.station.FurnitureStationMenu;
import dev.apexstudios.fantasyfurniture.station.FurnitureStationRecipe;
import dev.apexstudios.fantasyfurniture.station.FurnitureStationRecipeInput;
import dev.apexstudios.fantasyfurniture.station.FurnitureStationScreen;
import java.util.stream.Stream;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

public interface FurnitureStationSetup {
    public static final DeferredBlock<FurnitureStationBlock> BLOCK = FantasyFurniture.REGISTREE.registerBlock("furniture_station", FurnitureStationBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final DeferredItem<BlockItem> BLOCK_ITEM = FantasyFurniture.REGISTREE.registerSimpleBlockItem(BLOCK);
    public static final DeferredMenu<FurnitureStationMenu> MENU = FantasyFurniture.REGISTREE.registerMenu("furniture_station", FurnitureStationMenu::new);
    public static final DeferredRecipeSerializer<FurnitureStationRecipe> RECIPE_SERIALIZER = FantasyFurniture.REGISTREE.registerRecipeSerializer("furniture_station", RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(FurnitureStationRecipe::group), (App)Ingredient.CODEC.fieldOf("planks").forGetter(FurnitureStationRecipe::planks), (App)Ingredient.CODEC.optionalFieldOf("wool").forGetter(FurnitureStationRecipe::wool), (App)Ingredient.CODEC.fieldOf("binding_agent").forGetter(FurnitureStationRecipe::bindingAgent), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(FurnitureStationRecipe::result)).apply((Applicative)instance, FurnitureStationRecipe::new)), StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, FurnitureStationRecipe::group, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, FurnitureStationRecipe::planks, (StreamCodec)ByteBufCodecs.optional((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC), FurnitureStationRecipe::wool, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, FurnitureStationRecipe::bindingAgent, (StreamCodec)ItemStack.STREAM_CODEC, FurnitureStationRecipe::result, FurnitureStationRecipe::new));
    public static final DeferredHolder<RecipeType<?>, RecipeType<FurnitureStationRecipe>> RECIPE_TYPE = FantasyFurniture.REGISTREE.registerForHolder(Registries.RECIPE_TYPE, "furniture_station", RecipeType::simple);
    public static final DeferredHolder<RecipeBookCategory, RecipeBookCategory> RECIPE_BOOK_CATEGORY = FantasyFurniture.REGISTREE.registerForHolder(Registries.RECIPE_BOOK_CATEGORY, "furniture_station", RecipeBookCategory::new);
    public static final TagKey<Item> BINDING_AGENT = FantasyFurniture.REGISTREE.tag(Registries.ITEM, "binding_agent");
    public static final int SLOT_PLANKS = 0;
    public static final int SLOT_WOOL = 1;
    public static final int SLOT_BINDING_AGENT = 2;
    public static final int SLOTS = 3;

    public static Stream<RecipeHolder<FurnitureStationRecipe>> recipes(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel sLevel = (ServerLevel)level;
            return sLevel.recipeAccess().recipeMap().byType((RecipeType)RECIPE_TYPE.value()).stream();
        }
        if (FMLEnvironment.dist.isClient()) {
            return FurnitureStationClientSetup.RECIPES.stream();
        }
        return Stream.empty();
    }

    public static Stream<RecipeHolder<FurnitureStationRecipe>> recipes(FurnitureStationRecipeInput input, Level level) {
        return FurnitureStationSetup.recipes(level).filter(recipe -> ((FurnitureStationRecipe)recipe.value()).matches(input, level));
    }

    public static void register(IEventBus modBus) {
        modBus.addListener(RegisterMenuScreensEvent.class, event -> event.register((MenuType)MENU.value(), FurnitureStationScreen::new));
        modBus.addListener(BuildCreativeModeTabContentsEvent.class, event -> {
            if (event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
                event.accept(BLOCK_ITEM);
            }
        });
        NeoForge.EVENT_BUS.addListener(OnDatapackSyncEvent.class, event -> event.sendRecipes(new RecipeType[]{(RecipeType)RECIPE_TYPE.value()}));
    }
}

