/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.core.data.provider;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import dev.apexstudios.apexcore.lib.data.provider.context.ProviderOutputContext;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public interface BaseProvider {
    public CompletableFuture<?> generate(CachedOutput var1, ProviderOutputContext var2);

    public static <E> CompletableFuture<?> saveAll(CachedOutput cache, Encoder<E> encoder, PackOutput.PathProvider pathProvider, Map<ResourceLocation, E> entries) {
        return BaseProvider.saveAll(cache, encoder, arg_0 -> ((PackOutput.PathProvider)pathProvider).json(arg_0), entries);
    }

    public static <E> CompletableFuture<?> saveAll(CachedOutput cache, HolderLookup.Provider registries, Encoder<E> encoder, PackOutput.PathProvider pathProvider, Map<ResourceLocation, E> entries) {
        return BaseProvider.saveAll(cache, registries, encoder, arg_0 -> ((PackOutput.PathProvider)pathProvider).json(arg_0), entries);
    }

    public static <E> CompletableFuture<?> saveAll(CachedOutput cache, DynamicOps<JsonElement> ops, Encoder<E> encoder, PackOutput.PathProvider pathProvider, Map<ResourceLocation, E> entries) {
        return BaseProvider.saveAll(cache, ops, encoder, arg_0 -> ((PackOutput.PathProvider)pathProvider).json(arg_0), entries);
    }

    public static <T, E> CompletableFuture<?> saveAll(CachedOutput cache, Encoder<E> encoder, Function<T, Path> pathProvider, Map<T, E> entries) {
        return BaseProvider.saveAll(cache, (DynamicOps<JsonElement>)JsonOps.INSTANCE, encoder, pathProvider, entries);
    }

    public static <T, E> CompletableFuture<?> saveAll(CachedOutput cache, HolderLookup.Provider registries, Encoder<E> encoder, Function<T, Path> pathProvider, Map<T, E> entries) {
        return BaseProvider.saveAll(cache, (DynamicOps<JsonElement>)registries.createSerializationContext((DynamicOps)JsonOps.INSTANCE), encoder, pathProvider, entries);
    }

    public static <T, E> CompletableFuture<?> saveAll(CachedOutput cache, DynamicOps<JsonElement> ops, Encoder<E> encoder, Function<T, Path> pathProvider, Map<T, E> entries) {
        return CompletableFuture.allOf((CompletableFuture[])entries.entrySet().stream().map(entry -> BaseProvider.saveStable(cache, ops, encoder, entry.getValue(), (Path)pathProvider.apply(entry.getKey()))).toArray(CompletableFuture[]::new));
    }

    public static <T> CompletableFuture<?> saveStable(CachedOutput cache, Encoder<T> encoder, T value, Path path) {
        return BaseProvider.saveStable(cache, (DynamicOps<JsonElement>)JsonOps.INSTANCE, encoder, value, path);
    }

    public static <T> CompletableFuture<?> saveStable(CachedOutput cache, HolderLookup.Provider registries, Encoder<T> encoder, T value, Path path) {
        return BaseProvider.saveStable(cache, (DynamicOps<JsonElement>)registries.createSerializationContext((DynamicOps)JsonOps.INSTANCE), encoder, value, path);
    }

    public static <T> CompletableFuture<?> saveStable(CachedOutput cache, DynamicOps<JsonElement> ops, Encoder<T> encoder, T value, Path path) {
        JsonElement json = (JsonElement)encoder.encodeStart(ops, value).getOrThrow();
        return BaseProvider.isEmpty(json) ? CompletableFuture.completedFuture(null) : DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)path);
    }

    public static boolean isEmpty(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return true;
        }
        if (json.isJsonObject()) {
            JsonObject obj = json.getAsJsonObject();
            if (obj.isEmpty()) {
                return true;
            }
            for (String key : obj.keySet()) {
                if (BaseProvider.isEmpty(obj.get(key))) continue;
                return false;
            }
            return true;
        }
        if (json.isJsonArray()) {
            JsonArray array = json.getAsJsonArray();
            if (array.isEmpty()) {
                return true;
            }
            for (JsonElement element : array) {
                if (BaseProvider.isEmpty(element)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

