/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.core.seat;

import com.google.common.base.Predicates;
import dev.apexstudios.apexcore.core.seat.SeatSetup;
import dev.apexstudios.apexcore.lib.component.block.types.SeatBlockComponent;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class SeatEntity
extends Entity {
    public SeatEntity(EntityType<? extends SeatEntity> entityType, Level level) {
        super(entityType, level);
        this.blocksBuilding = false;
    }

    public void tick() {
        super.tick();
        BlockState blockState = this.getInBlockState();
        if (!SeatBlockComponent.isOccupied(blockState) || this.getPassengers().size() != 1) {
            this.discard();
            return;
        }
        this.getPassengers().forEach(entity -> {
            if (!SeatBlockComponent.maySit(entity)) {
                entity.stopRiding();
            }
        });
    }

    public void onRemoval(Entity.RemovalReason reason) {
        if (reason.shouldDestroy()) {
            SeatBlockComponent.setOccupied(this.level(), this.blockPosition(), false);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public boolean hurtServer(ServerLevel level, DamageSource source, float v) {
        return false;
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
    }

    protected boolean canRide(Entity vehicle) {
        return false;
    }

    protected boolean canAddPassenger(Entity passenger) {
        return super.canAddPassenger(passenger) && SeatBlockComponent.maySit(passenger);
    }

    protected void addPassenger(Entity passenger) {
        passenger.setPose(Pose.SITTING);
        SeatBlockComponent.notifyCapabilityListeners(passenger, this.blockPosition(), this.getInBlockState(), true);
        super.addPassenger(passenger);
    }

    protected void removePassenger(Entity passenger) {
        passenger.setPose(Pose.STANDING);
        SeatBlockComponent.notifyCapabilityListeners(passenger, this.blockPosition(), this.getInBlockState(), false);
        super.removePassenger(passenger);
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        VoxelShape shape = this.getInBlockState().getCollisionShape((BlockGetter)this.level(), this.blockPosition()).move(Vec3.atCenterOf((Vec3i)this.blockPosition()));
        Vec3 pos = super.getPassengerRidingPosition(entity);
        return new Vec3(pos.x(), Math.min(pos.y(), shape.min(Direction.Axis.Y)), pos.z());
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        Vec3 dismountLocation = DismountHelper.findSafeDismountLocation((EntityType)this.getType(), (CollisionGetter)this.level(), (BlockPos)this.blockPosition(), (boolean)true);
        return dismountLocation == null ? super.getDismountLocationForPassenger(passenger) : dismountLocation;
    }

    public static boolean sit(Level level, BlockPos pos, LivingEntity sitter) {
        BlockState blockState = level.getBlockState(pos);
        if (SeatBlockComponent.isOccupied(blockState)) {
            return false;
        }
        if (!level.isClientSide) {
            SeatEntity entity = (SeatEntity)((EntityType)SeatSetup.ENTITY.value()).create(level, EntitySpawnReason.SPAWN_ITEM_USE);
            if (entity == null) {
                return false;
            }
            entity.moveTo(pos, 0.0f, 0.0f);
            List leashed = level.getEntities(EntityTypeTest.forClass(LivingEntity.class), sitter.getBoundingBox().inflate(8.0), ent -> {
                Leashable leashable;
                return ent instanceof Leashable && (leashable = (Leashable)ent).getLeashHolder() == sitter;
            });
            for (LivingEntity toSit : leashed) {
                if (!toSit.startRiding((Entity)entity)) continue;
                SeatBlockComponent.setOccupied(level, pos, true);
                level.addFreshEntity((Entity)entity);
                return true;
            }
            if (sitter.startRiding((Entity)entity)) {
                SeatBlockComponent.setOccupied(level, pos, true);
                level.addFreshEntity((Entity)entity);
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean unsit(Level level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos);
        if (!SeatBlockComponent.isOccupied(blockState)) {
            return false;
        }
        if (!level.isClientSide) {
            List seats = level.getEntities((EntityTypeTest)SeatSetup.ENTITY.value(), new AABB(pos).inflate(0.5), (Predicate)Predicates.alwaysTrue());
            for (SeatEntity entity : seats) {
                if (entity.getPassengers().isEmpty()) continue;
                entity.ejectPassengers();
                return true;
            }
            return false;
        }
        return true;
    }
}

