/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.component;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import dev.apexstudios.apexcore.lib.component.Component;
import dev.apexstudios.apexcore.lib.component.ComponentBuilder;
import dev.apexstudios.apexcore.lib.component.ComponentHolder;
import dev.apexstudios.apexcore.lib.component.ComponentRegistrar;
import dev.apexstudios.apexcore.lib.component.ComponentType;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.ApiStatus;

public interface ComponentHelper {
    @ApiStatus.Internal
    public static <TBase extends Component<TBase>, THolder extends ComponentHolder<TBase>> Map<ComponentType<TBase, ?, ?>, TBase> registerComponents(THolder holder, BiConsumer<THolder, ComponentRegistrar<TBase>> consumer) {
        var registrar = new ComponentRegistrar<TBase>(){
            private final Multimap<ComponentType<TBase, ?, ?>, UnaryOperator<? extends ComponentBuilder>> listeners = LinkedListMultimap.create();

            @Override
            public <TComponent extends TBase, TBuilder extends ComponentBuilder> ComponentRegistrar<TBase> register(ComponentType<TBase, TComponent, TBuilder> componentType, UnaryOperator<TBuilder> builder) {
                this.listeners.put(componentType, builder);
                return this;
            }
        };
        consumer.accept(holder, registrar);
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (ComponentType componentType : registrar.listeners.keySet()) {
            Object component = componentType.newInstance(holder, builder -> registrar.listeners.get((Object)componentType).forEach(modifier -> modifier.apply(builder)));
            map.put(componentType, component);
        }
        return Collections.unmodifiableMap(map);
    }

    public static <TValue extends Comparable<TValue>> void validateCompatibilities(Property<TValue> property, Iterable<? extends Property<TValue>> compatibilities) {
        List possibleValues = property.getPossibleValues();
        for (Property<TValue> compatibility : compatibilities) {
            if (compatibility.getPossibleValues().containsAll(possibleValues)) continue;
            String names = possibleValues.stream().map(arg_0 -> compatibility.getName(arg_0)).collect(Collectors.joining(",", "[", "]"));
            throw new IllegalStateException("Compatibility Property['" + compatibility.getName() + "'] does not support all possible values: " + names);
        }
    }
}

