/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.component;

import dev.apexstudios.apexcore.core.component.ComponentTypeImpl;
import dev.apexstudios.apexcore.lib.component.Component;
import dev.apexstudios.apexcore.lib.component.ComponentBuilder;
import dev.apexstudios.apexcore.lib.component.ComponentHolder;
import dev.apexstudios.apexcore.lib.component.block.BlockComponent;
import dev.apexstudios.apexcore.lib.component.block.entity.BlockEntityComponent;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public interface ComponentType<TBase extends Component<TBase>, TComponent extends TBase, TBuilder extends ComponentBuilder> {
    public ResourceLocation registryName();

    @ApiStatus.Internal
    public TComponent newInstance(ComponentHolder<TBase> var1, Consumer<TBuilder> var2);

    public static <TBase extends Component<TBase>, TComponent extends TBase, TBuilder extends ComponentBuilder> ComponentType<TBase, TComponent, TBuilder> register(Class<TBase> baseType, ResourceLocation registryName, Supplier<TBuilder> builderFactory, BiFunction<ComponentHolder<TBase>, TBuilder, TComponent> componentFactory) {
        return ComponentTypeImpl.register(baseType, registryName, builderFactory, componentFactory);
    }

    public static <TComponent extends BlockComponent, TBuilder extends ComponentBuilder> ComponentType<BlockComponent, TComponent, TBuilder> registerBlock(ResourceLocation registryName, Supplier<TBuilder> builderFactory, BiFunction<ComponentHolder<BlockComponent>, TBuilder, TComponent> componentFactory) {
        return ComponentType.register(BlockComponent.class, registryName, builderFactory, componentFactory);
    }

    public static <TComponent extends BlockComponent> ComponentType<BlockComponent, TComponent, ComponentBuilder> registerBlock(ResourceLocation registryName, Function<ComponentHolder<BlockComponent>, TComponent> componentFactory) {
        return ComponentType.registerBlock(registryName, ComponentBuilder.NOOP, (holder, builder) -> (BlockComponent)componentFactory.apply((ComponentHolder<BlockComponent>)holder));
    }

    public static <TComponent extends BlockEntityComponent, TBuilder extends ComponentBuilder> ComponentType<BlockEntityComponent, TComponent, TBuilder> registerBlockEntity(ResourceLocation registryName, Supplier<TBuilder> builderFactory, BiFunction<ComponentHolder<BlockEntityComponent>, TBuilder, TComponent> componentFactory) {
        return ComponentType.register(BlockEntityComponent.class, registryName, builderFactory, componentFactory);
    }

    public static <TComponent extends BlockEntityComponent> ComponentType<BlockEntityComponent, TComponent, ComponentBuilder> registerBlockEntity(ResourceLocation registryName, Function<ComponentHolder<BlockEntityComponent>, TComponent> componentFactory) {
        return ComponentType.registerBlockEntity(registryName, ComponentBuilder.NOOP, (holder, builder) -> (BlockEntityComponent)componentFactory.apply((ComponentHolder<BlockEntityComponent>)holder));
    }
}

