/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.component.block;

import dev.apexstudios.apexcore.lib.component.ComponentHelper;
import dev.apexstudios.apexcore.lib.component.ComponentHolder;
import dev.apexstudios.apexcore.lib.component.ComponentRegistrar;
import dev.apexstudios.apexcore.lib.component.ComponentType;
import dev.apexstudios.apexcore.lib.component.block.BlockComponent;
import dev.apexstudios.apexcore.lib.util.ApexUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface BlockComponentHelper {
    @ApiStatus.Internal
    public static <THolder extends Block> Map<ComponentType<BlockComponent, ?, ?>, BlockComponent> registerComponents(THolder holder, BiConsumer<THolder, ComponentRegistrar<BlockComponent>> consumer, Iterable<Property<?>> deprecatedProperties) {
        Map<ComponentType<BlockComponent, ?, ?>, BlockComponent> map = ComponentHelper.registerComponents(holder, consumer);
        ApexUtil.replaceBlockStateDefinition(holder, deprecatedProperties, properties -> map.values().forEach(component -> component.createBlockStateDefinition((Consumer<Property<?>>)properties)), defaultBlockState -> {
            for (BlockComponent component : map.values()) {
                defaultBlockState = component.registerDefaultBlockState((BlockState)defaultBlockState);
            }
            return defaultBlockState;
        });
        return map;
    }

    public static <THolder extends Block> Map<ComponentType<BlockComponent, ?, ?>, BlockComponent> registerComponents(THolder holder, BiConsumer<THolder, ComponentRegistrar<BlockComponent>> consumer, Property<?> ... deprecatedProperties) {
        return BlockComponentHelper.registerComponents(holder, consumer, Set.of(deprecatedProperties));
    }

    @Nullable
    public static BlockState getStateForPlacement(ComponentHolder<BlockComponent> holder, BlockPlaceContext context, BlockState blockState) {
        BlockState result = blockState;
        for (BlockComponent component : holder.getComponents()) {
            result = component.getStateForPlacement(context, result);
            if (result != null) continue;
            return null;
        }
        return result;
    }

    public static void playerDestroy(ComponentHolder<BlockComponent> holder, Level level, Player player, BlockPos pos, BlockState blockState, ItemStack stack) {
        holder.getComponents().forEach(component -> component.playerDestroy(level, player, pos, blockState, stack));
    }

    public static void setPlacedBy(ComponentHolder<BlockComponent> holder, Level level, BlockPos pos, BlockState blockState, @Nullable LivingEntity placer, ItemStack stack) {
        holder.getComponents().forEach(component -> component.setPlacedBy(level, pos, blockState, placer, stack));
    }

    public static BlockState playerWillDestroy(ComponentHolder<BlockComponent> holder, Level level, BlockPos pos, BlockState blockState, Player player) {
        BlockState result = blockState;
        for (BlockComponent component : holder.getComponents()) {
            result = component.playerWillDestroy(level, pos, blockState, player);
        }
        return result;
    }

    public static BlockState updateShape(ComponentHolder<BlockComponent> holder, BlockState blockState, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction facing, BlockPos neighborPos, BlockState neighborBlockState, RandomSource random) {
        BlockState result = blockState;
        for (BlockComponent component : holder.getComponents()) {
            result = component.updateShape(result, level, tickAccess, pos, facing, neighborPos, neighborBlockState, random);
        }
        return result;
    }

    public static void neighborChanged(ComponentHolder<BlockComponent> holder, BlockState blockState, Level level, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        holder.getComponents().forEach(component -> component.neighborChanged(blockState, level, pos, neighborBlock, orientation, movedByPiston));
    }

    public static void onPlace(ComponentHolder<BlockComponent> holder, BlockState blockState, Level level, BlockPos pos, BlockState oldBlockState, boolean movedByPiston) {
        holder.getComponents().forEach(component -> component.onPlace(blockState, level, pos, oldBlockState, movedByPiston));
    }

    public static void onRemove(ComponentHolder<BlockComponent> holder, BlockState blockState, Level level, BlockPos pos, BlockState newBlockState, boolean movedByPiston) {
        holder.getComponents().forEach(component -> component.onRemove(blockState, level, pos, newBlockState, movedByPiston));
    }

    public static InteractionResult useItemOn(ComponentHolder<BlockComponent> holder, ItemStack stack, BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        for (BlockComponent component : holder.getComponents()) {
            InteractionResult interactionResult = component.useItemOn(stack, blockState, level, pos, player, hand, result);
            if (!interactionResult.consumesAction()) continue;
            return interactionResult;
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult useWithoutItem(ComponentHolder<BlockComponent> holder, BlockState blockState, Level level, BlockPos pos, Player player, BlockHitResult result) {
        for (BlockComponent component : holder.getComponents()) {
            InteractionResult interactionResult = component.useWithoutItem(blockState, level, pos, player, result);
            if (!interactionResult.consumesAction()) continue;
            return interactionResult;
        }
        return InteractionResult.PASS;
    }

    public static int getAnalogOutputSignal(ComponentHolder<BlockComponent> holder, BlockState blockState, Level level, BlockPos pos) {
        int result = 0;
        for (BlockComponent component : holder.getComponents()) {
            int signal = component.getAnalogOutputSignal(blockState, level, pos);
            if (signal <= 0) continue;
            result += signal;
        }
        return result;
    }

    public static boolean hasAnalogOutputSignal(ComponentHolder<BlockComponent> holder, BlockState blockState) {
        for (BlockComponent component : holder.getComponents()) {
            if (!component.hasAnalogOutputSignal(blockState)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPathfindable(ComponentHolder<BlockComponent> holder, BlockState blockState, PathComputationType pathType) {
        for (BlockComponent component : holder.getComponents()) {
            if (component.isPathfindable(blockState, pathType)) continue;
            return false;
        }
        return true;
    }

    public static void tick(ComponentHolder<BlockComponent> holder, BlockState blockState, ServerLevel level, BlockPos pos, RandomSource random) {
        holder.getComponents().forEach(component -> component.tick(blockState, level, pos, random));
    }

    public static void entityInside(ComponentHolder<BlockComponent> holder, BlockState blockState, Level level, BlockPos pos, Entity entity) {
        holder.getComponents().forEach(component -> component.entityInside(blockState, level, pos, entity));
    }

    public static void handlePrecipitation(ComponentHolder<BlockComponent> holder, BlockState blockState, Level level, BlockPos pos, Biome.Precipitation precipitation) {
        holder.getComponents().forEach(component -> component.handlePrecipitation(blockState, level, pos, precipitation));
    }

    public static void stepOn(ComponentHolder<BlockComponent> holder, Level level, BlockPos pos, BlockState blockState, Entity entity) {
        holder.getComponents().forEach(component -> component.stepOn(level, pos, blockState, entity));
    }

    public static BlockState rotate(ComponentHolder<BlockComponent> holder, BlockState blockState, Rotation rotation) {
        BlockState result = blockState;
        for (BlockComponent component : holder.getComponents()) {
            result = component.rotate(blockState, rotation);
        }
        return result;
    }

    public static BlockState mirror(ComponentHolder<BlockComponent> holder, BlockState blockState, Mirror mirror) {
        BlockState result = blockState;
        for (BlockComponent component : holder.getComponents()) {
            result = component.mirror(blockState, mirror);
        }
        return result;
    }

    public static FluidState getFluidState(ComponentHolder<BlockComponent> holder, BlockState blockState, FluidState defaultFluidState) {
        FluidState fluidState = defaultFluidState;
        for (BlockComponent component : holder.getComponents()) {
            fluidState = component.getFluidState(blockState, fluidState);
        }
        return fluidState;
    }

    public static void onExplosionHit(ComponentHolder<BlockComponent> holder, BlockState blockState, ServerLevel level, BlockPos pos, Explosion explosion, BiConsumer<ItemStack, BlockPos> dropsConsumer) {
        holder.getComponents().forEach(component -> component.onExplosionHit(blockState, level, pos, explosion, dropsConsumer));
    }

    public static boolean updateEntityMovementAfterFallOn(ComponentHolder<BlockComponent> holder, BlockGetter level, Entity entity) {
        for (BlockComponent component : holder.getComponents()) {
            if (!component.updateEntityMovementAfterFallOn(level, entity)) continue;
            return true;
        }
        return false;
    }

    public static void modifyCloneItemStack(ComponentHolder<BlockComponent> holder, ItemStack stack, LevelReader level, BlockPos pos, BlockState blockState, boolean includeData) {
        for (BlockComponent component : holder.getComponents()) {
            component.modifyCloneItemStack(stack, level, pos, blockState, includeData);
        }
    }

    public static void modifyCloneItemStack(ComponentHolder<BlockComponent> holder, ItemStack stack, LevelReader level, BlockPos pos, BlockState blockState, boolean includeData, Player player) {
        for (BlockComponent component : holder.getComponents()) {
            component.modifyCloneItemStack(stack, level, pos, blockState, includeData, player);
        }
    }

    @Nullable
    public static <TComponent extends BlockComponent> TComponent getComponent(BlockState blockState, ComponentType<BlockComponent, TComponent, ?> componentType) {
        ComponentHolder<BlockComponent> holder = BlockComponentHelper.asHolder(blockState);
        return (TComponent)(holder == null ? null : (BlockComponent)holder.getComponent(componentType));
    }

    public static <TComponent extends BlockComponent> Optional<TComponent> findComponent(BlockState blockState, ComponentType<BlockComponent, TComponent, ?> componentType) {
        ComponentHolder<BlockComponent> holder = BlockComponentHelper.asHolder(blockState);
        return holder == null ? Optional.empty() : holder.findComponent(componentType);
    }

    public static <TComponent extends BlockComponent> TComponent getComponentOrThrow(BlockState blockState, ComponentType<BlockComponent, TComponent, ?> componentType) {
        return (TComponent)((BlockComponent)BlockComponentHelper.asHolderOrThrow(blockState).getComponentOrThrow(componentType));
    }

    public static <TComponent extends BlockComponent> void runForComponent(BlockState blockState, ComponentType<BlockComponent, TComponent, ?> componentType, Consumer<TComponent> action) {
        ComponentHolder<BlockComponent> holder = BlockComponentHelper.asHolder(blockState);
        if (holder != null) {
            holder.runForComponent(componentType, action);
        }
    }

    public static boolean hasComponent(BlockState blockState, ComponentType<BlockComponent, ?, ?> componentType) {
        ComponentHolder<BlockComponent> holder = BlockComponentHelper.asHolder(blockState);
        return holder != null && holder.hasComponent(componentType);
    }

    public static Set<ComponentType<BlockComponent, ?, ?>> getComponentTypes(BlockState blockState) {
        ComponentHolder<BlockComponent> holder = BlockComponentHelper.asHolder(blockState);
        return holder == null ? Collections.emptySet() : holder.getComponentTypes();
    }

    public static Collection<BlockComponent> getComponents(BlockState blockState) {
        ComponentHolder<BlockComponent> holder = BlockComponentHelper.asHolder(blockState);
        return holder == null ? Collections.emptyList() : holder.getComponents();
    }

    @Nullable
    public static ComponentHolder<BlockComponent> asHolder(BlockState blockState) {
        Block block = blockState.getBlock();
        return block instanceof ComponentHolder ? (ComponentHolder)block : null;
    }

    public static ComponentHolder<BlockComponent> asHolderOrThrow(BlockState blockState) {
        return (ComponentHolder)blockState.getBlock();
    }
}

