/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.component.block;

import com.google.errorprone.annotations.ForOverride;
import dev.apexstudios.apexcore.lib.component.ComponentHolder;
import dev.apexstudios.apexcore.lib.component.ComponentRegistrar;
import dev.apexstudios.apexcore.lib.component.ComponentType;
import dev.apexstudios.apexcore.lib.component.block.BlockComponent;
import dev.apexstudios.apexcore.lib.component.block.BlockComponentHelper;
import dev.apexstudios.apexcore.lib.component.block.BlockComponentTypes;
import dev.apexstudios.apexcore.lib.component.block.types.BedBlockComponent;
import dev.apexstudios.apexcore.lib.component.block.types.FacingBlockComponent;
import dev.apexstudios.apexcore.lib.component.block.types.FluidLoggedBlockComponent;
import dev.apexstudios.apexcore.lib.component.block.types.MultiBlockComponent;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;

public class DoorBlockComponentHolder
extends DoorBlock
implements ComponentHolder<BlockComponent>,
BucketPickup,
LiquidBlockContainer {
    private final Map<ComponentType<BlockComponent, ?, ?>, BlockComponent> components = BlockComponentHelper.registerComponents(this, (holder, registrar) -> {
        holder.registerRequiredComponents((ComponentRegistrar<BlockComponent>)registrar);
        holder.registerComponents((ComponentRegistrar<BlockComponent>)registrar);
    }, new Property[]{DoorBlock.FACING});

    public DoorBlockComponentHolder(BlockSetType type, BlockBehaviour.Properties properties) {
        super(type, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)HINGE, (Comparable)DoorHingeSide.LEFT)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public DoorBlockComponentHolder(BlockBehaviour.Properties properties) {
        super(BlockSetType.OAK, properties);
    }

    protected boolean openMenu(Level level, BlockPos pos, BlockState blockState, Player player) {
        MenuProvider menuProvider = blockState.getMenuProvider(level, pos);
        if (menuProvider == null) {
            return false;
        }
        player.openMenu(menuProvider);
        return true;
    }

    private void registerRequiredComponents(ComponentRegistrar<BlockComponent> registrar) {
        FacingBlockComponent.registerHorizontal(registrar, builder -> builder.facingForPlacement(UseOnContext::getHorizontalDirection));
    }

    @ForOverride
    protected void registerComponents(ComponentRegistrar<BlockComponent> registrar) {
    }

    @Override
    @Nullable
    public final <TComponent extends BlockComponent> TComponent getComponent(ComponentType<BlockComponent, TComponent, ?> componentType) {
        return (TComponent)this.components.get(componentType);
    }

    @Override
    public final <TComponent extends BlockComponent> Optional<TComponent> findComponent(ComponentType<BlockComponent, TComponent, ?> componentType) {
        return ComponentHolder.super.findComponent(componentType);
    }

    @Override
    public final <TComponent extends BlockComponent> TComponent getComponentOrThrow(ComponentType<BlockComponent, TComponent, ?> componentType) {
        return (TComponent)((BlockComponent)ComponentHolder.super.getComponentOrThrow(componentType));
    }

    @Override
    public final <TComponent extends BlockComponent> void runForComponent(ComponentType<BlockComponent, TComponent, ?> componentType, Consumer<TComponent> action) {
        ComponentHolder.super.runForComponent(componentType, action);
    }

    @Override
    public final boolean hasComponent(ComponentType<BlockComponent, ?, ?> componentType) {
        return ComponentHolder.super.hasComponent(componentType);
    }

    @Override
    public final Set<ComponentType<BlockComponent, ?, ?>> getComponentTypes() {
        return this.components.keySet();
    }

    @Override
    public final Collection<BlockComponent> getComponents() {
        return this.components.values();
    }

    @MustBeInvokedByOverriders
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockState = BlockComponentHelper.getStateForPlacement(this, context, this.defaultBlockState());
        return blockState == null ? null : this.getDoorBlockStateForPlacement(context, blockState);
    }

    @MustBeInvokedByOverriders
    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState blockState, @Nullable BlockEntity blockEntity, ItemStack stack) {
        BlockComponentHelper.playerDestroy(this, level, player, pos, blockState, stack);
        super.playerDestroy(level, player, pos, blockState, blockEntity, stack);
    }

    @MustBeInvokedByOverriders
    public void setPlacedBy(Level level, BlockPos pos, BlockState blockState, @Nullable LivingEntity placer, ItemStack stack) {
        BlockComponentHelper.setPlacedBy(this, level, pos, blockState, placer, stack);
    }

    @MustBeInvokedByOverriders
    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState blockState, Player player) {
        BlockState result = BlockComponentHelper.playerWillDestroy(this, level, pos, blockState, player);
        return super.playerWillDestroy(level, pos, result, player);
    }

    @MustBeInvokedByOverriders
    public BlockState updateShape(BlockState blockState, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction facing, BlockPos neighborPos, BlockState neighborBlockState, RandomSource random) {
        return BlockComponentHelper.updateShape(this, blockState, level, tickAccess, pos, facing, neighborPos, neighborBlockState, random);
    }

    @MustBeInvokedByOverriders
    public void neighborChanged(BlockState blockState, Level level, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        BlockComponentHelper.neighborChanged(this, blockState, level, pos, neighborBlock, orientation, movedByPiston);
        this.doorNeighborChanged(blockState, level, pos, neighborBlock, orientation, movedByPiston);
    }

    @MustBeInvokedByOverriders
    public void onPlace(BlockState blockState, Level level, BlockPos pos, BlockState oldBlockState, boolean movedByPiston) {
        BlockComponentHelper.onPlace(this, blockState, level, pos, oldBlockState, movedByPiston);
        super.onPlace(blockState, level, pos, oldBlockState, movedByPiston);
    }

    @MustBeInvokedByOverriders
    public void onRemove(BlockState blockState, Level level, BlockPos pos, BlockState newBlockState, boolean movedByPiston) {
        BlockComponentHelper.onRemove(this, blockState, level, pos, newBlockState, movedByPiston);
        super.onRemove(blockState, level, pos, newBlockState, movedByPiston);
    }

    @MustBeInvokedByOverriders
    public InteractionResult useItemOn(ItemStack stack, BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        InteractionResult interactionResult = BlockComponentHelper.useItemOn(this, stack, blockState, level, pos, player, hand, result);
        if (interactionResult.consumesAction()) {
            return interactionResult;
        }
        return super.useItemOn(stack, blockState, level, pos, player, hand, result);
    }

    @MustBeInvokedByOverriders
    public InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos pos, Player player, BlockHitResult result) {
        InteractionResult interactionResult = BlockComponentHelper.useWithoutItem(this, blockState, level, pos, player, result);
        if (interactionResult.consumesAction()) {
            return interactionResult;
        }
        if (this.openMenu(level, pos, blockState, player)) {
            return InteractionResult.SUCCESS;
        }
        return this.useDoor(blockState, level, pos, player, result);
    }

    @MustBeInvokedByOverriders
    protected int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        int componentSignal = BlockComponentHelper.getAnalogOutputSignal(this, blockState, level, pos);
        return componentSignal + super.getAnalogOutputSignal(blockState, level, pos);
    }

    @MustBeInvokedByOverriders
    protected boolean hasAnalogOutputSignal(BlockState blockState) {
        boolean hasSignal = BlockComponentHelper.hasAnalogOutputSignal(this, blockState);
        return hasSignal || super.hasAnalogOutputSignal(blockState);
    }

    @MustBeInvokedByOverriders
    protected boolean isPathfindable(BlockState blockState, PathComputationType pathType) {
        boolean isPathfindable = BlockComponentHelper.isPathfindable(this, blockState, pathType);
        return super.hasAnalogOutputSignal(blockState) && isPathfindable;
    }

    @MustBeInvokedByOverriders
    protected void tick(BlockState blockState, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockComponentHelper.tick(this, blockState, level, pos, random);
        super.tick(blockState, level, pos, random);
    }

    @MustBeInvokedByOverriders
    public void entityInside(BlockState blockState, Level level, BlockPos pos, Entity entity) {
        BlockComponentHelper.entityInside(this, blockState, level, pos, entity);
        super.entityInside(blockState, level, pos, entity);
    }

    @MustBeInvokedByOverriders
    public void handlePrecipitation(BlockState blockState, Level level, BlockPos pos, Biome.Precipitation precipitation) {
        BlockComponentHelper.handlePrecipitation(this, blockState, level, pos, precipitation);
        super.handlePrecipitation(blockState, level, pos, precipitation);
    }

    @MustBeInvokedByOverriders
    public void stepOn(Level level, BlockPos pos, BlockState blockState, Entity entity) {
        BlockComponentHelper.stepOn(this, level, pos, blockState, entity);
        super.stepOn(level, pos, blockState, entity);
    }

    @MustBeInvokedByOverriders
    protected BlockState rotate(BlockState blockState, Rotation rotation) {
        BlockState result = BlockComponentHelper.rotate(this, blockState, rotation);
        return super.rotate(result, rotation);
    }

    @MustBeInvokedByOverriders
    protected BlockState mirror(BlockState blockState, Mirror mirror) {
        BlockState result = BlockComponentHelper.mirror(this, blockState, mirror);
        return super.mirror(result, mirror);
    }

    @MustBeInvokedByOverriders
    protected FluidState getFluidState(BlockState blockState) {
        FluidState defaultFluidState = super.getFluidState(blockState);
        return BlockComponentHelper.getFluidState(this, blockState, defaultFluidState);
    }

    @MustBeInvokedByOverriders
    public ItemStack pickupBlock(@Nullable Player player, LevelAccessor level, BlockPos pos, BlockState blockState) {
        FluidLoggedBlockComponent component = (FluidLoggedBlockComponent)this.getComponent(BlockComponentTypes.FLUID_LOGGED);
        return component == null ? ItemStack.EMPTY : component.pickupBlock(player, level, pos, blockState);
    }

    @MustBeInvokedByOverriders
    public Optional<SoundEvent> getPickupSound() {
        FluidLoggedBlockComponent component = (FluidLoggedBlockComponent)this.getComponent(BlockComponentTypes.FLUID_LOGGED);
        return component == null ? Optional.empty() : component.getPickupSound();
    }

    @MustBeInvokedByOverriders
    public Optional<SoundEvent> getPickupSound(BlockState blockState) {
        FluidLoggedBlockComponent component = (FluidLoggedBlockComponent)this.getComponent(BlockComponentTypes.FLUID_LOGGED);
        return component == null ? Optional.empty() : component.getPickupSound(blockState);
    }

    @MustBeInvokedByOverriders
    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter level, BlockPos pos, BlockState blockState, Fluid fluid) {
        FluidLoggedBlockComponent component = (FluidLoggedBlockComponent)this.getComponent(BlockComponentTypes.FLUID_LOGGED);
        return component != null && component.canPlaceLiquid(player, level, pos, blockState, fluid);
    }

    @MustBeInvokedByOverriders
    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState blockState, FluidState fluidState) {
        FluidLoggedBlockComponent component = (FluidLoggedBlockComponent)this.getComponent(BlockComponentTypes.FLUID_LOGGED);
        return component != null && component.placeLiquid(level, pos, blockState, fluidState);
    }

    @MustBeInvokedByOverriders
    protected void onExplosionHit(BlockState blockState, ServerLevel level, BlockPos pos, Explosion explosion, BiConsumer<ItemStack, BlockPos> dropConsumer) {
        BlockComponentHelper.onExplosionHit(this, blockState, level, pos, explosion, dropConsumer);
        super.onExplosionHit(blockState, level, pos, explosion, dropConsumer);
        this.onExplosionHitDoor(blockState, level, pos, explosion);
    }

    @MustBeInvokedByOverriders
    public void updateEntityMovementAfterFallOn(BlockGetter level, Entity entity) {
        if (!BlockComponentHelper.updateEntityMovementAfterFallOn(this, level, entity)) {
            super.updateEntityMovementAfterFallOn(level, entity);
        }
    }

    @MustBeInvokedByOverriders
    protected ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState blockState, boolean includeData) {
        ItemStack stack = super.getCloneItemStack(level, pos, blockState, includeData);
        BlockComponentHelper.modifyCloneItemStack(this, stack, level, pos, blockState, includeData);
        return stack;
    }

    public final boolean isBed(BlockState blockState, BlockGetter level, BlockPos pos, LivingEntity sleeper) {
        return this.hasComponent(BlockComponentTypes.BED);
    }

    public final void setBedOccupied(BlockState blockState, Level level, BlockPos pos, LivingEntity sleeper, boolean occupied) {
        this.runForComponent((ComponentType)BlockComponentTypes.BED, (Consumer<TComponent>)((Consumer<BedBlockComponent>)component -> component.setOccupied(level, pos, blockState, occupied)));
    }

    public final Direction getBedDirection(BlockState blockState, LevelReader level, BlockPos pos) {
        FacingBlockComponent facing = (FacingBlockComponent)this.getComponent(BlockComponentTypes.FACING);
        return facing == null ? Direction.NORTH : facing.get(blockState).getOpposite();
    }

    @MustBeInvokedByOverriders
    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState blockState, boolean includeData, Player player) {
        ItemStack stack = super.getCloneItemStack(level, pos, blockState, includeData);
        BlockComponentHelper.modifyCloneItemStack(this, stack, level, pos, blockState, includeData, player);
        return stack;
    }

    protected VoxelShape getShape(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = ((FacingBlockComponent)this.getComponentOrThrow(BlockComponentTypes.FACING)).get(blockState);
        boolean flag = (Boolean)blockState.getValue((Property)OPEN) == false;
        boolean flag1 = blockState.getValue((Property)HINGE) == DoorHingeSide.RIGHT;
        return switch (facing) {
            case Direction.SOUTH -> {
                if (flag) {
                    yield SOUTH_AABB;
                }
                if (flag1) {
                    yield EAST_AABB;
                }
                yield WEST_AABB;
            }
            case Direction.WEST -> {
                if (flag) {
                    yield WEST_AABB;
                }
                if (flag1) {
                    yield SOUTH_AABB;
                }
                yield NORTH_AABB;
            }
            case Direction.NORTH -> {
                if (flag) {
                    yield NORTH_AABB;
                }
                if (flag1) {
                    yield WEST_AABB;
                }
                yield EAST_AABB;
            }
            default -> flag ? EAST_AABB : (flag1 ? NORTH_AABB : SOUTH_AABB);
        };
    }

    private void onExplosionHitDoor(BlockState blockState, ServerLevel level, BlockPos pos, Explosion explosion) {
        boolean isOrigin = true;
        MultiBlockComponent multiBlock = (MultiBlockComponent)this.getComponent(BlockComponentTypes.MULTI_BLOCK);
        if (multiBlock != null) {
            boolean bl = isOrigin = multiBlock.indexOf(blockState) == 0;
        }
        if (explosion.canTriggerBlocks() && isOrigin && this.type().canOpenByWindCharge() && !((Boolean)blockState.getValue((Property)POWERED)).booleanValue()) {
            this.setOpen(null, (Level)level, blockState, pos, !this.isOpen(blockState));
        }
    }

    private BlockState getDoorBlockStateForPlacement(BlockPlaceContext context, BlockState blockState) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        boolean hasPower = this.hasPower((SignalGetter)level, pos, blockState);
        Direction facing = ((FacingBlockComponent)this.getComponentOrThrow(BlockComponentTypes.FACING)).get(blockState);
        DoubleBlockHalf half = ((MultiBlockComponent)this.getComponentOrThrow(BlockComponentTypes.MULTI_BLOCK)).indexOf(blockState) == 0 ? DoubleBlockHalf.LOWER : DoubleBlockHalf.UPPER;
        return (BlockState)((BlockState)((BlockState)((BlockState)blockState.setValue((Property)HINGE, (Comparable)DoorBlockComponentHolder.getHinge(context, facing))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(hasPower))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(hasPower))).setValue((Property)HALF, (Comparable)half);
    }

    private InteractionResult useDoor(BlockState blockState, Level level, BlockPos pos, Player player, BlockHitResult result) {
        if (!this.type().canOpenByHand()) {
            return InteractionResult.PASS;
        }
        this.setOpen((Entity)player, level, blockState, pos, !this.isOpen(blockState));
        return InteractionResult.SUCCESS;
    }

    public void setOpen(@Nullable Entity entity, Level level, BlockState blockState, BlockPos pos, boolean open) {
        super.setOpen(entity, level, blockState, pos, open);
        this.runForComponent((ComponentType)BlockComponentTypes.MULTI_BLOCK, (Consumer<TComponent>)((Consumer<MultiBlockComponent>)multiBlock -> {
            int index = multiBlock.indexOf(blockState);
            BlockPos origin = multiBlock.getOrigin(pos, blockState);
            for (int i = 0; i < multiBlock.size(); ++i) {
                if (i == index) continue;
                BlockState otherBlockState = multiBlock.withIndex(blockState, i);
                BlockPos otherPos = multiBlock.getPos(origin, otherBlockState);
                if (this.isOpen(otherBlockState) == open) continue;
                level.setBlock(otherPos, (BlockState)otherBlockState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10);
            }
        }));
    }

    private void doorNeighborChanged(BlockState blockState, Level level, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        boolean hasPower = this.hasPower((SignalGetter)level, pos, blockState);
        if (hasPower != (Boolean)blockState.getValue((Property)POWERED)) {
            if (hasPower != this.isOpen(blockState)) {
                this.playSound(null, level, pos, hasPower);
                level.gameEvent(null, (Holder)(hasPower ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
            }
            level.setBlock(pos, (BlockState)((BlockState)blockState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(hasPower))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(hasPower)), 2);
            this.runForComponent((ComponentType)BlockComponentTypes.MULTI_BLOCK, (Consumer<TComponent>)((Consumer<MultiBlockComponent>)multiBlock -> {
                int index = multiBlock.indexOf(blockState);
                BlockPos origin = multiBlock.getOrigin(pos, blockState);
                for (int i = 0; i < multiBlock.size(); ++i) {
                    if (i == index) continue;
                    BlockState otherBlockState = multiBlock.withIndex(blockState, i);
                    BlockPos otherPos = multiBlock.getPos(origin, otherBlockState);
                    if (this.isOpen(otherBlockState) == hasPower) continue;
                    level.setBlock(otherPos, (BlockState)((BlockState)otherBlockState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(hasPower))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(hasPower)), 2);
                }
            }));
        }
    }

    private boolean hasPower(SignalGetter level, BlockPos pos, BlockState blockState) {
        MultiBlockComponent multiBlock = (MultiBlockComponent)this.getComponent(BlockComponentTypes.MULTI_BLOCK);
        if (multiBlock != null) {
            int index = multiBlock.indexOf(blockState);
            BlockPos origin = multiBlock.getOrigin(pos, blockState);
            for (int i = 0; i < multiBlock.size(); ++i) {
                BlockState otherBlockState;
                BlockPos otherPos;
                if (i == index || !level.hasNeighborSignal(otherPos = multiBlock.getPos(origin, otherBlockState = multiBlock.withIndex(blockState, i)))) continue;
                return true;
            }
        }
        return level.hasNeighborSignal(pos);
    }

    private void playSound(@Nullable Entity source, Level level, BlockPos pos, boolean isOpening) {
        level.playSound(source, pos, isOpening ? this.type().doorOpen() : this.type().doorClose(), SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.1f + 0.9f);
    }

    protected boolean canSurvive(BlockState blockState, LevelReader level, BlockPos pos) {
        return true;
    }

    protected long getSeed(BlockState state, BlockPos pos) {
        return Mth.getSeed((Vec3i)pos);
    }

    public static DoorHingeSide getHinge(BlockPlaceContext context, Direction facing) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction facingCCW = facing.getCounterClockWise();
        BlockPos posCCW = pos.relative(facingCCW);
        BlockState blockStateCCW = level.getBlockState(posCCW);
        Direction facingCW = facing.getClockWise();
        BlockPos posCW = pos.relative(facingCW);
        BlockState blockStateCW = level.getBlockState(posCW);
        int i = (blockStateCCW.isCollisionShapeFullBlock((BlockGetter)level, posCCW) ? -1 : 0) + (blockStateCW.isCollisionShapeFullBlock((BlockGetter)level, posCW) ? 1 : 0);
        boolean isDoorCCW = DoorBlockComponentHolder.isDoorOrigin(blockStateCCW);
        boolean isDoorCW = DoorBlockComponentHolder.isDoorOrigin(blockStateCW);
        if ((!isDoorCCW || isDoorCW) && i <= 0) {
            if ((!isDoorCW || isDoorCCW) && i >= 0) {
                int stepX = facing.getStepX();
                int stepZ = facing.getStepZ();
                Vec3 clickLocation = context.getClickLocation();
                double clickX = clickLocation.x - (double)pos.getX();
                double clickZ = clickLocation.z - (double)pos.getZ();
                return ((double)stepX >= 0.0 || clickZ >= 0.5) && ((double)stepX <= 0.0 || clickZ <= 0.5) && ((double)stepZ >= 0.0 || clickX <= 0.5) && ((double)stepZ <= 0.0 || clickX >= 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    private static boolean isDoorOrigin(BlockState blockState) {
        MultiBlockComponent multiBlock = BlockComponentHelper.getComponent(blockState, BlockComponentTypes.MULTI_BLOCK);
        if (multiBlock == null) {
            return true;
        }
        return multiBlock.indexOf(blockState) == 0;
    }
}

