/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.component.block.entity;

import dev.apexstudios.apexcore.lib.component.ComponentHolder;
import dev.apexstudios.apexcore.lib.component.ComponentRegistrar;
import dev.apexstudios.apexcore.lib.component.ComponentType;
import dev.apexstudios.apexcore.lib.component.block.entity.BlockEntityComponent;
import dev.apexstudios.apexcore.lib.component.block.entity.BlockEntityComponentTypes;
import dev.apexstudios.apexcore.lib.component.block.entity.types.InventoryBlockEntityComponent;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public interface BlockEntityComponentHelper {
    public static final String NBT_COMPONENTS = "Components";

    public static void playerDestroy(ComponentHolder<BlockEntityComponent> holder, Level level, Player player, BlockPos pos, BlockState blockState, ItemStack stack) {
        holder.getComponents().forEach(component -> component.playerDestroy(level, player, pos, blockState, stack));
    }

    public static void setPlacedBy(ComponentHolder<BlockEntityComponent> holder, Level level, BlockPos pos, BlockState blockState, @Nullable LivingEntity placer, ItemStack stack) {
        holder.getComponents().forEach(component -> component.setPlacedBy(level, pos, blockState, placer, stack));
    }

    public static BlockState playerWillDestroy(ComponentHolder<BlockEntityComponent> holder, Level level, BlockPos pos, BlockState blockState, Player player) {
        BlockState result = blockState;
        for (BlockEntityComponent component : holder.getComponents()) {
            result = component.playerWillDestroy(level, pos, result, player);
        }
        return result;
    }

    public static BlockState updateShape(ComponentHolder<BlockEntityComponent> holder, BlockState blockState, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction facing, BlockPos neighborPos, BlockState neighborBlockState, RandomSource random) {
        BlockState result = blockState;
        for (BlockEntityComponent component : holder.getComponents()) {
            result = component.updateShape(result, level, tickAccess, pos, facing, neighborPos, neighborBlockState, random);
        }
        return result;
    }

    public static void neighborChanged(ComponentHolder<BlockEntityComponent> holder, BlockState blockState, Level level, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        holder.getComponents().forEach(component -> component.neighborChanged(blockState, level, pos, neighborBlock, orientation, movedByPiston));
    }

    public static void onPlace(ComponentHolder<BlockEntityComponent> holder, BlockState blockState, Level level, BlockPos pos, BlockState oldBlockState, boolean movedByPiston) {
        holder.getComponents().forEach(component -> component.onPlace(blockState, level, pos, oldBlockState, movedByPiston));
    }

    public static void onRemove(ComponentHolder<BlockEntityComponent> holder, BlockState blockState, Level level, BlockPos pos, BlockState newBlockState, boolean movedByPiston) {
        holder.getComponents().forEach(component -> component.onRemove(blockState, level, pos, newBlockState, movedByPiston));
    }

    public static InteractionResult useItemOn(ComponentHolder<BlockEntityComponent> holder, ItemStack stack, BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        for (BlockEntityComponent component : holder.getComponents()) {
            InteractionResult interactionResult = component.useItemOn(stack, blockState, level, pos, player, hand, result);
            if (!interactionResult.consumesAction()) continue;
            return interactionResult;
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult useWithoutItem(ComponentHolder<BlockEntityComponent> holder, BlockState blockState, Level level, BlockPos pos, Player player, BlockHitResult result) {
        for (BlockEntityComponent component : holder.getComponents()) {
            InteractionResult interactionResult = component.useWithoutItem(blockState, level, pos, player, result);
            if (!interactionResult.consumesAction()) continue;
            return interactionResult;
        }
        return InteractionResult.PASS;
    }

    public static int getAnalogOutputSignal(ComponentHolder<BlockEntityComponent> holder, BlockState blockState, Level level, BlockPos pos) {
        int result = -1;
        for (BlockEntityComponent component : holder.getComponents()) {
            int signal = component.getAnalogOutputSignal(blockState, level, pos);
            if (signal <= 0) continue;
            result += signal;
        }
        return result;
    }

    public static void saveAdditional(ComponentHolder<BlockEntityComponent> holder, CompoundTag tag, HolderLookup.Provider registries) {
        CompoundTag componentsTag = new CompoundTag();
        holder.getComponentTypes().forEach(componentType -> {
            CompoundTag componentTag = new CompoundTag();
            ((BlockEntityComponent)holder.getComponentOrThrow(componentType)).saveNbt(componentTag, registries);
            if (!componentTag.isEmpty()) {
                componentsTag.put(componentType.registryName().toString(), (Tag)componentTag);
            }
        });
        if (!componentsTag.isEmpty()) {
            tag.put(NBT_COMPONENTS, (Tag)componentsTag);
        }
    }

    public static void loadAdditional(ComponentHolder<BlockEntityComponent> holder, CompoundTag tag, HolderLookup.Provider registries) {
        if (tag.contains(NBT_COMPONENTS, 10)) {
            CompoundTag componentsTag = tag.getCompound(NBT_COMPONENTS);
            holder.getComponentTypes().forEach(componentType -> {
                String key = componentType.registryName().toString();
                if (componentsTag.contains(key, 10)) {
                    CompoundTag componentTag = componentsTag.getCompound(key);
                    ((BlockEntityComponent)holder.getComponentOrThrow(componentType)).loadNbt(componentTag, registries);
                }
            });
            tag.remove(NBT_COMPONENTS);
        }
    }

    public static boolean triggerEvent(ComponentHolder<BlockEntityComponent> holder, int id, int event) {
        for (BlockEntityComponent component : holder.getComponents()) {
            if (!component.triggerEvent(id, event)) continue;
            return true;
        }
        return false;
    }

    public static void applyImplicitComponents(ComponentHolder<BlockEntityComponent> holder, BlockEntity.DataComponentInput input) {
        holder.getComponents().forEach(component -> component.applyImplicitComponents(input));
    }

    public static void collectImplicitComponents(ComponentHolder<BlockEntityComponent> holder, DataComponentMap.Builder components) {
        holder.getComponents().forEach(component -> component.collectImplicitComponents(components));
    }

    public static void removeComponentsFromTag(ComponentHolder<BlockEntityComponent> holder, CompoundTag tag) {
        if (tag.contains(NBT_COMPONENTS, 10)) {
            CompoundTag componentsTag = tag.getCompound(NBT_COMPONENTS);
            holder.getComponentTypes().forEach(componentType -> {
                String key = componentType.registryName().toString();
                if (componentsTag.contains(key, 10)) {
                    CompoundTag componentTag = componentsTag.getCompound(key);
                    ((BlockEntityComponent)holder.getComponentOrThrow(componentType)).removeComponentsFromTag(componentTag);
                    if (componentTag.isEmpty()) {
                        componentsTag.remove(key);
                    }
                }
            });
            if (componentsTag.isEmpty()) {
                tag.remove(NBT_COMPONENTS);
            }
        }
    }

    public static void entityInside(ComponentHolder<BlockEntityComponent> holder, BlockState blockState, Level level, BlockPos pos, Entity entity) {
        holder.getComponents().forEach(component -> component.entityInside(blockState, level, pos, entity));
    }

    public static void handlePrecipitation(ComponentHolder<BlockEntityComponent> holder, BlockState blockState, Level level, BlockPos pos, Biome.Precipitation precipitation) {
        holder.getComponents().forEach(component -> component.handlePrecipitation(blockState, level, pos, precipitation));
    }

    public static void stepOn(ComponentHolder<BlockEntityComponent> holder, Level level, BlockPos pos, BlockState blockState, Entity entity) {
        holder.getComponents().forEach(component -> component.stepOn(level, pos, blockState, entity));
    }

    public static boolean updateEntityMovementAfterFallOn(ComponentHolder<BlockEntityComponent> holder, BlockGetter level, Entity entity) {
        for (BlockEntityComponent component : holder.getComponents()) {
            if (!component.updateEntityMovementAfterFallOn(level, entity)) continue;
            return true;
        }
        return false;
    }

    public static void modifyCloneItemStack(ComponentHolder<BlockEntityComponent> holder, ItemStack stack, LevelReader level, BlockPos pos, BlockState blockState, boolean includeData) {
        for (BlockEntityComponent component : holder.getComponents()) {
            component.modifyCloneItemStack(stack, level, pos, blockState, includeData);
        }
    }

    public static void modifyCloneItemStack(ComponentHolder<BlockEntityComponent> holder, ItemStack stack, LevelReader level, BlockPos pos, BlockState blockState, boolean includeData, Player player) {
        for (BlockEntityComponent component : holder.getComponents()) {
            component.modifyCloneItemStack(stack, level, pos, blockState, includeData, player);
        }
    }

    @Nullable
    public static <TComponent extends BlockEntityComponent> TComponent getComponent(BlockGetter level, BlockPos pos, ComponentType<BlockEntityComponent, TComponent, ?> componentType) {
        ComponentHolder<BlockEntityComponent> holder = BlockEntityComponentHelper.asHolder(level, pos);
        return (TComponent)(holder == null ? null : (BlockEntityComponent)holder.getComponent(componentType));
    }

    public static <TComponent extends BlockEntityComponent> Optional<TComponent> findComponent(BlockGetter level, BlockPos pos, ComponentType<BlockEntityComponent, TComponent, ?> componentType) {
        ComponentHolder<BlockEntityComponent> holder = BlockEntityComponentHelper.asHolder(level, pos);
        return holder == null ? Optional.empty() : holder.findComponent(componentType);
    }

    public static <TComponent extends BlockEntityComponent> TComponent getComponentOrThrow(BlockGetter level, BlockPos pos, ComponentType<BlockEntityComponent, TComponent, ?> componentType) {
        return (TComponent)((BlockEntityComponent)BlockEntityComponentHelper.asHolderOrThrow(level, pos).getComponentOrThrow(componentType));
    }

    public static <TComponent extends BlockEntityComponent> void runForComponent(BlockGetter level, BlockPos pos, ComponentType<BlockEntityComponent, TComponent, ?> componentType, Consumer<TComponent> action) {
        ComponentHolder<BlockEntityComponent> holder = BlockEntityComponentHelper.asHolder(level, pos);
        if (holder != null) {
            holder.runForComponent(componentType, action);
        }
    }

    public static boolean hasComponent(BlockGetter level, BlockPos pos, ComponentType<BlockEntityComponent, ?, ?> componentType) {
        ComponentHolder<BlockEntityComponent> holder = BlockEntityComponentHelper.asHolder(level, pos);
        return holder != null && holder.hasComponent(componentType);
    }

    public static Set<ComponentType<BlockEntityComponent, ?, ?>> getComponentTypes(BlockGetter level, BlockPos pos) {
        ComponentHolder<BlockEntityComponent> holder = BlockEntityComponentHelper.asHolder(level, pos);
        return holder == null ? Collections.emptySet() : holder.getComponentTypes();
    }

    public static Collection<BlockEntityComponent> getComponents(BlockGetter level, BlockPos pos) {
        ComponentHolder<BlockEntityComponent> holder = BlockEntityComponentHelper.asHolder(level, pos);
        return holder == null ? Collections.emptyList() : holder.getComponents();
    }

    @Nullable
    public static ComponentHolder<BlockEntityComponent> asHolder(BlockGetter level, BlockPos pos) {
        BlockEntity block = level.getBlockEntity(pos);
        return block instanceof ComponentHolder ? (ComponentHolder)block : null;
    }

    public static ComponentHolder<BlockEntityComponent> asHolderOrThrow(BlockGetter level, BlockPos pos) {
        return Objects.requireNonNull(BlockEntityComponentHelper.asHolder(level, pos));
    }

    public static void registerInventoryComponents(ComponentRegistrar<BlockEntityComponent> registrar, UnaryOperator<InventoryBlockEntityComponent.Builder> inventoryBuilder) {
        registrar.register(BlockEntityComponentTypes.INVENTORY, inventoryBuilder);
        registrar.register(BlockEntityComponentTypes.LOOT_TABLE);
        registrar.register(BlockEntityComponentTypes.LOCK);
        registrar.register(BlockEntityComponentTypes.NAMEABLE);
    }
}

