/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.component.block.types;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import dev.apexstudios.apexcore.core.ApexCore;
import dev.apexstudios.apexcore.lib.component.ComponentBuilder;
import dev.apexstudios.apexcore.lib.component.ComponentHolder;
import dev.apexstudios.apexcore.lib.component.ComponentType;
import dev.apexstudios.apexcore.lib.component.block.BaseBlockComponent;
import dev.apexstudios.apexcore.lib.component.block.BlockComponent;
import dev.apexstudios.apexcore.lib.component.block.BlockComponentTypes;
import dev.apexstudios.apexcore.lib.component.block.types.MultiBlockComponent;
import dev.apexstudios.apexcore.lib.util.ApexUtil;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;

public final class BedBlockComponent
extends BaseBlockComponent {
    public static final ComponentType<BlockComponent, BedBlockComponent, Builder> COMPONENT_TYPE = ComponentType.registerBlock(ApexCore.identifier("bed"), Builder::new, BedBlockComponent::new);
    public static final BooleanProperty OCCUPIED = BedBlock.OCCUPIED;
    private final BiMap<Integer, Integer> indices;

    private BedBlockComponent(ComponentHolder<BlockComponent> holder, Builder builder) {
        super(holder);
        if (builder.indices.isEmpty()) {
            throw new IllegalStateException("No Head<->Tail bed index mapping provided");
        }
        this.indices = ImmutableBiMap.copyOf(builder.indices);
    }

    public boolean isHead(BlockState blockState) {
        int index = this.getComponentOrThrow(BlockComponentTypes.MULTI_BLOCK).indexOf(blockState);
        return this.indices.containsKey((Object)index);
    }

    public boolean isOccupied(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)OCCUPIED);
    }

    public void runForOpposite(BlockPos pos, BlockState blockState, BiConsumer<BlockPos, BlockState> consumer) {
        MultiBlockComponent multiBlock = this.getComponentOrThrow(BlockComponentTypes.MULTI_BLOCK);
        int index = multiBlock.indexOf(blockState);
        BlockPos otherPos = pos;
        BlockState otherBlockState = blockState;
        if (this.indices.containsKey((Object)index)) {
            otherBlockState = multiBlock.withIndex(blockState, (Integer)this.indices.get((Object)index));
            BlockPos origin = multiBlock.getOrigin(pos, blockState);
            otherPos = multiBlock.getPos(origin, otherBlockState);
        }
        consumer.accept(otherPos, otherBlockState);
    }

    public void setOccupied(Level level, BlockPos pos, BlockState blockState, boolean occupied) {
        level.setBlock(pos, (BlockState)blockState.setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(occupied)), 3);
        this.runForOpposite(pos, blockState, (oppositePos, oppositeBlockState) -> level.setBlock(oppositePos, (BlockState)oppositeBlockState.setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(occupied)), 3));
    }

    @Override
    public BlockState registerDefaultBlockState(BlockState blockState) {
        return (BlockState)blockState.setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public void createBlockStateDefinition(Consumer<Property<?>> consumer) {
        consumer.accept((Property<?>)OCCUPIED);
    }

    @Override
    public InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos pos, Player player, BlockHitResult result) {
        if (!level.isClientSide) {
            BlockPos interactPos = pos;
            BlockState interactBlockState = blockState;
            if (!this.isHead(blockState)) {
                MultiBlockComponent multiBlock = this.getComponentOrThrow(BlockComponentTypes.MULTI_BLOCK);
                BlockPos origin = multiBlock.getOrigin(pos, blockState);
                interactBlockState = multiBlock.withIndex(blockState, (Integer)this.indices.inverse().get((Object)multiBlock.indexOf(blockState)));
                interactPos = multiBlock.getPos(origin, interactBlockState);
            }
            if (!BedBlock.canSetSpawn((Level)level)) {
                level.removeBlock(interactPos, false);
                Vec3 center = interactPos.getCenter();
                level.explode(null, level.damageSources().badRespawnPointExplosion(center), null, center, 5.0f, true, Level.ExplosionInteraction.BLOCK);
            } else if (this.isOccupied(interactBlockState)) {
                if (!this.kickVillagerOutOfBed(level, interactPos)) {
                    player.displayClientMessage((Component)Component.translatable((String)"block.minecraft.bed.occupied"), true);
                }
            } else {
                player.startSleepInBed(interactPos).ifLeft(problem -> {
                    Component msg = problem.getMessage();
                    if (msg != null) {
                        player.displayClientMessage(msg, true);
                    }
                });
            }
        }
        return InteractionResult.SUCCESS;
    }

    private boolean kickVillagerOutOfBed(Level level, BlockPos pos) {
        List villagers = level.getEntitiesOfClass(Villager.class, new AABB(pos), LivingEntity::isSleeping);
        if (villagers.isEmpty()) {
            return false;
        }
        ((Villager)villagers.getFirst()).stopSleeping();
        return true;
    }

    public static <TBlock extends Block> void registerPoi(IEventBus modBus, Supplier<TBlock> blockSupplier) {
        modBus.addListener(FMLCommonSetupEvent.class, event -> event.enqueueWork(() -> BedBlockComponent.lambda$registerPoi$2((Supplier)blockSupplier)));
    }

    public static <TBlock extends Block> void registerPoi(TBlock block) {
        ((ComponentHolder)block).runForComponent(COMPONENT_TYPE, component -> ApexUtil.registerPoiBlockStates((ResourceKey<PoiType>)PoiTypes.HOME, block, component::isHead));
    }

    private static /* synthetic */ void lambda$registerPoi$2(Supplier blockSupplier) {
        BedBlockComponent.registerPoi((Block)blockSupplier.get());
    }

    public static final class Builder
    implements ComponentBuilder {
        private final BiMap<Integer, Integer> indices = HashBiMap.create();

        public Builder indices(int head, int foot) {
            this.indices.put((Object)head, (Object)foot);
            return this;
        }
    }
}

