/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.component.block.types;

import dev.apexstudios.apexcore.core.ApexCore;
import dev.apexstudios.apexcore.lib.component.ComponentHolder;
import dev.apexstudios.apexcore.lib.component.ComponentType;
import dev.apexstudios.apexcore.lib.component.block.BlockComponent;
import dev.apexstudios.apexcore.lib.component.block.types.BaseCauldronBlockComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public final class CauldronBlockComponent
extends BaseCauldronBlockComponent<BaseCauldronBlockComponent.SimpleBuilder> {
    public static final ComponentType<BlockComponent, CauldronBlockComponent, BaseCauldronBlockComponent.SimpleBuilder> COMPONENT_TYPE = ComponentType.registerBlock(ApexCore.identifier("cauldron"), BaseCauldronBlockComponent.SimpleBuilder::new, CauldronBlockComponent::new);

    private CauldronBlockComponent(ComponentHolder<BlockComponent> holder, BaseCauldronBlockComponent.SimpleBuilder builder) {
        super(holder, builder);
    }

    @Override
    public void handlePrecipitation(BlockState blockState, Level level, BlockPos pos, Biome.Precipitation precipitation) {
        if (CauldronBlock.shouldHandlePrecipitation((Level)level, (Biome.Precipitation)precipitation)) {
            if (precipitation == Biome.Precipitation.RAIN) {
                level.setBlockAndUpdate(pos, Blocks.WATER_CAULDRON.defaultBlockState());
                level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pos);
            } else if (precipitation == Biome.Precipitation.SNOW) {
                level.setBlockAndUpdate(pos, Blocks.POWDER_SNOW_CAULDRON.defaultBlockState());
                level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pos);
            }
        }
    }

    @Override
    protected boolean canReceiveStalactiteDrip(Fluid fluid) {
        return true;
    }

    @Override
    protected void receiveStalactiteDrip(BlockState blockState, Level level, BlockPos pos, Fluid fluid) {
        if (fluid.getFluidType().handleCauldronDrip(fluid, level, pos)) {
            return;
        }
        if (fluid == Fluids.WATER) {
            BlockState newBlockState = Blocks.WATER_CAULDRON.defaultBlockState();
            level.setBlockAndUpdate(pos, newBlockState);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)newBlockState));
            level.levelEvent(1047, pos, 0);
        } else if (fluid == Fluids.LAVA) {
            BlockState newBlockState = Blocks.LAVA_CAULDRON.defaultBlockState();
            level.setBlockAndUpdate(pos, newBlockState);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)newBlockState));
            level.levelEvent(1046, pos, 0);
        }
    }
}

