/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.component.block.types;

import dev.apexstudios.apexcore.core.ApexCore;
import dev.apexstudios.apexcore.lib.component.ComponentHolder;
import dev.apexstudios.apexcore.lib.component.ComponentType;
import dev.apexstudios.apexcore.lib.component.block.BlockComponent;
import dev.apexstudios.apexcore.lib.component.block.types.BaseCauldronBlockComponent;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CauldronBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;

public final class LayeredCauldronBlockComponent
extends BaseCauldronBlockComponent<Builder> {
    public static final ComponentType<BlockComponent, LayeredCauldronBlockComponent, Builder> COMPONENT_TYPE = ComponentType.registerBlock(ApexCore.identifier("layered_cauldron"), Builder::new, LayeredCauldronBlockComponent::new);
    public static final IntegerProperty LEVEL = LayeredCauldronBlock.LEVEL;
    public static final int MIN_FILL_LEVEL = 1;
    public static final int MAX_FILL_LEVEL = 3;
    private final Biome.Precipitation precipitation;

    private LayeredCauldronBlockComponent(ComponentHolder<BlockComponent> holder, Builder builder) {
        super(holder, builder);
        this.precipitation = builder.precipitation;
    }

    private boolean isFull(BlockState blockState) {
        return (Integer)blockState.getValue((Property)LEVEL) == 3;
    }

    private double getContentHeight(BlockState blockState) {
        return (6.0 + (double)((Integer)blockState.getValue((Property)LEVEL)).intValue() * 3.0) / 16.0;
    }

    @Override
    public void createBlockStateDefinition(Consumer<Property<?>> consumer) {
        consumer.accept((Property<?>)LEVEL);
    }

    @Override
    public BlockState registerDefaultBlockState(BlockState blockState) {
        return (BlockState)blockState.setValue((Property)LEVEL, (Comparable)Integer.valueOf(1));
    }

    @Override
    protected void receiveStalactiteDrip(BlockState blockState, Level level, BlockPos pos, Fluid fluid) {
        if (!this.isFull(blockState)) {
            BlockState newBlockState = (BlockState)blockState.setValue((Property)LEVEL, (Comparable)Integer.valueOf((Integer)blockState.getValue((Property)LEVEL) + 1));
            level.setBlockAndUpdate(pos, newBlockState);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)newBlockState));
            level.levelEvent(1047, pos, 0);
        }
    }

    @Override
    public void entityInside(BlockState blockState, Level level, BlockPos pos, Entity entity) {
        double contentHeight = this.getContentHeight(blockState);
        if (level instanceof ServerLevel) {
            ServerLevel sLevel = (ServerLevel)level;
            if (entity.isOnFire() && LayeredCauldronBlockComponent.isEntityInsideContent(pos, entity, contentHeight)) {
                entity.clearFire();
                if (entity.mayInteract(sLevel, pos)) {
                    this.handleEntityOnFireInside(blockState, level, pos);
                }
            }
        }
    }

    @Override
    public void handlePrecipitation(BlockState blockState, Level level, BlockPos pos, Biome.Precipitation precipitation) {
        if (CauldronBlock.shouldHandlePrecipitation((Level)level, (Biome.Precipitation)precipitation) && !this.isFull(blockState) && precipitation == this.precipitation) {
            BlockState newBlockState = (BlockState)blockState.cycle((Property)LEVEL);
            level.setBlockAndUpdate(pos, newBlockState);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)newBlockState));
        }
    }

    @Override
    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        return (Integer)blockState.getValue((Property)LEVEL);
    }

    private void handleEntityOnFireInside(BlockState blockState, Level level, BlockPos pos) {
        if (this.precipitation == Biome.Precipitation.SNOW) {
            LayeredCauldronBlock.lowerFillLevel((BlockState)Blocks.WATER_CAULDRON.withPropertiesOf(blockState), (Level)level, (BlockPos)pos);
        } else {
            LayeredCauldronBlock.lowerFillLevel((BlockState)blockState, (Level)level, (BlockPos)pos);
        }
    }

    public static final class Builder
    extends BaseCauldronBlockComponent.Builder<Builder> {
        private Biome.Precipitation precipitation = Biome.Precipitation.NONE;

        public Builder precipitation(Biome.Precipitation precipitation) {
            this.precipitation = precipitation;
            return this;
        }
    }
}

