/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.data.provider;

import com.google.common.collect.ImmutableMap;
import dev.apexstudios.apexcore.core.data.provider.ItemStackRecipeBuilder;
import dev.apexstudios.apexcore.core.data.provider.RecipeProviderImpl;
import dev.apexstudios.apexcore.lib.data.ProviderType;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.BlockFamilies;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.data.recipes.SmithingTrimRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import net.neoforged.neoforge.common.DataMapHooks;
import org.jetbrains.annotations.Nullable;

public interface RecipeProvider {
    public static final ProviderType<RecipeProvider> PROVIDER_TYPE = RecipeProviderImpl.PROVIDER_TYPE;
    public static final Map<BlockFamily.Variant, FamilyRecipeProvider> SHAPE_BUILDERS = ImmutableMap.builder().put((Object)BlockFamily.Variant.BUTTON, (provider, ingredient, material) -> provider.buttonBuilder(ingredient, Ingredient.of((ItemLike)material))).put((Object)BlockFamily.Variant.CHISELED, (provider, ingredient, material) -> provider.chiseledBuilder(RecipeCategory.BUILDING_BLOCKS, ingredient, Ingredient.of((ItemLike)material))).put((Object)BlockFamily.Variant.CUT, (provider, ingredient, material) -> provider.cutBuilder(RecipeCategory.BUILDING_BLOCKS, ingredient, Ingredient.of((ItemLike)material))).put((Object)BlockFamily.Variant.DOOR, (provider, ingredient, material) -> provider.doorBuilder(ingredient, Ingredient.of((ItemLike)material))).put((Object)BlockFamily.Variant.CUSTOM_FENCE, (provider, ingredient, material) -> provider.fenceBuilder(ingredient, Ingredient.of((ItemLike)material))).put((Object)BlockFamily.Variant.FENCE, (provider, ingredient, material) -> provider.fenceBuilder(ingredient, Ingredient.of((ItemLike)material))).put((Object)BlockFamily.Variant.CUSTOM_FENCE_GATE, (provider, ingredient, material) -> provider.fenceGateBuilder(ingredient, Ingredient.of((ItemLike)material))).put((Object)BlockFamily.Variant.FENCE_GATE, (provider, ingredient, material) -> provider.fenceGateBuilder(ingredient, Ingredient.of((ItemLike)material))).put((Object)BlockFamily.Variant.SIGN, (provider, ingredient, material) -> provider.signBuilder(ingredient, Ingredient.of((ItemLike)material))).put((Object)BlockFamily.Variant.SLAB, (provider, ingredient, material) -> provider.slabBuilder(RecipeCategory.BUILDING_BLOCKS, ingredient, Ingredient.of((ItemLike)material))).put((Object)BlockFamily.Variant.STAIRS, (provider, ingredient, material) -> provider.stairBuilder(ingredient, Ingredient.of((ItemLike)material))).put((Object)BlockFamily.Variant.PRESSURE_PLATE, (provider, ingredient, material) -> provider.pressurePlateBuilder(RecipeCategory.REDSTONE, ingredient, Ingredient.of((ItemLike)material))).put((Object)BlockFamily.Variant.POLISHED, (provider, ingredient, material) -> provider.polishedBuilder(RecipeCategory.BUILDING_BLOCKS, ingredient, Ingredient.of((ItemLike)material))).put((Object)BlockFamily.Variant.TRAPDOOR, (provider, ingredient, material) -> provider.trapdoorBuilder(ingredient, Ingredient.of((ItemLike)material))).put((Object)BlockFamily.Variant.WALL, (provider, ingredient, material) -> provider.wallBuilder(RecipeCategory.DECORATIONS, ingredient, Ingredient.of((ItemLike)material))).build();

    public RecipeOutput output();

    public HolderGetter<Item> items();

    default public void generateForEnabledBlockFamilies(FeatureFlagSet enabledFeatures) {
        BlockFamilies.getAllFamilies().filter(BlockFamily::shouldGenerateRecipe).forEach(family -> this.generateRecipes((BlockFamily)family, enabledFeatures));
    }

    default public void oneToOneConversionRecipe(ItemLike result, ItemLike ingredient, @Nullable String group) {
        this.oneToOneConversionRecipe(result, ingredient, group, 1);
    }

    default public void oneToOneConversionRecipe(ItemLike result, ItemLike ingredient, @Nullable String group, int resultCount) {
        this.shapeless(RecipeCategory.MISC, result, resultCount).requires(ingredient).group(group).unlockedBy(RecipeProvider.getHasName(ingredient), this.has(ingredient)).save(this.output(), RecipeProvider.getConversionRecipeName(result, ingredient));
    }

    default public void oreSmelting(List<ItemLike> ingredients, RecipeCategory category, ItemLike result, float experience, int cookingTime, String group) {
        this.oreCooking(RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, ingredients, category, result, experience, cookingTime, group, "_from_smelting");
    }

    default public void oreBlasting(List<ItemLike> ingredients, RecipeCategory category, ItemLike result, float experience, int cookingTime, String group) {
        this.oreCooking(RecipeSerializer.BLASTING_RECIPE, BlastingRecipe::new, ingredients, category, result, experience, cookingTime, group, "_from_blasting");
    }

    default public <T extends AbstractCookingRecipe> void oreCooking(RecipeSerializer<T> serializer, AbstractCookingRecipe.Factory<T> recipeFactory, List<ItemLike> ingredients, RecipeCategory category, ItemLike result, float experience, int cookingTime, String group, String suffix) {
        for (ItemLike ingredient : ingredients) {
            SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike)ingredient), (RecipeCategory)category, (ItemLike)result, (float)experience, (int)cookingTime, serializer, recipeFactory).group(group).unlockedBy(RecipeProvider.getHasName(ingredient), this.has(ingredient)).save(this.output(), RecipeProvider.getItemName(result) + suffix + "_" + RecipeProvider.getItemName(ingredient));
        }
    }

    default public void netheriteSmithing(Item ingredientItem, RecipeCategory category, Item resultItem) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike)Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE), (Ingredient)Ingredient.of((ItemLike)ingredientItem), (Ingredient)this.tag((TagKey<Item>)ItemTags.NETHERITE_TOOL_MATERIALS), (RecipeCategory)category, (Item)resultItem).unlocks("has_netherite_ingot", this.has((TagKey<Item>)ItemTags.NETHERITE_TOOL_MATERIALS)).save(this.output(), RecipeProvider.getItemName((ItemLike)resultItem) + "_smithing");
    }

    default public void trimSmithing(Item templateItem, ResourceKey<Recipe<?>> key) {
        SmithingTrimRecipeBuilder.smithingTrim((Ingredient)Ingredient.of((ItemLike)templateItem), (Ingredient)this.tag((TagKey<Item>)ItemTags.TRIMMABLE_ARMOR), (Ingredient)this.tag((TagKey<Item>)ItemTags.TRIM_MATERIALS), (RecipeCategory)RecipeCategory.MISC).unlocks("has_smithing_trim_template", this.has((ItemLike)templateItem)).save(this.output(), key);
    }

    default public void twoByTwoPacker(RecipeCategory category, ItemLike packed, ItemLike unpacked) {
        this.shaped(category, packed, 1).define(Character.valueOf('#'), unpacked).pattern("##").pattern("##").unlockedBy(RecipeProvider.getHasName(unpacked), this.has(unpacked)).save(this.output());
    }

    default public void threeByThreePacker(RecipeCategory category, ItemLike packed, ItemLike unpacked, String criterionName) {
        this.shapeless(category, packed).requires(unpacked, 9).unlockedBy(criterionName, this.has(unpacked)).save(this.output());
    }

    default public void threeByThreePacker(RecipeCategory category, ItemLike packed, ItemLike unpacked) {
        this.threeByThreePacker(category, packed, unpacked, RecipeProvider.getHasName(unpacked));
    }

    default public void planksFromLog(ItemLike planks, TagKey<Item> logs, int resultCount) {
        this.shapeless(RecipeCategory.BUILDING_BLOCKS, planks, resultCount).requires(logs).group("planks").unlockedBy("has_log", this.has(logs)).save(this.output());
    }

    default public void planksFromLogs(ItemLike planks, TagKey<Item> logs, int result) {
        this.shapeless(RecipeCategory.BUILDING_BLOCKS, planks, result).requires(logs).group("planks").unlockedBy("has_logs", this.has(logs)).save(this.output());
    }

    default public void woodFromLogs(ItemLike wood, ItemLike log) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, wood, 3).define(Character.valueOf('#'), log).pattern("##").pattern("##").group("bark").unlockedBy("has_log", this.has(log)).save(this.output());
    }

    default public void woodenBoat(ItemLike boat, ItemLike material) {
        this.shaped(RecipeCategory.TRANSPORTATION, boat).define(Character.valueOf('#'), material).pattern("# #").pattern("###").group("boat").unlockedBy("in_water", RecipeProvider.insideOf(Blocks.WATER)).save(this.output());
    }

    default public void chestBoat(ItemLike boat, ItemLike material) {
        this.shapeless(RecipeCategory.TRANSPORTATION, boat).requires((ItemLike)Blocks.CHEST).requires(material).group("chest_boat").unlockedBy("has_boat", this.has((TagKey<Item>)ItemTags.BOATS)).save(this.output());
    }

    default public RecipeBuilder buttonBuilder(ItemLike button, Ingredient material) {
        return this.shapeless(RecipeCategory.REDSTONE, button).requires(material);
    }

    default public RecipeBuilder doorBuilder(ItemLike door, Ingredient material) {
        return this.shaped(RecipeCategory.REDSTONE, door, 3).define(Character.valueOf('#'), material).pattern("##").pattern("##").pattern("##");
    }

    default public RecipeBuilder fenceBuilder(ItemLike fence, ItemLike stick, int count, Ingredient material) {
        return this.shaped(RecipeCategory.DECORATIONS, fence, count).define(Character.valueOf('W'), material).define(Character.valueOf('#'), stick).pattern("W#W").pattern("W#W");
    }

    default public RecipeBuilder fenceBuilder(ItemLike fence, ItemLike stick, Ingredient material) {
        return this.fenceBuilder(fence, stick, 3, material);
    }

    default public RecipeBuilder fenceBuilder(ItemLike fence, Ingredient material) {
        return this.fenceBuilder(fence, (ItemLike)Items.STICK, 3, material);
    }

    default public RecipeBuilder fenceGateBuilder(ItemLike fenceGate, Ingredient material) {
        return this.shaped(RecipeCategory.REDSTONE, fenceGate).define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('W'), material).pattern("#W#").pattern("#W#");
    }

    default public void pressurePlate(ItemLike pressurePlate, ItemLike material) {
        this.pressurePlateBuilder(RecipeCategory.REDSTONE, pressurePlate, Ingredient.of((ItemLike)material)).unlockedBy(RecipeProvider.getHasName(material), this.has(material)).save(this.output());
    }

    default public RecipeBuilder pressurePlateBuilder(RecipeCategory category, ItemLike pressurePlate, Ingredient material) {
        return this.shaped(category, pressurePlate).define(Character.valueOf('#'), material).pattern("##");
    }

    default public void slab(RecipeCategory category, ItemLike slab, ItemLike material) {
        this.slabBuilder(category, slab, Ingredient.of((ItemLike)material)).unlockedBy(RecipeProvider.getHasName(material), this.has(material)).save(this.output());
    }

    default public RecipeBuilder slabBuilder(RecipeCategory category, ItemLike slab, Ingredient material) {
        return this.shaped(category, slab, 6).define(Character.valueOf('#'), material).pattern("###");
    }

    default public RecipeBuilder stairBuilder(ItemLike stairs, Ingredient material) {
        return this.shaped(RecipeCategory.BUILDING_BLOCKS, stairs, 4).define(Character.valueOf('#'), material).pattern("#  ").pattern("## ").pattern("###");
    }

    default public RecipeBuilder trapdoorBuilder(ItemLike trapdoor, Ingredient material) {
        return this.shaped(RecipeCategory.REDSTONE, trapdoor, 2).define(Character.valueOf('#'), material).pattern("###").pattern("###");
    }

    default public RecipeBuilder signBuilder(ItemLike sign, Ingredient material) {
        return this.shaped(RecipeCategory.DECORATIONS, sign, 3).group("sign").define(Character.valueOf('#'), material).define(Character.valueOf('X'), (ItemLike)Items.STICK).pattern("###").pattern("###").pattern(" X ");
    }

    default public void hangingSign(ItemLike sign, ItemLike material) {
        this.shaped(RecipeCategory.DECORATIONS, sign, 6).group("hanging_sign").define(Character.valueOf('#'), material).define(Character.valueOf('X'), (ItemLike)Items.CHAIN).pattern("X X").pattern("###").pattern("###").unlockedBy("has_stripped_logs", this.has(material)).save(this.output());
    }

    default public void colorBlockWithDye(List<ItemLike> dyes, List<ItemLike> dyeableItems, String group) {
        this.colorWithDye(dyes, dyeableItems, null, group, RecipeCategory.BUILDING_BLOCKS);
    }

    default public void colorWithDye(List<ItemLike> dyeItems, List<ItemLike> dyeableItems, @Nullable ItemLike dye, String group, RecipeCategory category) {
        for (int i = 0; i < dyeItems.size(); ++i) {
            ItemLike dyeItem = dyeItems.get(i);
            ItemLike dyeableItem = dyeableItems.get(i);
            Stream<ItemLike> items = dyeableItems.stream().filter(p_288265_ -> !p_288265_.equals((Object)dyeableItem));
            if (dye != null) {
                items = Stream.concat(items, Stream.of(dye));
            }
            this.shapeless(category, dyeableItem).requires(dyeItem).requires(Ingredient.of(items)).group(group).unlockedBy("has_needed_dye", this.has(dyeItem)).save(this.output(), "dye_" + RecipeProvider.getItemName(dyeableItem));
        }
    }

    default public void carpet(ItemLike carpet, ItemLike material) {
        this.shaped(RecipeCategory.DECORATIONS, carpet, 3).define(Character.valueOf('#'), material).pattern("##").group("carpet").unlockedBy(RecipeProvider.getHasName(material), this.has(material)).save(this.output());
    }

    default public void bedFromPlanksAndWool(ItemLike bed, ItemLike wool) {
        this.shaped(RecipeCategory.DECORATIONS, bed).define(Character.valueOf('#'), wool).define(Character.valueOf('X'), ItemTags.PLANKS).pattern("###").pattern("XXX").group("bed").unlockedBy(RecipeProvider.getHasName(wool), this.has(wool)).save(this.output());
    }

    default public void banner(ItemLike banner, ItemLike material) {
        this.shaped(RecipeCategory.DECORATIONS, banner).define(Character.valueOf('#'), material).define(Character.valueOf('|'), (ItemLike)Items.STICK).pattern("###").pattern("###").pattern(" | ").group("banner").unlockedBy(RecipeProvider.getHasName(material), this.has(material)).save(this.output());
    }

    default public void stainedGlassFromGlassAndDye(ItemLike stainedGlass, ItemLike dye) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, stainedGlass, 8).define(Character.valueOf('#'), (ItemLike)Blocks.GLASS).define(Character.valueOf('X'), dye).pattern("###").pattern("#X#").pattern("###").group("stained_glass").unlockedBy("has_glass", this.has((ItemLike)Blocks.GLASS)).save(this.output());
    }

    default public void stainedGlassPaneFromStainedGlass(ItemLike stainedGlassPane, ItemLike stainedGlass) {
        this.shaped(RecipeCategory.DECORATIONS, stainedGlassPane, 16).define(Character.valueOf('#'), stainedGlass).pattern("###").pattern("###").group("stained_glass_pane").unlockedBy("has_glass", this.has(stainedGlass)).save(this.output());
    }

    default public void stainedGlassPaneFromGlassPaneAndDye(ItemLike stainedGlassPane, ItemLike dye) {
        this.shaped(RecipeCategory.DECORATIONS, stainedGlassPane, 8).define(Character.valueOf('#'), (ItemLike)Blocks.GLASS_PANE).define(Character.valueOf('$'), dye).pattern("###").pattern("#$#").pattern("###").group("stained_glass_pane").unlockedBy("has_glass_pane", this.has((ItemLike)Blocks.GLASS_PANE)).unlockedBy(RecipeProvider.getHasName(dye), this.has(dye)).save(this.output(), RecipeProvider.getConversionRecipeName(stainedGlassPane, (ItemLike)Blocks.GLASS_PANE));
    }

    default public void coloredTerracottaFromTerracottaAndDye(ItemLike terracotta, ItemLike dye) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, terracotta, 8).define(Character.valueOf('#'), (ItemLike)Blocks.TERRACOTTA).define(Character.valueOf('X'), dye).pattern("###").pattern("#X#").pattern("###").group("stained_terracotta").unlockedBy("has_terracotta", this.has((ItemLike)Blocks.TERRACOTTA)).save(this.output());
    }

    default public void concretePowder(ItemLike concretePowder, ItemLike dye) {
        this.shapeless(RecipeCategory.BUILDING_BLOCKS, concretePowder, 8).requires(dye).requires((ItemLike)Blocks.SAND, 4).requires((ItemLike)Blocks.GRAVEL, 4).group("concrete_powder").unlockedBy("has_sand", this.has((ItemLike)Blocks.SAND)).unlockedBy("has_gravel", this.has((ItemLike)Blocks.GRAVEL)).save(this.output());
    }

    default public void candle(ItemLike candle, ItemLike dye) {
        this.shapeless(RecipeCategory.DECORATIONS, candle).requires((ItemLike)Blocks.CANDLE).requires(dye).group("dyed_candle").unlockedBy(RecipeProvider.getHasName(dye), this.has(dye)).save(this.output());
    }

    default public void wall(RecipeCategory category, ItemLike wall, ItemLike material) {
        this.wallBuilder(category, wall, Ingredient.of((ItemLike)material)).unlockedBy(RecipeProvider.getHasName(material), this.has(material)).save(this.output());
    }

    default public RecipeBuilder wallBuilder(RecipeCategory category, ItemLike wall, Ingredient material) {
        return this.shaped(category, wall, 6).define(Character.valueOf('#'), material).pattern("###").pattern("###");
    }

    default public void polished(RecipeCategory category, ItemLike result, ItemLike material) {
        this.polishedBuilder(category, result, Ingredient.of((ItemLike)material)).unlockedBy(RecipeProvider.getHasName(material), this.has(material)).save(this.output());
    }

    default public RecipeBuilder polishedBuilder(RecipeCategory category, ItemLike result, Ingredient material) {
        return this.shaped(category, result, 4).define(Character.valueOf('S'), material).pattern("SS").pattern("SS");
    }

    default public void cut(RecipeCategory category, ItemLike cutResult, ItemLike material) {
        this.cutBuilder(category, cutResult, Ingredient.of((ItemLike)material)).unlockedBy(RecipeProvider.getHasName(material), this.has(material)).save(this.output());
    }

    default public ShapedRecipeBuilder cutBuilder(RecipeCategory category, ItemLike cutResult, Ingredient material) {
        return this.shaped(category, cutResult, 4).define(Character.valueOf('#'), material).pattern("##").pattern("##");
    }

    default public void chiseled(RecipeCategory category, ItemLike chiseledResult, ItemLike material) {
        this.chiseledBuilder(category, chiseledResult, Ingredient.of((ItemLike)material)).unlockedBy(RecipeProvider.getHasName(material), this.has(material)).save(this.output());
    }

    default public void mosaicBuilder(RecipeCategory category, ItemLike result, ItemLike material) {
        this.shaped(category, result).define(Character.valueOf('#'), material).pattern("#").pattern("#").unlockedBy(RecipeProvider.getHasName(material), this.has(material)).save(this.output());
    }

    default public ShapedRecipeBuilder chiseledBuilder(RecipeCategory category, ItemLike chiseledResult, Ingredient material) {
        return this.shaped(category, chiseledResult).define(Character.valueOf('#'), material).pattern("#").pattern("#");
    }

    default public void stonecutterResultFromBase(RecipeCategory category, ItemLike result, ItemLike material) {
        this.stonecutterResultFromBase(category, result, material, 1);
    }

    default public void stonecutterResultFromBase(RecipeCategory category, ItemLike result, ItemLike material, int resultCount) {
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike)material), (RecipeCategory)category, (ItemLike)result, (int)resultCount).unlockedBy(RecipeProvider.getHasName(material), this.has(material)).save(this.output(), RecipeProvider.getConversionRecipeName(result, material) + "_stonecutting");
    }

    default public void stonecutterResultFromBase(RecipeCategory category, ItemLike material, ItemStack result) {
        ItemStackRecipeBuilder.stonecutting(Ingredient.of((ItemLike)material), category, result).unlockedBy(RecipeProvider.getHasName(material), (Criterion)this.has(material)).save(this.output(), RecipeProvider.getConversionRecipeName(() -> ((ItemStack)result).getItem(), material) + "_stonecutting");
    }

    default public void smeltingResultFromBase(ItemLike result, ItemLike ingredient) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike)ingredient), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (float)0.1f, (int)200).unlockedBy(RecipeProvider.getHasName(ingredient), this.has(ingredient)).save(this.output());
    }

    default public void nineBlockStorageRecipes(RecipeCategory unpackedCategory, ItemLike unpacked, RecipeCategory packedCategory, ItemLike packed) {
        this.nineBlockStorageRecipes(unpackedCategory, unpacked, packedCategory, packed, RecipeProvider.getSimpleRecipeName(packed), null, RecipeProvider.getSimpleRecipeName(unpacked), null);
    }

    default public void nineBlockStorageRecipesWithCustomPacking(RecipeCategory unpackedCategory, ItemLike unpacked, RecipeCategory packedCategory, ItemLike packed, String packedName, String packedGroup) {
        this.nineBlockStorageRecipes(unpackedCategory, unpacked, packedCategory, packed, packedName, packedGroup, RecipeProvider.getSimpleRecipeName(unpacked), null);
    }

    default public void nineBlockStorageRecipesRecipesWithCustomUnpacking(RecipeCategory unpackedCategory, ItemLike unpacked, RecipeCategory packedCategory, ItemLike packed, String unpackedName, String unpackedGroup) {
        this.nineBlockStorageRecipes(unpackedCategory, unpacked, packedCategory, packed, RecipeProvider.getSimpleRecipeName(packed), null, unpackedName, unpackedGroup);
    }

    default public void nineBlockStorageRecipes(RecipeCategory unpackedCategory, ItemLike unpacked, RecipeCategory packedCategory, ItemLike packed, String packedName, @Nullable String packedGroup, String unpackedName, @Nullable String unpackedGroup) {
        RecipeOutput output = this.output();
        this.shapeless(unpackedCategory, unpacked, 9).requires(packed).group(unpackedGroup).unlockedBy(RecipeProvider.getHasName(packed), this.has(packed)).save(output, ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.parse((String)unpackedName)));
        this.shaped(packedCategory, packed).define(Character.valueOf('#'), unpacked).pattern("###").pattern("###").pattern("###").group(packedGroup).unlockedBy(RecipeProvider.getHasName(unpacked), this.has(unpacked)).save(output, ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.parse((String)packedName)));
    }

    default public void copySmithingTemplate(ItemLike template, ItemLike baseItem) {
        this.shaped(RecipeCategory.MISC, template, 2).define(Character.valueOf('#'), (ItemLike)Items.DIAMOND).define(Character.valueOf('C'), baseItem).define(Character.valueOf('S'), template).pattern("#S#").pattern("#C#").pattern("###").unlockedBy(RecipeProvider.getHasName(template), this.has(template)).save(this.output());
    }

    default public void copySmithingTemplate(ItemLike template, Ingredient baseItem) {
        this.shaped(RecipeCategory.MISC, template, 2).define(Character.valueOf('#'), (ItemLike)Items.DIAMOND).define(Character.valueOf('C'), baseItem).define(Character.valueOf('S'), template).pattern("#S#").pattern("#C#").pattern("###").unlockedBy(RecipeProvider.getHasName(template), this.has(template)).save(this.output());
    }

    default public <T extends AbstractCookingRecipe> void simpleCookingRecipe(String cookingMethod, RecipeSerializer<T> cookingSerializer, AbstractCookingRecipe.Factory<T> recipeFactory, int cookingTime, ItemLike material, ItemLike result, float experience) {
        SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike)material), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)experience, (int)cookingTime, cookingSerializer, recipeFactory).unlockedBy(RecipeProvider.getHasName(material), this.has(material)).save(this.output(), RecipeProvider.getItemName(result) + "_from_" + cookingMethod);
    }

    default public void waxRecipes(FeatureFlagSet requiredFeatures) {
        DataMapHooks.INVERSE_WAXABLES_DATAMAP.forEach((waxed, unwaxed) -> {
            if (unwaxed.requiredFeatures().isSubsetOf(requiredFeatures)) {
                this.shapeless(RecipeCategory.BUILDING_BLOCKS, (ItemLike)unwaxed).requires((ItemLike)waxed).requires((ItemLike)Items.HONEYCOMB).group(RecipeProvider.getItemName((ItemLike)unwaxed)).unlockedBy(RecipeProvider.getHasName((ItemLike)waxed), this.has((ItemLike)waxed)).save(this.output(), RecipeProvider.getConversionRecipeName((ItemLike)unwaxed, (ItemLike)Items.HONEYCOMB));
            }
        });
    }

    default public void grate(Block grateBlock, Block material) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)grateBlock, 4).define(Character.valueOf('M'), (ItemLike)material).pattern(" M ").pattern("M M").pattern(" M ").unlockedBy(RecipeProvider.getHasName((ItemLike)material), this.has((ItemLike)material)).save(this.output());
    }

    default public void copperBulb(Block bulbBlock, Block material) {
        this.shaped(RecipeCategory.REDSTONE, (ItemLike)bulbBlock, 4).define(Character.valueOf('C'), (ItemLike)material).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('B'), (ItemLike)Items.BLAZE_ROD).pattern(" C ").pattern("CBC").pattern(" R ").unlockedBy(RecipeProvider.getHasName((ItemLike)material), this.has((ItemLike)material)).save(this.output());
    }

    default public void suspiciousStew(Item flowerItem, SuspiciousEffectHolder effect) {
        ItemStack stew = new ItemStack((Holder)Items.SUSPICIOUS_STEW.builtInRegistryHolder(), 1, DataComponentPatch.builder().set(DataComponents.SUSPICIOUS_STEW_EFFECTS, (Object)effect.getSuspiciousEffects()).build());
        this.shapeless(RecipeCategory.FOOD, stew).requires((ItemLike)Items.BOWL).requires((ItemLike)Items.BROWN_MUSHROOM).requires((ItemLike)Items.RED_MUSHROOM).requires((ItemLike)flowerItem).group("suspicious_stew").unlockedBy(RecipeProvider.getHasName((ItemLike)flowerItem), this.has((ItemLike)flowerItem)).save(this.output(), RecipeProvider.getItemName((ItemLike)stew.getItem()) + "_from_" + RecipeProvider.getItemName((ItemLike)flowerItem));
    }

    default public void generateRecipes(BlockFamily blockFamily, FeatureFlagSet requiredFeatures) {
        blockFamily.getVariants().forEach((variant, block) -> {
            if (block.requiredFeatures().isSubsetOf(requiredFeatures)) {
                FamilyRecipeProvider provider = SHAPE_BUILDERS.get(variant);
                Block baseBlock = this.getBaseBlock(blockFamily, (BlockFamily.Variant)variant);
                if (provider != null) {
                    RecipeBuilder builder = provider.create(this, (ItemLike)block, (ItemLike)baseBlock);
                    blockFamily.getRecipeGroupPrefix().ifPresent(p_293701_ -> builder.group(p_293701_ + (String)(variant == BlockFamily.Variant.CUT ? "" : "_" + variant.getRecipeGroup())));
                    builder.unlockedBy(blockFamily.getRecipeUnlockedBy().orElseGet(() -> RecipeProvider.getHasName((ItemLike)baseBlock)), this.has((ItemLike)baseBlock));
                    builder.save(this.output());
                }
                if (variant == BlockFamily.Variant.CRACKED) {
                    this.smeltingResultFromBase((ItemLike)block, (ItemLike)baseBlock);
                }
            }
        });
    }

    default public Block getBaseBlock(BlockFamily family, BlockFamily.Variant variant) {
        if (variant == BlockFamily.Variant.CHISELED) {
            if (!family.getVariants().containsKey(BlockFamily.Variant.SLAB)) {
                throw new IllegalStateException("Slab is not defined for the family.");
            }
            return family.get(BlockFamily.Variant.SLAB);
        }
        return family.getBaseBlock();
    }

    default public Criterion<InventoryChangeTrigger.TriggerInstance> has(MinMaxBounds.Ints count, ItemLike item) {
        return RecipeProvider.inventoryTrigger(ItemPredicate.Builder.item().of(this.items(), new ItemLike[]{item}).withCount(count));
    }

    default public Criterion<InventoryChangeTrigger.TriggerInstance> has(ItemLike itemLike) {
        return RecipeProvider.inventoryTrigger(ItemPredicate.Builder.item().of(this.items(), new ItemLike[]{itemLike}));
    }

    default public Criterion<InventoryChangeTrigger.TriggerInstance> has(TagKey<Item> tag) {
        return RecipeProvider.inventoryTrigger(ItemPredicate.Builder.item().of(this.items(), tag));
    }

    default public Ingredient tag(TagKey<Item> tag) {
        return Ingredient.of((HolderSet)this.items().getOrThrow(tag));
    }

    default public ShapedRecipeBuilder shaped(RecipeCategory category, ItemLike result) {
        return ShapedRecipeBuilder.shaped(this.items(), (RecipeCategory)category, (ItemLike)result);
    }

    default public ShapedRecipeBuilder shaped(RecipeCategory category, ItemLike result, int count) {
        return ShapedRecipeBuilder.shaped(this.items(), (RecipeCategory)category, (ItemLike)result, (int)count);
    }

    default public ShapelessRecipeBuilder shapeless(RecipeCategory category, ItemStack result) {
        return ShapelessRecipeBuilder.shapeless(this.items(), (RecipeCategory)category, (ItemStack)result);
    }

    default public ShapelessRecipeBuilder shapeless(RecipeCategory category, ItemLike result) {
        return ShapelessRecipeBuilder.shapeless(this.items(), (RecipeCategory)category, (ItemLike)result);
    }

    default public ShapelessRecipeBuilder shapeless(RecipeCategory category, ItemLike result, int count) {
        return ShapelessRecipeBuilder.shapeless(this.items(), (RecipeCategory)category, (ItemLike)result, (int)count);
    }

    public static Criterion<EnterBlockTrigger.TriggerInstance> insideOf(Block block) {
        return net.minecraft.data.recipes.RecipeProvider.insideOf((Block)block);
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> inventoryTrigger(ItemPredicate.Builder ... items) {
        return net.minecraft.data.recipes.RecipeProvider.inventoryTrigger((ItemPredicate.Builder[])items);
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> inventoryTrigger(ItemPredicate ... predicates) {
        return net.minecraft.data.recipes.RecipeProvider.inventoryTrigger((ItemPredicate[])predicates);
    }

    public static String getHasName(ItemLike itemLike) {
        return net.minecraft.data.recipes.RecipeProvider.getHasName((ItemLike)itemLike);
    }

    public static String getHasName(TagKey<Item> tag) {
        return "has_" + tag.location().getPath().replace("/", "_");
    }

    public static String getItemName(ItemLike itemLike) {
        return net.minecraft.data.recipes.RecipeProvider.getItemName((ItemLike)itemLike);
    }

    public static String getSimpleRecipeName(ItemLike itemLike) {
        return net.minecraft.data.recipes.RecipeProvider.getSimpleRecipeName((ItemLike)itemLike);
    }

    public static String getConversionRecipeName(ItemLike result, ItemLike ingredient) {
        return net.minecraft.data.recipes.RecipeProvider.getConversionRecipeName((ItemLike)result, (ItemLike)ingredient);
    }

    public static String getSmeltingRecipeName(ItemLike itemLike) {
        return net.minecraft.data.recipes.RecipeProvider.getSmeltingRecipeName((ItemLike)itemLike);
    }

    public static String getBlastingRecipeName(ItemLike itemLike) {
        return net.minecraft.data.recipes.RecipeProvider.getBlastingRecipeName((ItemLike)itemLike);
    }

    public static ResourceKey<Recipe<?>> recipeKey(ResourceLocation recipeId) {
        return ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)recipeId);
    }

    public static ResourceKey<Recipe<?>> recipeKeyWithPrefix(ItemLike item, String prefix) {
        return RecipeProvider.recipeKey(RecipeBuilder.getDefaultRecipeId((ItemLike)item).withPrefix(prefix));
    }

    public static ResourceKey<Recipe<?>> recipeKeyWithSuffix(ItemLike item, String suffix) {
        return RecipeProvider.recipeKey(RecipeBuilder.getDefaultRecipeId((ItemLike)item).withSuffix(suffix));
    }

    @FunctionalInterface
    public static interface FamilyRecipeProvider {
        public RecipeBuilder create(RecipeProvider var1, ItemLike var2, ItemLike var3);
    }
}

