/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.data.provider.model;

import dev.apexstudios.apexcore.lib.component.ComponentHolder;
import dev.apexstudios.apexcore.lib.component.block.BlockComponentTypes;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.PropertyDispatch;
import net.minecraft.client.data.models.blockstates.Variant;
import net.minecraft.client.data.models.blockstates.VariantProperties;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public interface ModelUtil {
    public static void horizontalFacingBlock(Block block, Property<Direction> property, BlockModelGenerators blockModels) {
        blockModels.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)block).with(ModelUtil.createHorizontalFacingDispatch(property, (Direction facing, Variant variant) -> variant.with(VariantProperties.MODEL, (Object)ModelLocationUtils.getModelLocation((Block)block)))));
    }

    public static <TBlock extends Block> void horizontalFacingBlock(TBlock block, BlockModelGenerators blockModels) {
        EnumProperty<Direction> facingProperty = ((ComponentHolder)block).getComponentOrThrow(BlockComponentTypes.FACING).getProperty();
        ModelUtil.horizontalFacingBlock(block, facingProperty, blockModels);
    }

    public static PropertyDispatch createHorizontalFacingDispatch(Property<Direction> property, BiFunction<Direction, Variant, Variant> modifier) {
        return PropertyDispatch.property(property).select((Comparable)Direction.EAST, modifier.apply(Direction.EAST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90))).select((Comparable)Direction.SOUTH, modifier.apply(Direction.SOUTH, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180))).select((Comparable)Direction.WEST, modifier.apply(Direction.WEST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270))).select((Comparable)Direction.NORTH, modifier.apply(Direction.NORTH, Variant.variant()));
    }

    public static PropertyDispatch createHorizontalFacingDispatch(Property<Direction> property) {
        return ModelUtil.createHorizontalFacingDispatch(property, (Direction facing, Variant variant) -> variant);
    }

    public static <TBlock extends Block> PropertyDispatch createHorizontalFacingDispatch(TBlock block, BiFunction<Direction, Variant, Variant> modifier) {
        return ModelUtil.createHorizontalFacingDispatch(((ComponentHolder)block).getComponentOrThrow(BlockComponentTypes.FACING).getProperty(), modifier);
    }

    public static <TBlock extends Block> PropertyDispatch createHorizontalFacingDispatch(TBlock block) {
        return ModelUtil.createHorizontalFacingDispatch(block, (Direction facing, Variant variant) -> variant);
    }

    public static <TBlock extends Block, TValue extends Comparable<TValue>> PropertyDispatch createPropertyDispatch(TBlock block, Function<TBlock, Property<TValue>> propertyGetter, Function<TValue, ResourceLocation> modelGetter) {
        return PropertyDispatch.property(propertyGetter.apply(block)).generate(value -> Variant.variant().with(VariantProperties.MODEL, (Object)((ResourceLocation)modelGetter.apply(value))));
    }

    public static <TBlock extends Block> void multiBlockModel(TBlock block, BlockModelGenerators blockModels, IntFunction<ResourceLocation> modelGetter) {
        blockModels.blockStateOutput.accept(MultiVariantGenerator.multiVariant(block).with(ModelUtil.createPropertyDispatch(block, b -> ((ComponentHolder)block).getComponentOrThrow(BlockComponentTypes.MULTI_BLOCK).property(), modelGetter::apply)).with(ModelUtil.createHorizontalFacingDispatch(block)));
    }

    public static <TBlock extends Block> void multiBlockModelSuffix(TBlock block, BlockModelGenerators blockModels, IntFunction<String> suffixGetter) {
        ModelUtil.multiBlockModel(block, blockModels, index -> ModelLocationUtils.getModelLocation((Block)block, (String)((String)suffixGetter.apply(index))));
    }

    public static void registerBlockItemModel(Block block, BlockModelGenerators blockModels) {
        Item item = block.asItem();
        blockModels.registerSimpleItemModel(item, ModelLocationUtils.getModelLocation((Item)item));
    }

    public static <TBlock extends Block, TValue extends Comparable<TValue>> void facingPropertyModel(TBlock block, BlockModelGenerators blockModels, Function<TBlock, Property<TValue>> propertyGetter, Function<TValue, ResourceLocation> modelGetter, TValue itemValue) {
        blockModels.blockStateOutput.accept(MultiVariantGenerator.multiVariant(block).with(ModelUtil.createPropertyDispatch(block, propertyGetter, modelGetter)).with(ModelUtil.createHorizontalFacingDispatch(block)));
    }

    public static <TBlock extends Block, TValue extends Comparable<TValue>> void facingPropertyModel(TBlock block, BlockModelGenerators blockModels, Property<TValue> property, Function<TValue, ResourceLocation> modelGetter, TValue itemValue) {
        ModelUtil.facingPropertyModel(block, blockModels, (TBlock $) -> property, modelGetter, itemValue);
    }

    public static <TBlock extends Block, TValue extends Comparable<TValue>> void facingPropertyModelSuffix(TBlock block, BlockModelGenerators blockModels, Function<TBlock, Property<TValue>> propertyGetter, Function<TValue, String> suffixGetter, TValue itemValue) {
        ModelUtil.facingPropertyModel(block, blockModels, propertyGetter, (TValue value) -> ModelLocationUtils.getModelLocation((Block)block, (String)((String)suffixGetter.apply(value))), itemValue);
    }

    public static <TBlock extends Block, TValue extends Comparable<TValue>> void facingPropertyModelSuffix(TBlock block, BlockModelGenerators blockModels, Property<TValue> property, Function<TValue, String> suffixGetter, TValue itemValue) {
        ModelUtil.facingPropertyModelSuffix(block, blockModels, (TBlock $) -> property, suffixGetter, itemValue);
    }

    public static <TBlock extends Block> void registerMultiBlockItemModel(TBlock block, IntFunction<ResourceLocation> modelGetter, BlockModelGenerators blockModels) {
        blockModels.itemModelOutput.accept(block.asItem(), ItemModelUtils.composite((ItemModel.Unbaked[])((ItemModel.Unbaked[])IntStream.range(0, ((ComponentHolder)block).getComponentOrThrow(BlockComponentTypes.MULTI_BLOCK).size()).mapToObj(modelGetter).map(ItemModelUtils::plainModel).toArray(ItemModel.Unbaked[]::new))));
    }

    public static <TBlock extends Block> void registerMultiBlockItemModelSuffix(TBlock block, IntFunction<String> suffixGetter, BlockModelGenerators blockModels) {
        ModelUtil.registerMultiBlockItemModel(block, index -> ModelLocationUtils.getModelLocation((Block)block, (String)((String)suffixGetter.apply(index))), blockModels);
    }

    public static void registerCompositeBlockItemModel(Block block, BlockModelGenerators blockModels, ItemModel.Unbaked ... models) {
        blockModels.itemModelOutput.accept(block.asItem(), ItemModelUtils.composite((ItemModel.Unbaked[])models));
    }

    public static void registerCompositeBlockItemModel(Block block, BlockModelGenerators blockModels, ResourceLocation ... models) {
        ModelUtil.registerCompositeBlockItemModel(block, blockModels, (ItemModel.Unbaked[])Stream.of(models).map(ItemModelUtils::plainModel).toArray(ItemModel.Unbaked[]::new));
    }

    public static void registerCompositeBlockItemModel(Block block, BlockModelGenerators blockModels, String ... suffixes) {
        ModelUtil.registerCompositeBlockItemModel(block, blockModels, (ResourceLocation[])Stream.of(suffixes).map(suffix -> ModelLocationUtils.getModelLocation((Block)block, (String)suffix)).toArray(ResourceLocation[]::new));
    }

    public static VariantProperties.Rotation facingToModelRotation(Direction facing) {
        return switch (facing) {
            case Direction.EAST -> VariantProperties.Rotation.R90;
            case Direction.SOUTH -> VariantProperties.Rotation.R180;
            case Direction.WEST -> VariantProperties.Rotation.R270;
            default -> VariantProperties.Rotation.R0;
        };
    }

    public static Rotation facingToRotation(Direction facing) {
        return switch (facing) {
            case Direction.EAST -> Rotation.CLOCKWISE_90;
            case Direction.SOUTH -> Rotation.CLOCKWISE_180;
            case Direction.WEST -> Rotation.COUNTERCLOCKWISE_90;
            default -> Rotation.NONE;
        };
    }

    public static VariantProperties.Rotation rotation(Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_90 -> VariantProperties.Rotation.R90;
            case Rotation.CLOCKWISE_180 -> VariantProperties.Rotation.R180;
            case Rotation.COUNTERCLOCKWISE_90 -> VariantProperties.Rotation.R270;
            default -> VariantProperties.Rotation.R0;
        };
    }

    public static Rotation rotation(VariantProperties.Rotation rotation) {
        return switch (rotation) {
            case VariantProperties.Rotation.R90 -> Rotation.CLOCKWISE_90;
            case VariantProperties.Rotation.R180 -> Rotation.CLOCKWISE_180;
            case VariantProperties.Rotation.R270 -> Rotation.COUNTERCLOCKWISE_90;
            default -> Rotation.NONE;
        };
    }
}

