/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.fluid;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class ItemOnlyFluid
extends Fluid {
    public abstract FluidType getFluidType();

    public abstract Item getBucket();

    public Optional<SoundEvent> getPickupSound() {
        return Optional.ofNullable(this.getFluidType().getSound(SoundActions.BUCKET_FILL));
    }

    protected boolean canBeReplacedWith(FluidState fluidState, BlockGetter level, BlockPos pos, Fluid fluid, Direction direction) {
        return false;
    }

    protected Vec3 getFlow(BlockGetter blockReader, BlockPos pos, FluidState fluidState) {
        return Vec3.ZERO;
    }

    public int getTickDelay(LevelReader level) {
        return 0;
    }

    protected float getExplosionResistance() {
        return 1.0f;
    }

    public float getHeight(FluidState fluidState, BlockGetter level, BlockPos pos) {
        return level.getFluidState(pos.above()).is((Fluid)this) ? 1.0f : fluidState.getOwnHeight();
    }

    public float getOwnHeight(FluidState fluidState) {
        return 0.8888889f;
    }

    protected BlockState createLegacyBlock(FluidState fluidState) {
        return Blocks.AIR.defaultBlockState();
    }

    public boolean isSource(FluidState fluidState) {
        return true;
    }

    public int getAmount(FluidState fluidState) {
        return 8;
    }

    public VoxelShape getShape(FluidState fluidState, BlockGetter level, BlockPos pos) {
        return Shapes.empty();
    }

    public static Fluid simple(Supplier<? extends FluidType> fluidType, ItemLike bucket) {
        return new Simple(fluidType, bucket);
    }

    public static Fluid simple(Supplier<? extends FluidType> fluidType) {
        return ItemOnlyFluid.simple(fluidType, (ItemLike)Items.AIR);
    }

    public static Supplier<Fluid> simpleFactory(Supplier<? extends FluidType> fluidType, ItemLike bucket) {
        return () -> ItemOnlyFluid.simple(fluidType, bucket);
    }

    public static Supplier<Fluid> simpleFactory(Supplier<? extends FluidType> fluidType) {
        return () -> ItemOnlyFluid.simple(fluidType);
    }

    private static final class Simple
    extends ItemOnlyFluid {
        private final Supplier<? extends FluidType> fluidType;
        private final ItemLike bucket;

        private Simple(Supplier<? extends FluidType> fluidType, ItemLike bucket) {
            this.fluidType = fluidType;
            this.bucket = bucket;
        }

        @Override
        public FluidType getFluidType() {
            return this.fluidType.get();
        }

        @Override
        public Item getBucket() {
            return this.bucket.asItem();
        }
    }
}

