/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.level.delegate;

import dev.apexstudios.apexcore.lib.level.delegate.DelegatedLevelHeightAccessor;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.world.AuxiliaryLightManager;
import org.jetbrains.annotations.Nullable;

public interface DelegatedBlockGetter
extends BlockGetter,
DelegatedLevelHeightAccessor {
    public BlockGetter delegate();

    @Nullable
    default public BlockEntity getBlockEntity(BlockPos pos) {
        return this.delegate().getBlockEntity(pos);
    }

    default public <T extends BlockEntity> Optional<T> getBlockEntity(BlockPos pos, BlockEntityType<T> blockEntityType) {
        return this.delegate().getBlockEntity(pos, blockEntityType);
    }

    default public BlockState getBlockState(BlockPos pos) {
        return this.delegate().getBlockState(pos);
    }

    default public FluidState getFluidState(BlockPos pos) {
        return this.delegate().getFluidState(pos);
    }

    default public int getLightEmission(BlockPos pos) {
        return this.delegate().getLightEmission(pos);
    }

    default public Stream<BlockState> getBlockStates(AABB area) {
        return this.delegate().getBlockStates(area);
    }

    default public BlockHitResult isBlockInLine(ClipBlockStateContext context) {
        return this.delegate().isBlockInLine(context);
    }

    default public BlockHitResult clip(ClipContext context) {
        return this.delegate().clip(context);
    }

    @Nullable
    default public BlockHitResult clipWithInteractionOverride(Vec3 startVec, Vec3 endVec, BlockPos pos, VoxelShape shape, BlockState state) {
        return this.delegate().clipWithInteractionOverride(startVec, endVec, pos, shape, state);
    }

    default public double getBlockFloorHeight(VoxelShape shape, Supplier<VoxelShape> belowShapeSupplier) {
        return this.delegate().getBlockFloorHeight(shape, belowShapeSupplier);
    }

    default public double getBlockFloorHeight(BlockPos pos) {
        return this.delegate().getBlockFloorHeight(pos);
    }

    @Nullable
    default public AuxiliaryLightManager getAuxLightManager(BlockPos pos) {
        return this.delegate().getAuxLightManager(pos);
    }

    @Nullable
    default public AuxiliaryLightManager getAuxLightManager(ChunkPos pos) {
        return this.delegate().getAuxLightManager(pos);
    }

    default public ModelData getModelData(BlockPos pos) {
        return this.delegate().getModelData(pos);
    }
}

