/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.level.delegate;

import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public interface DelegatedEntityGetter
extends EntityGetter {
    public EntityGetter delegate();

    default public List<Entity> getEntities(@Nullable Entity entity, AABB area, Predicate<? super Entity> predicate) {
        return this.delegate().getEntities(entity, area, predicate);
    }

    default public <T extends Entity> List<T> getEntities(EntityTypeTest<Entity, T> entityTypeTest, AABB bounds, Predicate<? super T> predicate) {
        return this.delegate().getEntities(entityTypeTest, bounds, predicate);
    }

    default public <T extends Entity> List<T> getEntitiesOfClass(Class<T> entityClass, AABB area, Predicate<? super T> filter) {
        return this.delegate().getEntitiesOfClass(entityClass, area, filter);
    }

    default public List<? extends Player> players() {
        return this.delegate().players();
    }

    default public List<Entity> getEntities(@Nullable Entity entity, AABB area) {
        return this.delegate().getEntities(entity, area);
    }

    default public boolean isUnobstructed(@Nullable Entity p_entity, VoxelShape shape) {
        return this.delegate().isUnobstructed(p_entity, shape);
    }

    default public <T extends Entity> List<T> getEntitiesOfClass(Class<T> entityClass, AABB area) {
        return this.delegate().getEntitiesOfClass(entityClass, area);
    }

    default public List<VoxelShape> getEntityCollisions(@Nullable Entity p_entity, AABB collisionBox) {
        return this.delegate().getEntityCollisions(p_entity, collisionBox);
    }

    @Nullable
    default public Player getNearestPlayer(double x, double y, double z, double distance, @Nullable Predicate<Entity> predicate) {
        return this.delegate().getNearestPlayer(x, y, z, distance, predicate);
    }

    @Nullable
    default public Player getNearestPlayer(Entity entity, double distance) {
        return this.delegate().getNearestPlayer(entity, distance);
    }

    @Nullable
    default public Player getNearestPlayer(double x, double y, double z, double distance, boolean creativePlayers) {
        return this.delegate().getNearestPlayer(x, y, z, distance, creativePlayers);
    }

    default public boolean hasNearbyAlivePlayer(double x, double y, double z, double distance) {
        return this.delegate().hasNearbyAlivePlayer(x, y, z, distance);
    }

    @Nullable
    default public Player getPlayerByUUID(UUID uniqueId) {
        return this.delegate().getPlayerByUUID(uniqueId);
    }
}

