/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.menu;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class SimpleMenu
extends AbstractContainerMenu {
    private final int rowCount;

    public SimpleMenu(MenuType<? extends SimpleMenu> menuType, int containerId, Inventory inventory, IItemHandler itemHandler, int rowCount) {
        super(menuType, containerId);
        this.rowCount = rowCount;
        this.addItemHandlerSlots(itemHandler);
        this.addStandardInventorySlots((Container)inventory, 8, 18 + rowCount * 18 + 13);
    }

    public SimpleMenu(MenuType<? extends SimpleMenu> menuType, int containerId, Inventory inventory, int rowCount) {
        this(menuType, containerId, inventory, (IItemHandler)new ItemStackHandler(rowCount * 9), rowCount);
    }

    public int rowCount() {
        return this.rowCount;
    }

    protected void addItemHandlerSlots(IItemHandler itemHandler) {
        for (int i = 0; i < this.rowCount; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot((Slot)new SlotItemHandler(itemHandler, j + i * 9, 8 + j * 18, 18 + i * 18));
            }
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = slot.getItem();
        ItemStack stack1 = stack.copy();
        if (index < this.rowCount * 9 ? !this.moveItemStackTo(stack1, this.rowCount * 9, this.slots.size(), true) : !this.moveItemStackTo(stack1, 0, this.rowCount * 9, false)) {
            return ItemStack.EMPTY;
        }
        if (stack1.isEmpty()) {
            slot.setByPlayer(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        return stack;
    }

    public boolean stillValid(Player player) {
        return true;
    }
}

