/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.menu;

import dev.apexstudios.apexcore.core.ApexCore;
import dev.apexstudios.apexcore.lib.menu.SimpleMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class SimpleMenuScreen
extends AbstractContainerScreen<SimpleMenu> {
    public static final ResourceLocation WINDOW_SPRITE = ApexCore.identifier("window");
    public static final ResourceLocation SLOT_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/slot");

    public SimpleMenuScreen(SimpleMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
    }

    protected void init() {
        this.imageHeight = 114 + ((SimpleMenu)this.menu).rowCount() * 18;
        this.inventoryLabelY = this.imageHeight - 94;
        super.init();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        graphics.pose().pushPose();
        graphics.pose().translate((float)this.leftPos, (float)this.topPos, 0.0f);
        graphics.blitSprite(RenderType::guiTextured, WINDOW_SPRITE, 0, -2, this.imageWidth, this.imageHeight + 1);
        for (Slot slot : ((SimpleMenu)this.menu).slots) {
            graphics.blitSprite(RenderType::guiTextured, SLOT_SPRITE, slot.x - 1, slot.y - 1, 18, 18);
        }
        graphics.pose().popPose();
    }
}

