/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.placement;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.apexstudios.apexcore.core.placement.FluidVertexConsumer;
import dev.apexstudios.apexcore.core.placement.GhostVertexConsumer;
import dev.apexstudios.apexcore.lib.level.FakeLevel;
import dev.apexstudios.apexcore.lib.placement.PlacementRenderEvent;
import dev.apexstudios.apexcore.lib.util.ApexRenderTypes;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface BlockPlacementRenderer {
    public boolean renderForHand(Level var1, Player var2, InteractionHand var3, BlockHitResult var4, Camera var5, PoseStack var6, MultiBufferSource.BufferSource var7);

    public static void renderAt(Camera camera, PoseStack pose, Runnable runnable) {
        Vec3 camPos = camera.getPosition();
        pose.pushPose();
        pose.translate(-camPos.x, -camPos.y, -camPos.z);
        runnable.run();
        pose.popPose();
    }

    public static void renderLevel(BlockPlaceContext context, PoseStack pose, boolean canBePlaced) {
        MultiBufferSource.BufferSource buffers = Minecraft.getInstance().renderBuffers().bufferSource();
        BlockPlacementRenderer.renderBlockStates(context, buffers, pose, canBePlaced);
        buffers.endBatch();
        BlockPlacementRenderer.renderFluidStates(context, buffers, pose, canBePlaced);
        buffers.endBatch();
        BlockPlacementRenderer.renderBlockEntities(context, buffers, pose, canBePlaced);
        buffers.endBatch();
    }

    public static void renderBlockStates(BlockPlaceContext context, MultiBufferSource.BufferSource buffers, PoseStack pose, boolean canBePlaced) {
        FakeLevel level = (FakeLevel)context.getLevel();
        level.positions().forEach(pos -> BlockPlacementRenderer.renderBlockState(level, pos, level.getBlockState((BlockPos)pos), buffers, pose, canBePlaced));
    }

    public static void renderBlockState(Level level, BlockPos pos, BlockState blockState, MultiBufferSource.BufferSource buffers, PoseStack pose, boolean canBePlaced) {
        if (blockState.getRenderShape() == RenderShape.INVISIBLE) {
            return;
        }
        BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
        ModelBlockRenderer modelRenderer = blockRenderer.getModelRenderer();
        BakedModel model = blockRenderer.getBlockModel(blockState);
        ModelData modelData = level.getModelData(pos);
        pose.pushPose();
        pose.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
        for (RenderType renderType : model.getRenderTypes(blockState, level.random, modelData)) {
            modelRenderer.tesselateBlock((BlockAndTintGetter)level, model, blockState, pos, pose, (VertexConsumer)new GhostVertexConsumer(buffers.getBuffer(ApexRenderTypes.entityTranslucentNoDepth(TextureAtlas.LOCATION_BLOCKS)), 170), true, level.random, blockState.getSeed(pos), canBePlaced ? OverlayTexture.NO_OVERLAY : OverlayTexture.pack((int)3, (int)0), modelData, renderType);
        }
        pose.popPose();
    }

    public static void renderFluidStates(BlockPlaceContext context, MultiBufferSource.BufferSource buffers, PoseStack pose, boolean canBePlaced) {
        FakeLevel level = (FakeLevel)context.getLevel();
        level.positions().forEach(pos -> BlockPlacementRenderer.renderFluidState((BlockAndTintGetter)level, pos, level.getBlockState((BlockPos)pos), buffers, pose, canBePlaced));
    }

    public static void renderFluidState(BlockAndTintGetter level, BlockPos pos, BlockState blockState, MultiBufferSource.BufferSource buffers, PoseStack pose, boolean canBePlaced) {
        BlockPlacementRenderer.renderFluidState(level, pos, blockState, blockState.getFluidState(), buffers, pose, canBePlaced);
    }

    public static void renderFluidState(BlockAndTintGetter level, BlockPos pos, BlockState blockState, FluidState fluidState, MultiBufferSource.BufferSource buffers, PoseStack pose, boolean canBePlaced) {
        if (fluidState.isEmpty()) {
            return;
        }
        pose.pushPose();
        pose.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
        Minecraft.getInstance().getBlockRenderer().renderLiquid(pos, level, (VertexConsumer)new GhostVertexConsumer((VertexConsumer)new FluidVertexConsumer(buffers.getBuffer(ApexRenderTypes.translucentNoDepth()), pose, pos), 170), blockState, fluidState);
        pose.popPose();
    }

    public static void renderBlockEntities(BlockPlaceContext context, MultiBufferSource.BufferSource buffers, PoseStack pose, boolean canBePlaced) {
        FakeLevel level = (FakeLevel)context.getLevel();
        level.positions().forEach(pos -> BlockPlacementRenderer.renderBlockEntity(level.getBlockEntity((BlockPos)pos), buffers, pose, canBePlaced));
    }

    public static void renderBlockEntity(@Nullable BlockEntity blockEntity, MultiBufferSource.BufferSource buffers, PoseStack pose, boolean canBePlaced) {
        if (blockEntity == null) {
            return;
        }
        BlockPos pos = blockEntity.getBlockPos();
        pose.pushPose();
        pose.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
        Minecraft.getInstance().getBlockEntityRenderDispatcher().render(blockEntity, 0.0f, pose, (MultiBufferSource)buffers);
        pose.popPose();
    }

    public static BlockState getDefaultBlockState(LevelReader realLevel, BlockPlaceContext context, BlockState blockState) {
        BlockPos pos = context.getClickedPos();
        if (blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(realLevel.getFluidState(pos).getType().isSame((Fluid)Fluids.WATER)));
        }
        if (blockState.hasProperty((Property)BlockStateProperties.ROTATION_16)) {
            blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.ROTATION_16, (Comparable)Integer.valueOf(RotationSegment.convertToSegment((float)(context.getRotation() + 180.0f))));
        }
        if (blockState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            Direction facing = context.getHorizontalDirection();
            if (blockState.getBlock() instanceof AbstractFurnaceBlock) {
                facing = facing.getOpposite();
            } else if (blockState.is(BlockTags.ANVIL)) {
                facing = facing.getClockWise();
            }
            blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing);
        } else if (blockState.hasProperty((Property)BlockStateProperties.FACING)) {
            Direction facing = context.getClickedFace();
            if (blockState.is(Tags.Blocks.BARRELS)) {
                facing = context.getNearestLookingDirection().getOpposite();
            }
            blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.FACING, (Comparable)facing);
        }
        return PlacementRenderEvent.getDefaultBlockState(realLevel, context, blockState);
    }
}

