/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.placement;

import com.google.common.collect.Lists;
import dev.apexstudios.apexcore.lib.placement.BlockPlacementRenderer;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.event.IModBusEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract sealed class PlacementRenderEvent
extends Event {
    @ApiStatus.Internal
    public static BlockState getDefaultBlockState(LevelReader realLevel, BlockPlaceContext placeContext, BlockState defaultBlockState) {
        return ((DefaultBlockState)NeoForge.EVENT_BUS.post((Event)new DefaultBlockState(realLevel, placeContext, defaultBlockState))).defaultBlockState();
    }

    @ApiStatus.Internal
    public static BlockState modifyBlockState(LevelReader realLevel, BlockPlaceContext placeContext, BlockState originalBlockState) {
        return ((ModifyBlockState)NeoForge.EVENT_BUS.post((Event)new ModifyBlockState(realLevel, placeContext, originalBlockState))).originalBlockState();
    }

    @ApiStatus.Internal
    public static Iterable<BlockPlacementRenderer> registerRenderers(Consumer<Consumer<BlockPlacementRenderer>> registerBuiltIn) {
        LinkedList registry = Lists.newLinkedList();
        registerBuiltIn.accept(registry::add);
        ModLoader.postEventWrapContainerInModOrder((Event)new Register(registry::add));
        return List.copyOf(registry);
    }

    public static final class DefaultBlockState
    extends PlacementRenderEvent {
        private final LevelReader realLevel;
        private final BlockPlaceContext placeContext;
        private final BlockState defaultBlockState;
        @Nullable
        private BlockState newDefaultBlockState;

        private DefaultBlockState(LevelReader realLevel, BlockPlaceContext placeContext, BlockState defaultBlockState) {
            this.realLevel = realLevel;
            this.placeContext = placeContext;
            this.defaultBlockState = defaultBlockState;
        }

        public LevelReader level() {
            return this.realLevel;
        }

        public BlockPos pos() {
            return this.placeContext.getClickedPos();
        }

        public BlockPlaceContext placeContext() {
            return this.placeContext;
        }

        public BlockState defaultBlockState() {
            return this.newDefaultBlockState == null ? this.defaultBlockState : this.newDefaultBlockState;
        }

        public void setDefaultBlockState(BlockState defaultBlockState) {
            this.newDefaultBlockState = defaultBlockState;
        }

        public <TProperty extends Comparable<TProperty>> void withProperty(Property<TProperty> property, Supplier<TProperty> value) {
            BlockState blockState = this.defaultBlockState();
            if (blockState.hasProperty(property)) {
                this.setDefaultBlockState((BlockState)blockState.trySetValue(property, (Comparable)value.get()));
            }
        }
    }

    public static final class ModifyBlockState
    extends PlacementRenderEvent {
        private final LevelReader realLevel;
        private final BlockPlaceContext placeContext;
        private final BlockState originalBlockState;
        @Nullable
        private BlockState newBlockState;

        private ModifyBlockState(LevelReader realLevel, BlockPlaceContext placeContext, BlockState originalBlockState) {
            this.realLevel = realLevel;
            this.placeContext = placeContext;
            this.originalBlockState = originalBlockState;
        }

        public LevelReader level() {
            return this.realLevel;
        }

        public BlockPos pos() {
            return this.placeContext.getClickedPos();
        }

        public BlockPlaceContext placeContext() {
            return this.placeContext;
        }

        public BlockState originalBlockState() {
            return this.newBlockState == null ? this.originalBlockState : this.newBlockState;
        }

        public void setBlockState(BlockState blockState) {
            this.newBlockState = blockState;
        }

        public <TProperty extends Comparable<TProperty>> void withProperty(Property<TProperty> property, Supplier<TProperty> value) {
            BlockState blockState = this.originalBlockState();
            if (blockState.hasProperty(property)) {
                this.setBlockState((BlockState)blockState.trySetValue(property, (Comparable)value.get()));
            }
        }
    }

    public static final class Register
    extends PlacementRenderEvent
    implements IModBusEvent {
        private final Consumer<BlockPlacementRenderer> registrar;

        private Register(Consumer<BlockPlacementRenderer> registrar) {
            this.registrar = registrar;
        }

        public void register(BlockPlacementRenderer renderer) {
            this.registrar.accept(renderer);
        }
    }
}

