/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.util;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.apexstudios.apexcore.core.ApexCore;
import java.util.OptionalDouble;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public interface ApexRenderTypes {
    public static final RenderStateShard.DepthTestStateShard DEPTH_TEST_NOT_EQUAL = new RenderStateShard.DepthTestStateShard("!=", 517);
    public static final BiFunction<ResourceLocation, Boolean, RenderType> ENTITY_TRANSLUCENT_NO_DEPTH = Util.memoize((texture, outline) -> RenderType.create((String)ApexCore.id("entity_translucent_no_depth"), (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_ENTITY_TRANSLUCENT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)RenderStateShard.BLOCK_SHEET_MIPPED).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setCullState(RenderStateShard.CULL).setLightmapState(RenderStateShard.LIGHTMAP).setOverlayState(RenderStateShard.OVERLAY).setWriteMaskState(RenderStateShard.COLOR_WRITE).setDepthTestState(DEPTH_TEST_NOT_EQUAL).setLayeringState(RenderStateShard.POLYGON_OFFSET_LAYERING).createCompositeState(outline.booleanValue())));
    public static final RenderType TRANSLUCENT_NO_DEPTH = RenderType.create((String)ApexCore.id("translucent_no_depth"), (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)786432, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setLightmapState(RenderStateShard.LIGHTMAP).setShaderState(RenderStateShard.RENDERTYPE_TRANSLUCENT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)RenderStateShard.BLOCK_SHEET_MIPPED).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setDepthTestState(DEPTH_TEST_NOT_EQUAL).createCompositeState(true));
    public static final RenderType LINES_NO_DEPTH = RenderType.create((String)ApexCore.id("lines_no_depth"), (VertexFormat)DefaultVertexFormat.POSITION_COLOR_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)1536, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_LINES_SHADER).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.empty())).setLayeringState(RenderStateShard.VIEW_OFFSET_Z_LAYERING).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setOutputState(RenderStateShard.ITEM_ENTITY_TARGET).setWriteMaskState(RenderStateShard.COLOR_WRITE).setCullState(RenderStateShard.NO_CULL).setDepthTestState(DEPTH_TEST_NOT_EQUAL).setLayeringState(RenderStateShard.POLYGON_OFFSET_LAYERING).createCompositeState(false));

    public static RenderType entityTranslucentNoDepth(ResourceLocation texture, boolean outline) {
        return ENTITY_TRANSLUCENT_NO_DEPTH.apply(texture, outline);
    }

    public static RenderType entityTranslucentNoDepth(ResourceLocation texture) {
        return ApexRenderTypes.entityTranslucentNoDepth(texture, true);
    }

    public static RenderType linesNoDepth() {
        return LINES_NO_DEPTH;
    }

    public static RenderType translucentNoDepth() {
        return TRANSLUCENT_NO_DEPTH;
    }

    public static void register() {
    }
}

