/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.function.UnaryOperator;
import net.minecraft.core.IdMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.Utf8String;
import net.minecraft.network.VarInt;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;

public interface ApexStreamCodecs {
    public static final StreamCodec<ByteBuf, BlockState> BLOCK_STATE = ByteBufCodecs.idMapper((IdMap)Block.BLOCK_STATE_REGISTRY);
    public static final StreamCodec<ByteBuf, FluidState> FLUID_STATE = ByteBufCodecs.idMapper((IdMap)Fluid.FLUID_STATE_REGISTRY);

    public static <TBuffer extends ByteBuf, TValue extends Enum<TValue>> StreamCodec<TBuffer, TValue> forNamedEnum(Supplier<TValue[]> valuesSupplier, UnaryOperator<String> nameMapper) {
        Function nameLookup = StringRepresentable.createNameLookup((StringRepresentable[])((Enum[])valuesSupplier.get()), nameMapper);
        return ApexStreamCodecs.stringUtf8(Short.MAX_VALUE).map(nameLookup, rec$ -> ((StringRepresentable)rec$).getSerializedName());
    }

    public static <TBuffer extends ByteBuf, TValue extends Enum<TValue>> StreamCodec<TBuffer, TValue> forNamedEnum(Supplier<TValue[]> valuesSupplier) {
        return ApexStreamCodecs.forNamedEnum(valuesSupplier, UnaryOperator.identity());
    }

    public static <TValue extends Enum<TValue>> StreamCodec<ByteBuf, TValue> forEnum(Class<TValue> enumType) {
        return ByteBufCodecs.VAR_INT.map(ordinal -> ((Enum[])enumType.getEnumConstants())[ordinal], Enum::ordinal);
    }

    public static <TBuffer extends ByteBuf> StreamCodec<TBuffer, byte[]> byteArray(int maxSize) {
        return StreamCodec.of((buffer, value) -> {
            if (((byte[])value).length > maxSize) {
                throw new EncoderException("ByteArray with size " + ((byte[])value).length + " is bigger than allowed " + maxSize);
            }
            FriendlyByteBuf.writeByteArray((ByteBuf)buffer, (byte[])value);
        }, buffer -> FriendlyByteBuf.readByteArray((ByteBuf)buffer, (int)maxSize));
    }

    public static <TBuffer extends ByteBuf> StreamCodec<TBuffer, String> stringUtf8(int maxLength) {
        return StreamCodec.of((buffer, value) -> Utf8String.write((ByteBuf)buffer, (CharSequence)value, (int)maxLength), buffer -> Utf8String.read((ByteBuf)buffer, (int)maxLength));
    }

    public static <TBuffer extends ByteBuf> StreamCodec<TBuffer, Tag> tagCodec(Supplier<NbtAccounter> accounter) {
        return StreamCodec.of((buffer, value) -> {
            if (value == EndTag.INSTANCE) {
                throw new EncoderException("Expected non-null compound tag");
            }
            FriendlyByteBuf.writeNbt((ByteBuf)buffer, (Tag)value);
        }, buffer -> {
            Tag tag = FriendlyByteBuf.readNbt((ByteBuf)buffer, (NbtAccounter)((NbtAccounter)accounter.get()));
            if (tag == null) {
                throw new DecoderException("Expected non-null compound tag");
            }
            return tag;
        });
    }

    public static <TBuffer extends ByteBuf> StreamCodec<TBuffer, CompoundTag> compoundTagCodec(Supplier<NbtAccounter> accounterSupplier) {
        return ApexStreamCodecs.tagCodec(accounterSupplier).map(tag -> {
            if (tag instanceof CompoundTag) {
                return (CompoundTag)tag;
            }
            throw new DecoderException("Not a compound tag: " + String.valueOf(tag));
        }, Function.identity());
    }

    public static <TBuffer extends ByteBuf, TData> StreamCodec<TBuffer, TData> fromCodecTrusted(Codec<TData> codec) {
        return ApexStreamCodecs.fromCodec(codec, NbtAccounter::unlimitedHeap);
    }

    public static <TBuffer extends ByteBuf, TData> StreamCodec<TBuffer, TData> fromCodec(Codec<TData> codec) {
        return ApexStreamCodecs.fromCodec(codec, () -> NbtAccounter.create((long)0x200000L));
    }

    public static <TBuffer extends ByteBuf, TData> StreamCodec<TBuffer, TData> fromCodec(Codec<TData> codec, Supplier<NbtAccounter> accounterSupplier) {
        return ApexStreamCodecs.tagCodec(accounterSupplier).map(tag -> codec.parse((DynamicOps)NbtOps.INSTANCE, tag).getOrThrow(value -> new DecoderException("Failed to decode: " + value + " " + String.valueOf(tag))), data -> (Tag)codec.encodeStart((DynamicOps)NbtOps.INSTANCE, data).getOrThrow(value -> new EncoderException("Failed to encode: " + value + " " + String.valueOf(data))));
    }

    public static <TBuffer extends ByteBuf, TData> StreamCodec<TBuffer, TData> idMapper(IntFunction<TData> idLookup, ToIntFunction<TData> idGetter) {
        return StreamCodec.of((buffer, value) -> VarInt.write((ByteBuf)buffer, (int)idGetter.applyAsInt(value)), buffer -> idLookup.apply(VarInt.read((ByteBuf)buffer)));
    }

    public static <TBuffer extends ByteBuf, TData> StreamCodec<TBuffer, TData> idMapper(IdMap<TData> idMap) {
        return ApexStreamCodecs.idMapper(arg_0 -> idMap.byIdOrThrow(arg_0), arg_0 -> idMap.getIdOrThrow(arg_0));
    }
}

