/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.util;

import com.google.common.base.Predicates;
import dev.apexstudios.apexcore.mixin.BlockAccessor;
import dev.apexstudios.apexcore.mixin.LootTableAccessor;
import dev.apexstudios.apexcore.mixin.StateDefinitionBuilderAccessor;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.registries.GameData;
import org.jetbrains.annotations.Nullable;

public interface ApexUtil {
    public static <TOwner, TStateHolder extends StateHolder<TOwner, TStateHolder>> StateDefinition<TOwner, TStateHolder> buildStateDefinition(TOwner owner, Function<TOwner, TStateHolder> defaultStateLookup, StateDefinition.Factory<TOwner, TStateHolder> stateDefinitionFactory, Consumer<StateDefinition.Builder<TOwner, TStateHolder>> propertyRegistrar, Consumer<TStateHolder> defaultStateRegistrar) {
        StateDefinition.Builder builder = new StateDefinition.Builder(owner);
        propertyRegistrar.accept(builder);
        StateDefinition stateDefinition = builder.create(defaultStateLookup, stateDefinitionFactory);
        defaultStateRegistrar.accept(stateDefinition.any());
        return stateDefinition;
    }

    public static <TOwner, TStateHolder extends StateHolder<TOwner, TStateHolder>, TProperty extends Comparable<TProperty>> StateDefinition<TOwner, TStateHolder> buildStateDefinition(TOwner owner, Function<TOwner, TStateHolder> defaultStateLookup, StateDefinition.Factory<TOwner, TStateHolder> stateDefinitionFactory, Property<TProperty> property, TProperty defaultValue) {
        return ApexUtil.buildStateDefinition(owner, defaultStateLookup, stateDefinitionFactory, (StateDefinition.Builder<TOwner, TStateHolder> registrar) -> registrar.add(new Property[]{property}), defaultState -> defaultState.setValue(property, defaultValue));
    }

    public static void replaceBlockStateDefinition(Block block, Iterable<Property<?>> deprecatedProperties, Consumer<Consumer<Property<?>>> propertyRegistrar, UnaryOperator<BlockState> defaultBlockStateRegistrar) {
        BlockAccessor accessor = (BlockAccessor)block;
        BlockState oldDefaultBlockState = block.defaultBlockState();
        accessor.ApexCore$setStateDefinition(ApexUtil.buildStateDefinition(block, Block::defaultBlockState, BlockState::new, (StateDefinition.Builder<TOwner, TStateHolder> builder) -> {
            accessor.ApexCore$createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder);
            deprecatedProperties.forEach(property -> ((StateDefinitionBuilderAccessor)builder).ApexCore$getProperties().remove(property.getName()));
            propertyRegistrar.accept(xva$0 -> builder.add(new Property[]{xva$0}));
        }, defaultBlockState -> {
            accessor.ApexCore$registerDefaultBlockState((BlockState)defaultBlockState);
            defaultBlockState = block.withPropertiesOf(oldDefaultBlockState);
            defaultBlockState = (BlockState)defaultBlockStateRegistrar.apply((BlockState)defaultBlockState);
            accessor.ApexCore$registerDefaultBlockState((BlockState)defaultBlockState);
        }));
    }

    public static <TProperty extends Comparable<TProperty>> void replaceBlockStateDefinition(Block block, Property<TProperty> property, TProperty defaultValue) {
        ApexUtil.replaceBlockStateDefinition(block, Collections.emptyList(), registrar -> registrar.accept(property), defaultBlockState -> (BlockState)defaultBlockState.setValue(property, defaultValue));
    }

    public static boolean isInWorldBounds(LevelHeightAccessor level, BlockPos pos) {
        return !level.isOutsideBuildHeight(pos) && ApexUtil.isInWorldBoundsHorizontal(pos);
    }

    public static boolean isInWorldBoundsHorizontal(BlockPos pos) {
        return pos.getX() >= -30000000 && pos.getZ() >= -30000000 && pos.getX() < 30000000 && pos.getZ() < 30000000;
    }

    public static <TLevel extends LevelHeightAccessor & CollisionGetter> boolean isInBounds(TLevel level, BlockPos pos) {
        if (!ApexUtil.isInWorldBounds(level, pos)) {
            return false;
        }
        return ((CollisionGetter)level).getWorldBorder().isWithinBounds(pos);
    }

    public static boolean canPlace(LevelReader level, BlockPos pos, BlockState blockState, @Nullable LivingEntity placer) {
        CollisionContext collisionContext = placer == null ? CollisionContext.empty() : CollisionContext.of((Entity)placer);
        BlockState levelBlockState = level.getBlockState(pos);
        if (!blockState.isAir() && !levelBlockState.canBeReplaced()) {
            return false;
        }
        if (!blockState.canSurvive(level, pos)) {
            return false;
        }
        if (!level.isUnobstructed(blockState, pos, collisionContext)) {
            return false;
        }
        if (placer instanceof Player) {
            Level lvl;
            Player player = (Player)placer;
            if (!player.mayBuild()) {
                return false;
            }
            if (level instanceof Level && !(lvl = (Level)level).mayInteract(player, pos)) {
                return false;
            }
        }
        return true;
    }

    public static boolean canPlace(BlockPlaceContext context, BlockState blockState) {
        Player placer = context.getPlayer();
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        CollisionContext collisionContext = placer == null ? CollisionContext.empty() : CollisionContext.of((Entity)placer);
        BlockState levelBlockState = level.getBlockState(pos);
        if (!blockState.isAir() && !levelBlockState.canBeReplaced(context)) {
            return false;
        }
        if (!blockState.canSurvive((LevelReader)level, pos)) {
            return false;
        }
        if (!level.isUnobstructed(blockState, pos, collisionContext)) {
            return false;
        }
        if (placer instanceof Player) {
            Level lvl;
            Player player = placer;
            if (!player.mayBuild()) {
                return false;
            }
            if (level instanceof Level && !(lvl = level).mayInteract(player, pos)) {
                return false;
            }
        }
        return true;
    }

    public static <TValue> void addAll(Collection<? super TValue> collection, Iterable<? extends TValue> values) {
        for (TValue value : values) {
            collection.add(value);
        }
    }

    @SafeVarargs
    public static <TValue> void removeAll(Collection<? super TValue> collection, TValue ... values) {
        for (TValue value : values) {
            collection.remove(value);
        }
    }

    public static <TValue> void removeAll(Collection<? super TValue> collection, Iterable<? extends TValue> values) {
        for (TValue value : values) {
            collection.remove(value);
        }
    }

    public static BlockState withPropertiesOf(BlockState source, BlockState target) {
        for (Property property : target.getProperties()) {
            if (!source.hasProperty(property)) continue;
            source = Block.copyProperty((BlockState)source, (BlockState)target, (Property)property);
        }
        return source;
    }

    public static <T> Class<T> asClass(Class<? super T> clazz) {
        return clazz;
    }

    public static void unpackLootTable(Level level, BlockPos pos, @Nullable Player player, @Nullable ResourceKey<LootTable> lootTableId, BiConsumer<LootTable, LootParams> filler) {
        if (lootTableId == null || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sLevel = (ServerLevel)level;
        LootTable lootTable = sLevel.getServer().reloadableRegistries().getLootTable(lootTableId);
        LootParams.Builder params = new LootParams.Builder(sLevel).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos));
        if (player != null) {
            params = params.withLuck(player.getLuck()).withParameter(LootContextParams.THIS_ENTITY, (Object)player);
        }
        filler.accept(lootTable, params.create(LootContextParamSets.CHEST));
    }

    public static void unpackLootTable(Level level, BlockPos pos, @Nullable Player player, @Nullable ResourceKey<LootTable> lootTableId, long seed, IItemHandlerModifiable itemHandler) {
        ApexUtil.unpackLootTable(level, pos, player, lootTableId, (lootTable, params) -> ApexUtil.fillItemHandlerFromLootTable(lootTable, itemHandler, params, seed));
    }

    public static void fillItemHandlerFromLootTable(LootTable lootTable, IItemHandlerModifiable itemHandler, LootParams params, long seed) {
        LootTableAccessor accessor = (LootTableAccessor)lootTable;
        LootContext context = new LootContext.Builder(params).withOptionalRandomSeed(seed).create(accessor.ApexCore$getRandomSequence());
        ObjectArrayList<ItemStack> items = accessor.ApexCore$getRandomItems(context);
        RandomSource random = context.getRandom();
        List<Integer> slots = ApexUtil.getAvailableSlots((IItemHandler)itemHandler, random);
        accessor.ApexCore$shuffleAndSplitItems(items, slots.size(), random);
        for (ItemStack item : items) {
            if (slots.isEmpty()) {
                LootTableAccessor.ApexCore$getLogger().warn("Tried to over-fill a item handler");
                return;
            }
            itemHandler.setStackInSlot(slots.removeLast().intValue(), item.isEmpty() ? ItemStack.EMPTY : item);
        }
    }

    private static List<Integer> getAvailableSlots(IItemHandler itemHandler, RandomSource random) {
        ObjectArrayList slots = new ObjectArrayList();
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            if (!itemHandler.getStackInSlot(i).isEmpty()) continue;
            slots.add((Object)i);
        }
        Util.shuffle((List)slots, (RandomSource)random);
        return slots;
    }

    public static void registerPoiBlockState(ResourceKey<PoiType> poiType, BlockState blockState) {
        Holder.Reference holder = BuiltInRegistries.POINT_OF_INTEREST_TYPE.getOrThrow(poiType);
        GameData.getBlockStatePointOfInterestTypeMap().put(blockState, holder);
    }

    public static void registerPoiBlockStates(ResourceKey<PoiType> poiType, Block block, Predicate<BlockState> filter) {
        for (BlockState blockState : block.getStateDefinition().getPossibleStates()) {
            if (!filter.test(blockState)) continue;
            ApexUtil.registerPoiBlockState(poiType, blockState);
        }
    }

    public static void registerPoiBlockStates(ResourceKey<PoiType> poiType, Block block) {
        ApexUtil.registerPoiBlockStates(poiType, block, (Predicate<BlockState>)Predicates.alwaysTrue());
    }
}

