/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.apexcore.lib.util.shapes;

import com.google.common.collect.Maps;
import com.mojang.math.OctahedralGroup;
import dev.apexstudios.apexcore.lib.util.shapes.ApexAxis;
import dev.apexstudios.apexcore.lib.util.shapes.ApexDiscreteVoxelShape;
import dev.apexstudios.apexcore.lib.util.shapes.ApexOctahedralGroup;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.ArrayVoxelShape;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CubeVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.ApiStatus;

public interface ApexShapes {
    @Deprecated(forRemoval=true, since="1.21.4")
    @ApiStatus.ScheduledForRemoval(inVersion="1.21.5")
    public static final Vec3 BLOCK_CENTER = new Vec3(0.5, 0.5, 0.5);

    public static VoxelShape join(VoxelShape shape, VoxelShape ... shapes) {
        VoxelShape result = shape;
        for (VoxelShape other : shapes) {
            result = Shapes.joinUnoptimized((VoxelShape)result, (VoxelShape)other, (BooleanOp)BooleanOp.OR);
        }
        return result.optimize();
    }

    @Deprecated(forRemoval=true, since="1.21.4")
    @ApiStatus.ScheduledForRemoval(inVersion="1.21.5")
    public static VoxelShape rotate(VoxelShape shape, OctahedralGroup group) {
        return ApexShapes.rotate(shape, group, BLOCK_CENTER);
    }

    @Deprecated(forRemoval=true, since="1.21.4")
    @ApiStatus.ScheduledForRemoval(inVersion="1.21.5")
    public static VoxelShape rotate(VoxelShape shape, OctahedralGroup group, Vec3 center) {
        if (group == OctahedralGroup.IDENTITY) {
            return shape;
        }
        DiscreteVoxelShape discrete = ApexDiscreteVoxelShape.rotate(shape.shape, group);
        if (shape instanceof CubeVoxelShape && BLOCK_CENTER.equals((Object)center)) {
            return new CubeVoxelShape(discrete);
        }
        Direction.Axis axisX = ApexOctahedralGroup.permute(group, Direction.Axis.X);
        Direction.Axis axisY = ApexOctahedralGroup.permute(group, Direction.Axis.Y);
        Direction.Axis axisZ = ApexOctahedralGroup.permute(group, Direction.Axis.Z);
        DoubleList xCoords = shape.getCoords(axisX);
        DoubleList yCoords = shape.getCoords(axisY);
        DoubleList zCoords = shape.getCoords(axisZ);
        boolean invertX = group.inverts(axisX);
        boolean invertY = group.inverts(axisY);
        boolean invertZ = group.inverts(axisZ);
        boolean chosenX = ApexAxis.choose(axisX, invertX, invertY, invertZ);
        boolean chosenY = ApexAxis.choose(axisY, invertX, invertY, invertZ);
        boolean chosenZ = ApexAxis.choose(axisZ, invertX, invertY, invertZ);
        return new ArrayVoxelShape(discrete, ApexShapes.makeAxis(xCoords, chosenX, center.get(axisX), center.x()), ApexShapes.makeAxis(yCoords, chosenY, center.get(axisY), center.y()), ApexShapes.makeAxis(zCoords, chosenZ, center.get(axisZ), center.z()));
    }

    @Deprecated(forRemoval=true, since="1.21.4")
    @ApiStatus.ScheduledForRemoval(inVersion="1.21.5")
    public static DoubleList makeAxis(DoubleList list, boolean flag, double x, double y) {
        int k;
        if (!flag && x == y) {
            return list;
        }
        int size = list.size();
        DoubleArrayList result = new DoubleArrayList(size);
        int j = flag ? -1 : 1;
        int n = k = flag ? size - 1 : 0;
        while (k >= 0 && k < size) {
            result.add(y + (double)j * (list.getDouble(k) - x));
            k += j;
        }
        return result;
    }

    @Deprecated(forRemoval=true, since="1.21.4")
    @ApiStatus.ScheduledForRemoval(inVersion="1.21.5")
    public static Map<Direction.Axis, VoxelShape> rotateHorizontalAxis(VoxelShape shape) {
        return ApexShapes.rotateHorizontalAxis(shape, BLOCK_CENTER);
    }

    @Deprecated(forRemoval=true, since="1.21.4")
    @ApiStatus.ScheduledForRemoval(inVersion="1.21.5")
    public static Map<Direction.Axis, VoxelShape> rotateHorizontalAxis(VoxelShape shape, Vec3 center) {
        return Maps.newEnumMap(Map.of(Direction.Axis.Z, shape, Direction.Axis.X, ApexShapes.rotate(shape, ApexOctahedralGroup.fromAngles(0, 90), center)));
    }

    @Deprecated(forRemoval=true, since="1.21.4")
    @ApiStatus.ScheduledForRemoval(inVersion="1.21.5")
    public static Map<Direction.Axis, VoxelShape> rotateAllAxis(VoxelShape shape) {
        return ApexShapes.rotateAllAxis(shape, BLOCK_CENTER);
    }

    @Deprecated(forRemoval=true, since="1.21.4")
    @ApiStatus.ScheduledForRemoval(inVersion="1.21.5")
    public static Map<Direction.Axis, VoxelShape> rotateAllAxis(VoxelShape shape, Vec3 center) {
        return Maps.newEnumMap(Map.of(Direction.Axis.Z, shape, Direction.Axis.X, ApexShapes.rotate(shape, ApexOctahedralGroup.fromAngles(0, 90), center), Direction.Axis.Y, ApexShapes.rotate(shape, ApexOctahedralGroup.fromAngles(90, 0), center)));
    }

    @Deprecated(forRemoval=true, since="1.21.4")
    @ApiStatus.ScheduledForRemoval(inVersion="1.21.5")
    public static Map<Direction, VoxelShape> rotateHorizontal(VoxelShape shape) {
        return ApexShapes.rotateHorizontal(shape, BLOCK_CENTER);
    }

    @Deprecated(forRemoval=true, since="1.21.4")
    @ApiStatus.ScheduledForRemoval(inVersion="1.21.5")
    public static Map<Direction, VoxelShape> rotateHorizontal(VoxelShape shape, Vec3 center) {
        return Maps.newEnumMap(Map.of(Direction.NORTH, shape, Direction.EAST, ApexShapes.rotate(shape, ApexOctahedralGroup.fromAngles(0, 90), center), Direction.SOUTH, ApexShapes.rotate(shape, ApexOctahedralGroup.fromAngles(0, 180), center), Direction.WEST, ApexShapes.rotate(shape, ApexOctahedralGroup.fromAngles(0, 270), center)));
    }

    @Deprecated(forRemoval=true, since="1.21.4")
    @ApiStatus.ScheduledForRemoval(inVersion="1.21.5")
    public static Map<Direction, VoxelShape> rotateAll(VoxelShape shape) {
        return ApexShapes.rotateAll(shape, BLOCK_CENTER);
    }

    @Deprecated(forRemoval=true, since="1.21.4")
    @ApiStatus.ScheduledForRemoval(inVersion="1.21.5")
    public static Map<Direction, VoxelShape> rotateAll(VoxelShape shape, Vec3 center) {
        return Maps.newEnumMap(Map.of(Direction.NORTH, shape, Direction.EAST, ApexShapes.rotate(shape, ApexOctahedralGroup.fromAngles(0, 90), center), Direction.SOUTH, ApexShapes.rotate(shape, ApexOctahedralGroup.fromAngles(0, 180), center), Direction.WEST, ApexShapes.rotate(shape, ApexOctahedralGroup.fromAngles(0, 270), center), Direction.UP, ApexShapes.rotate(shape, ApexOctahedralGroup.fromAngles(270, 0), center), Direction.DOWN, ApexShapes.rotate(shape, ApexOctahedralGroup.fromAngles(90, 0), center)));
    }

    @Deprecated(forRemoval=true, since="1.21.4")
    @ApiStatus.ScheduledForRemoval(inVersion="1.21.5")
    public static Map<AttachFace, Map<Direction, VoxelShape>> rotateAttachFace(VoxelShape shape) {
        return Map.of(AttachFace.WALL, ApexShapes.rotateHorizontal(shape), AttachFace.FLOOR, ApexShapes.rotateHorizontal(ApexShapes.rotate(shape, ApexOctahedralGroup.fromAngles(270, 0))), AttachFace.CEILING, ApexShapes.rotateHorizontal(ApexShapes.rotate(shape, ApexOctahedralGroup.fromAngles(90, 180))));
    }

    public static VoxelShape rotateHorizontal(VoxelShape shape, Vec3 center, Direction facing) {
        return switch (facing) {
            case Direction.EAST -> ApexShapes.rotate(shape, ApexOctahedralGroup.fromAngles(0, 90), center);
            case Direction.SOUTH -> ApexShapes.rotate(shape, ApexOctahedralGroup.fromAngles(0, 180), center);
            case Direction.WEST -> ApexShapes.rotate(shape, ApexOctahedralGroup.fromAngles(0, 270), center);
            default -> shape;
        };
    }

    public static VoxelShape rotateHorizontal(VoxelShape shape, Direction facing) {
        return ApexShapes.rotateHorizontal(shape, BLOCK_CENTER, facing);
    }
}

