/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.block;

import dev.apexstudios.apexcore.lib.component.ComponentRegistrar;
import dev.apexstudios.apexcore.lib.component.block.BlockComponent;
import dev.apexstudios.apexcore.lib.component.block.types.FacingBlockComponent;
import dev.apexstudios.apexcore.lib.util.shapes.ApexShapes;
import dev.apexstudios.fantasyfurniture.block.base.FurnitureBlockComponentHolder;
import dev.apexstudios.fantasyfurniture.set.FurnitureSet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChandelierBlock
extends FurnitureBlockComponentHolder {
    public static final VoxelShape SHAPE = ChandelierBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final Map<Direction, VoxelShape> FACING_SHAPES = ApexShapes.rotateHorizontal((VoxelShape)SHAPE);
    private final FurnitureSet furnitureSet;
    private final int particleCount;

    public ChandelierBlock(FurnitureSet furnitureSet, BlockBehaviour.Properties properties, int particleCount) {
        super(properties);
        this.furnitureSet = furnitureSet;
        this.particleCount = particleCount;
    }

    public ChandelierBlock(FurnitureSet furnitureSet, BlockBehaviour.Properties properties) {
        this(furnitureSet, properties, 4);
    }

    @Override
    protected VoxelShape getFurnitureShape(BlockState blockState, BlockPos pos) {
        return ChandelierBlock.getShape(FACING_SHAPES, blockState, pos);
    }

    @Override
    protected void registerComponents(ComponentRegistrar<BlockComponent> registrar) {
        super.registerComponents(registrar);
        FacingBlockComponent.registerHorizontal(registrar);
    }

    public void animateTick(BlockState blockState, Level level, BlockPos pos, RandomSource random) {
        for (int i = 0; i < this.particleCount; ++i) {
            this.addParticle(level, pos, i);
        }
    }

    protected void addParticle(Level level, BlockPos pos, int index) {
        boolean even;
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 0.65;
        double z = (double)pos.getZ() + 0.5;
        double offset = 0.25;
        boolean bl = even = index % 2 == 0;
        if (index < 2) {
            x = even ? x + offset : x - offset;
            z = !even ? z + offset : z - offset;
        } else {
            x = even ? x + offset : x - offset;
            z = even ? z + offset : z - offset;
        }
        this.playParticles(level, x, y, z);
    }

    protected void playParticles(Level level, double x, double y, double z) {
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.0, 0.0);
        level.addParticle(this.furnitureSet.flameParticle(), x, y, z, 0.0, 0.0, 0.0);
    }
}

