/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.block;

import dev.apexstudios.apexcore.lib.component.ComponentRegistrar;
import dev.apexstudios.apexcore.lib.component.block.BlockComponent;
import dev.apexstudios.apexcore.lib.component.block.BlockComponentTypes;
import dev.apexstudios.apexcore.lib.component.block.types.FacingBlockComponent;
import dev.apexstudios.apexcore.lib.util.shapes.ApexShapes;
import dev.apexstudios.fantasyfurniture.block.base.FurnitureBlockComponentHolder;
import dev.apexstudios.fantasyfurniture.block.base.InventoryBlock;
import dev.apexstudios.fantasyfurniture.block.entity.CounterBlockEntity;
import dev.apexstudios.fantasyfurniture.block.property.CounterConnection;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CounterBlock
extends InventoryBlock {
    public static final VoxelShape CORNER_SHAPE = ApexShapes.join((VoxelShape)CounterBlock.box((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)13.0, (double)4.0), (VoxelShape[])new VoxelShape[]{CounterBlock.box((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)13.0, (double)16.0), CounterBlock.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    public static final VoxelShape SHAPE = ApexShapes.join((VoxelShape)CounterBlock.box((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)13.0, (double)16.0), (VoxelShape[])new VoxelShape[]{CounterBlock.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), CounterBlock.box((double)1.0, (double)1.0, (double)2.0, (double)15.0, (double)12.0, (double)3.0)});
    public static final Map<Direction, VoxelShape> CORNER_FACING_SHAPES = ApexShapes.rotateHorizontal((VoxelShape)CORNER_SHAPE);
    public static final Map<Direction, VoxelShape> FACING_SHAPES = ApexShapes.rotateHorizontal((VoxelShape)SHAPE);

    public CounterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(CounterConnection.PROPERTY, (Comparable)((Object)CounterConnection.NONE)));
    }

    @Override
    protected VoxelShape getFurnitureShape(BlockState blockState, BlockPos pos) {
        return FurnitureBlockComponentHolder.getShape(switch ((CounterConnection)((Object)blockState.getValue(CounterConnection.PROPERTY))) {
            default -> throw new MatchException(null, null);
            case CounterConnection.CORNER_INNER, CounterConnection.CORNER_OUTER -> CORNER_FACING_SHAPES;
            case CounterConnection.NONE -> FACING_SHAPES;
        }, blockState, pos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{CounterConnection.PROPERTY});
    }

    @Override
    protected void registerComponents(ComponentRegistrar<BlockComponent> registrar) {
        super.registerComponents(registrar);
        FacingBlockComponent.registerHorizontal(registrar);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockState = super.getStateForPlacement(context);
        if (blockState == null) {
            return null;
        }
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        FacingBlockComponent facingComponent = (FacingBlockComponent)this.getComponentOrThrow(BlockComponentTypes.FACING);
        return CounterConnection.setConnection((BlockGetter)level, pos, blockState, arg_0 -> ((FacingBlockComponent)facingComponent).get(arg_0), (arg_0, arg_1) -> ((FacingBlockComponent)facingComponent).set(arg_0, arg_1));
    }

    public BlockState updateShape(BlockState blockState, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction facing, BlockPos neighborPos, BlockState neighborBlockState, RandomSource random) {
        BlockState result = blockState;
        if (facing.getAxis().isHorizontal()) {
            FacingBlockComponent facingComponent = (FacingBlockComponent)this.getComponentOrThrow(BlockComponentTypes.FACING);
            result = CounterConnection.setConnection((BlockGetter)level, pos, result, arg_0 -> ((FacingBlockComponent)facingComponent).get(arg_0), (arg_0, arg_1) -> ((FacingBlockComponent)facingComponent).set(arg_0, arg_1));
        }
        return super.updateShape(result, level, tickAccess, pos, facing, neighborPos, neighborBlockState, random);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState blockState) {
        return new CounterBlockEntity(pos, blockState);
    }
}

