/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.block;

import dev.apexstudios.apexcore.lib.component.ComponentRegistrar;
import dev.apexstudios.apexcore.lib.component.block.BlockComponent;
import dev.apexstudios.apexcore.lib.component.block.BlockComponentTypes;
import dev.apexstudios.apexcore.lib.component.block.types.FacingBlockComponent;
import dev.apexstudios.apexcore.lib.util.shapes.ApexShapes;
import dev.apexstudios.fantasyfurniture.block.base.FurnitureBlockComponentHolder;
import dev.apexstudios.fantasyfurniture.block.property.ShelfConnection;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ShelfBlock
extends FurnitureBlockComponentHolder {
    public static final VoxelShape LEFT_SHAPE = ApexShapes.join((VoxelShape)ShelfBlock.box((double)13.5, (double)9.0, (double)2.0, (double)15.5, (double)14.0, (double)13.0), (VoxelShape[])new VoxelShape[]{ShelfBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), ShelfBlock.box((double)13.0, (double)6.0, (double)13.0, (double)16.0, (double)14.0, (double)16.0)});
    public static final VoxelShape RIGHT_SHAPE = ApexShapes.join((VoxelShape)ShelfBlock.box((double)0.5, (double)9.0, (double)2.0, (double)2.5, (double)14.0, (double)13.0), (VoxelShape[])new VoxelShape[]{ShelfBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), ShelfBlock.box((double)0.0, (double)6.0, (double)13.0, (double)3.0, (double)14.0, (double)16.0)});
    public static final VoxelShape BOTH_SHAPE = ShelfBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape SHAPE = ApexShapes.join((VoxelShape)ShelfBlock.box((double)0.5, (double)9.0, (double)2.0, (double)2.5, (double)14.0, (double)13.0), (VoxelShape[])new VoxelShape[]{ShelfBlock.box((double)13.5, (double)9.0, (double)2.0, (double)15.5, (double)14.0, (double)13.0), ShelfBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), ShelfBlock.box((double)13.0, (double)6.0, (double)13.0, (double)16.0, (double)14.0, (double)16.0), ShelfBlock.box((double)0.0, (double)6.0, (double)13.0, (double)3.0, (double)14.0, (double)16.0)});
    public static final Map<Direction, VoxelShape> LEFT_FACING_SHAPES = ApexShapes.rotateHorizontal((VoxelShape)LEFT_SHAPE);
    public static final Map<Direction, VoxelShape> RIGHT_FACING_SHAPES = ApexShapes.rotateHorizontal((VoxelShape)RIGHT_SHAPE);
    public static final Map<Direction, VoxelShape> BOTH_FACING_SHAPES = ApexShapes.rotateHorizontal((VoxelShape)BOTH_SHAPE);
    public static final Map<Direction, VoxelShape> FACING_SHAPES = ApexShapes.rotateHorizontal((VoxelShape)SHAPE);

    public ShelfBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(ShelfConnection.PROPERTY, (Comparable)((Object)ShelfConnection.BOTH)));
    }

    @Override
    protected VoxelShape getFurnitureShape(BlockState blockState, BlockPos pos) {
        return ShelfBlock.getShape(switch ((ShelfConnection)((Object)blockState.getValue(ShelfConnection.PROPERTY))) {
            default -> throw new MatchException(null, null);
            case ShelfConnection.LEFT -> LEFT_FACING_SHAPES;
            case ShelfConnection.RIGHT -> RIGHT_FACING_SHAPES;
            case ShelfConnection.BOTH -> BOTH_FACING_SHAPES;
            case ShelfConnection.NONE -> FACING_SHAPES;
        }, blockState, pos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ShelfConnection.PROPERTY});
    }

    @Override
    protected void registerComponents(ComponentRegistrar<BlockComponent> registrar) {
        super.registerComponents(registrar);
        FacingBlockComponent.registerHorizontal(registrar);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockState = super.getStateForPlacement(context);
        if (blockState == null) {
            return null;
        }
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        FacingBlockComponent facingComponent = (FacingBlockComponent)this.getComponentOrThrow(BlockComponentTypes.FACING);
        return ShelfConnection.setConnection((BlockGetter)level, pos, blockState, arg_0 -> ((FacingBlockComponent)facingComponent).get(arg_0));
    }

    public BlockState updateShape(BlockState blockState, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction facing, BlockPos neighborPos, BlockState neighborBlockState, RandomSource random) {
        BlockState result = blockState;
        if (facing.getAxis().isHorizontal()) {
            FacingBlockComponent facingComponent = (FacingBlockComponent)this.getComponentOrThrow(BlockComponentTypes.FACING);
            result = ShelfConnection.setConnection((BlockGetter)level, pos, result, arg_0 -> ((FacingBlockComponent)facingComponent).get(arg_0));
        }
        return super.updateShape(result, level, tickAccess, pos, facing, neighborPos, neighborBlockState, random);
    }
}

