/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.block;

import dev.apexstudios.apexcore.lib.component.ComponentRegistrar;
import dev.apexstudios.apexcore.lib.component.ComponentType;
import dev.apexstudios.apexcore.lib.component.block.BlockComponent;
import dev.apexstudios.apexcore.lib.component.block.BlockComponentTypes;
import dev.apexstudios.apexcore.lib.component.block.types.FacingBlockComponent;
import dev.apexstudios.apexcore.lib.util.shapes.ApexShapes;
import dev.apexstudios.fantasyfurniture.block.base.SeatBlock;
import dev.apexstudios.fantasyfurniture.block.property.SofaConnection;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SofaBlock
extends SeatBlock {
    public static final VoxelShape LEFT_SHAPE = ApexShapes.join((VoxelShape)SofaBlock.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), (VoxelShape[])new VoxelShape[]{SofaBlock.box((double)0.0, (double)6.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), SofaBlock.box((double)14.0, (double)10.0, (double)0.0, (double)16.0, (double)12.0, (double)13.0), SofaBlock.box((double)14.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)2.0), SofaBlock.box((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)3.0), SofaBlock.box((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)3.0, (double)15.0)});
    public static final VoxelShape RIGHT_SHAPE = ApexShapes.join((VoxelShape)SofaBlock.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), (VoxelShape[])new VoxelShape[]{SofaBlock.box((double)0.0, (double)6.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), SofaBlock.box((double)0.0, (double)10.0, (double)0.0, (double)2.0, (double)12.0, (double)13.0), SofaBlock.box((double)0.0, (double)6.0, (double)0.0, (double)2.0, (double)10.0, (double)2.0), SofaBlock.box((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)3.0, (double)3.0), SofaBlock.box((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)15.0)});
    public static final VoxelShape BOTH_SHAPE = ApexShapes.join((VoxelShape)SofaBlock.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), (VoxelShape[])new VoxelShape[]{SofaBlock.box((double)0.0, (double)6.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0)});
    public static final VoxelShape CORNER_SHAPE = ApexShapes.join((VoxelShape)SofaBlock.box((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)3.0, (double)3.0), (VoxelShape[])new VoxelShape[]{SofaBlock.box((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)15.0), SofaBlock.box((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)3.0, (double)15.0), SofaBlock.box((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)3.0), SofaBlock.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), SofaBlock.box((double)0.0, (double)6.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), SofaBlock.box((double)13.0, (double)6.0, (double)0.0, (double)16.0, (double)16.0, (double)13.0)});
    public static final VoxelShape SHAPE = ApexShapes.join((VoxelShape)SofaBlock.box((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)3.0, (double)3.0), (VoxelShape[])new VoxelShape[]{SofaBlock.box((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)15.0), SofaBlock.box((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)3.0, (double)15.0), SofaBlock.box((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)3.0), SofaBlock.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), SofaBlock.box((double)0.0, (double)6.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), SofaBlock.box((double)14.0, (double)10.0, (double)0.0, (double)16.0, (double)12.0, (double)14.0), SofaBlock.box((double)0.0, (double)10.0, (double)0.0, (double)2.0, (double)12.0, (double)14.0), SofaBlock.box((double)0.0, (double)6.0, (double)0.0, (double)2.0, (double)10.0, (double)2.0), SofaBlock.box((double)14.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)2.0)});
    public static final Map<Direction, VoxelShape> LEFT_FACING_SHAPES = ApexShapes.rotateHorizontal((VoxelShape)LEFT_SHAPE);
    public static final Map<Direction, VoxelShape> RIGHT_FACING_SHAPES = ApexShapes.rotateHorizontal((VoxelShape)RIGHT_SHAPE);
    public static final Map<Direction, VoxelShape> BOTH_FACING_SHAPES = ApexShapes.rotateHorizontal((VoxelShape)BOTH_SHAPE);
    public static final Map<Direction, VoxelShape> CORNER_FACING_SHAPES = ApexShapes.rotateHorizontal((VoxelShape)CORNER_SHAPE);
    public static final Map<Direction, VoxelShape> FACING_SHAPES = ApexShapes.rotateHorizontal((VoxelShape)SHAPE);

    public SofaBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(SofaConnection.PROPERTY, (Comparable)((Object)SofaConnection.BOTH)));
    }

    @Override
    protected VoxelShape getFurnitureShape(BlockState blockState, BlockPos pos) {
        return SofaBlock.getShape(switch ((SofaConnection)((Object)blockState.getValue(SofaConnection.PROPERTY))) {
            default -> throw new MatchException(null, null);
            case SofaConnection.LEFT -> LEFT_FACING_SHAPES;
            case SofaConnection.RIGHT -> RIGHT_FACING_SHAPES;
            case SofaConnection.BOTH -> BOTH_FACING_SHAPES;
            case SofaConnection.CORNER_INNER, SofaConnection.CORNER_OUTER -> CORNER_FACING_SHAPES;
            case SofaConnection.NONE -> FACING_SHAPES;
        }, blockState, pos);
    }

    @Override
    protected void registerComponents(ComponentRegistrar<BlockComponent> registrar) {
        super.registerComponents(registrar);
        registrar.register(new ComponentType[]{BlockComponentTypes.BOUNCE});
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SofaConnection.PROPERTY});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockState = super.getStateForPlacement(context);
        if (blockState == null) {
            return null;
        }
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        FacingBlockComponent facingComponent = (FacingBlockComponent)this.getComponentOrThrow(BlockComponentTypes.FACING);
        return SofaConnection.setConnection((BlockGetter)level, pos, blockState, arg_0 -> ((FacingBlockComponent)facingComponent).get(arg_0), (arg_0, arg_1) -> ((FacingBlockComponent)facingComponent).set(arg_0, arg_1));
    }

    public BlockState updateShape(BlockState blockState, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction facing, BlockPos neighborPos, BlockState neighborBlockState, RandomSource random) {
        BlockState result = blockState;
        if (facing.getAxis().isHorizontal()) {
            FacingBlockComponent facingComponent = (FacingBlockComponent)this.getComponentOrThrow(BlockComponentTypes.FACING);
            result = SofaConnection.setConnection((BlockGetter)level, pos, blockState, arg_0 -> ((FacingBlockComponent)facingComponent).get(arg_0), (arg_0, arg_1) -> ((FacingBlockComponent)facingComponent).set(arg_0, arg_1));
        }
        return super.updateShape(result, level, tickAccess, pos, facing, neighborPos, neighborBlockState, random);
    }
}

