/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.block;

import dev.apexstudios.apexcore.lib.component.ComponentRegistrar;
import dev.apexstudios.apexcore.lib.component.ComponentType;
import dev.apexstudios.apexcore.lib.component.block.BlockComponent;
import dev.apexstudios.apexcore.lib.component.block.BlockComponentHelper;
import dev.apexstudios.apexcore.lib.component.block.BlockComponentTypes;
import dev.apexstudios.apexcore.lib.component.block.types.FacingBlockComponent;
import dev.apexstudios.apexcore.lib.util.shapes.ApexShapes;
import dev.apexstudios.fantasyfurniture.block.base.FurnitureBlockComponentHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TableBlock
extends FurnitureBlockComponentHolder {
    public static final VoxelShape SHAPE_TABLE_TOP = TableBlock.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape SHAPE_TABLE_LEG = TableBlock.box((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)13.0, (double)3.0);
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;

    public TableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected VoxelShape getFurnitureShape(BlockState blockState, BlockPos pos) {
        Direction facing = ((FacingBlockComponent)this.getComponentOrThrow(BlockComponentTypes.FACING)).get(blockState);
        return ApexShapes.rotateHorizontal((VoxelShape)TableBlock.getShape(blockState, SHAPE_TABLE_TOP, SHAPE_TABLE_LEG), (Direction)facing);
    }

    @Override
    protected void registerComponents(ComponentRegistrar<BlockComponent> registrar) {
        super.registerComponents(registrar);
        FacingBlockComponent.registerHorizontal(registrar);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockState = super.getStateForPlacement(context);
        if (blockState != null) {
            return TableBlock.get((BlockGetter)context.getLevel(), context.getClickedPos(), blockState);
        }
        return null;
    }

    public BlockState updateShape(BlockState blockState, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction facing, BlockPos neighborPos, BlockState neighborBlockState, RandomSource random) {
        BlockState result = TableBlock.get((BlockGetter)level, pos, blockState, facing);
        return super.updateShape(result, level, tickAccess, pos, facing, neighborPos, neighborBlockState, random);
    }

    public static BlockState get(BlockGetter level, BlockPos pos, BlockState blockState) {
        BlockState result = blockState;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            result = TableBlock.get(level, pos, result, direction);
        }
        return result;
    }

    public static BlockState get(BlockGetter level, BlockPos pos, BlockState blockState, Direction side) {
        if (!side.getAxis().isHorizontal()) {
            return blockState;
        }
        BlockState result = blockState;
        Direction facing = ((FacingBlockComponent)BlockComponentHelper.getComponentOrThrow((BlockState)blockState, (ComponentType)BlockComponentTypes.FACING)).get(blockState);
        BlockPos frontPos = pos.relative(facing);
        BlockState frontBlockState = level.getBlockState(frontPos);
        BooleanProperty frontProperty = TableBlock.property(facing);
        result = (BlockState)result.setValue((Property)frontProperty, (Comparable)Boolean.valueOf(TableBlock.canConnect(blockState, frontBlockState)));
        if (side == facing) {
            return result;
        }
        BlockPos sidePos = pos.relative(side);
        BlockState sideBlockState = level.getBlockState(sidePos);
        BooleanProperty sideProperty = TableBlock.property(side);
        result = (BlockState)result.setValue((Property)sideProperty, (Comparable)Boolean.valueOf(TableBlock.canConnect(blockState, sideBlockState)));
        return result;
    }

    public static BooleanProperty property(Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> NORTH;
            case Direction.EAST -> EAST;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            default -> throw new IllegalStateException("Illegal connection direction: " + direction.name());
        };
    }

    public static boolean canConnect(BlockState source, BlockState target) {
        if (!target.is(source.getBlock())) {
            return false;
        }
        FacingBlockComponent facing = (FacingBlockComponent)BlockComponentHelper.getComponentOrThrow((BlockState)source, (ComponentType)BlockComponentTypes.FACING);
        return target.hasProperty((Property)facing.getProperty()) && facing.get(source) == facing.get(target);
    }

    public static Direction getFacingForConnection(Direction facing) {
        return facing.getAxis() == Direction.Axis.X ? facing.getOpposite() : facing;
    }

    public static VoxelShape getShape(BlockState blockState, VoxelShape top, VoxelShape leg) {
        VoxelShape result = top;
        Direction facing = ((FacingBlockComponent)BlockComponentHelper.getComponentOrThrow((BlockState)blockState, (ComponentType)BlockComponentTypes.FACING)).get(blockState);
        Boolean north = (Boolean)blockState.getValue((Property)NORTH);
        Boolean east = (Boolean)blockState.getValue((Property)EAST);
        Boolean south = (Boolean)blockState.getValue((Property)SOUTH);
        Boolean west = (Boolean)blockState.getValue((Property)WEST);
        int count = 0;
        if (north.booleanValue()) {
            ++count;
        }
        if (east.booleanValue()) {
            ++count;
        }
        if (south.booleanValue()) {
            ++count;
        }
        if (west.booleanValue()) {
            ++count;
        }
        if (count == 0) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                result = ApexShapes.join((VoxelShape)result, (VoxelShape[])new VoxelShape[]{ApexShapes.rotateHorizontal((VoxelShape)leg, (Direction)direction)});
            }
        } else if (count == 1) {
            Direction face = null;
            if (north.booleanValue()) {
                face = Direction.EAST;
            } else if (east.booleanValue()) {
                face = Direction.SOUTH;
            } else if (south.booleanValue()) {
                face = Direction.WEST;
            } else if (west.booleanValue()) {
                face = Direction.NORTH;
            }
            if (face != null) {
                result = ApexShapes.join((VoxelShape)result, (VoxelShape[])new VoxelShape[]{TableBlock.rotateShape(leg, face, facing), TableBlock.rotateShape(leg, face.getClockWise(), facing)});
            }
        } else if (count == 2) {
            Direction face = null;
            if (north.booleanValue() && west.booleanValue()) {
                face = Direction.EAST;
            } else if (north.booleanValue() && east.booleanValue()) {
                face = Direction.SOUTH;
            } else if (east.booleanValue() && south.booleanValue()) {
                face = Direction.WEST;
            } else if (south.booleanValue() && west.booleanValue()) {
                face = Direction.NORTH;
            }
            if (face != null) {
                result = ApexShapes.join((VoxelShape)result, (VoxelShape[])new VoxelShape[]{TableBlock.rotateShape(leg, face, facing)});
            }
        }
        return result;
    }

    private static VoxelShape rotateShape(VoxelShape shape, Direction direction, Direction facing) {
        Rotation rotation = switch (TableBlock.getFacingForConnection(facing)) {
            case Direction.EAST -> Rotation.CLOCKWISE_90;
            case Direction.SOUTH -> Rotation.CLOCKWISE_180;
            case Direction.WEST -> Rotation.COUNTERCLOCKWISE_90;
            default -> Rotation.NONE;
        };
        return ApexShapes.rotateHorizontal((VoxelShape)shape, (Direction)rotation.rotate(direction));
    }
}

