/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.block;

import dev.apexstudios.apexcore.lib.component.ComponentRegistrar;
import dev.apexstudios.apexcore.lib.component.block.BlockComponent;
import dev.apexstudios.apexcore.lib.component.block.BlockComponentTypes;
import dev.apexstudios.apexcore.lib.component.block.types.FacingBlockComponent;
import dev.apexstudios.apexcore.lib.util.shapes.ApexShapes;
import dev.apexstudios.fantasyfurniture.block.base.FurnitureBlockComponentHolder;
import dev.apexstudios.fantasyfurniture.set.FurnitureSet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WallLightBlock
extends FurnitureBlockComponentHolder {
    public static final VoxelShape SHAPE = ApexShapes.join((VoxelShape)WallLightBlock.box((double)6.0, (double)5.0, (double)15.0, (double)10.0, (double)11.0, (double)16.0), (VoxelShape[])new VoxelShape[]{WallLightBlock.box((double)6.0, (double)2.0, (double)8.0, (double)10.0, (double)15.0, (double)15.0)});
    public static final Map<Direction, VoxelShape> FACING_SHAPES = ApexShapes.rotateHorizontal((VoxelShape)SHAPE);
    private final FurnitureSet furnitureSet;

    public WallLightBlock(FurnitureSet furnitureSet, BlockBehaviour.Properties properties) {
        super(properties);
        this.furnitureSet = furnitureSet;
    }

    @Override
    protected VoxelShape getFurnitureShape(BlockState blockState, BlockPos pos) {
        return WallLightBlock.getShape(FACING_SHAPES, blockState, pos);
    }

    @Override
    protected void registerComponents(ComponentRegistrar<BlockComponent> registrar) {
        super.registerComponents(registrar);
        FacingBlockComponent.registerHorizontal(registrar);
    }

    public void animateTick(BlockState blockState, Level level, BlockPos pos, RandomSource random) {
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 0.7;
        double z = (double)pos.getZ() + 0.5;
        Direction facing = ((FacingBlockComponent)this.getComponentOrThrow(BlockComponentTypes.FACING)).get(blockState).getOpposite();
        double offset = 0.1;
        double offsetZ = offset * (double)facing.getStepZ();
        double offsetX = offset * (double)facing.getStepX();
        this.playParticles(level, x + offsetX, y + 0.35, z + offsetZ);
    }

    protected void playParticles(Level level, double x, double y, double z) {
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.0, 0.0);
        level.addParticle(this.furnitureSet.flameParticle(), x, y, z, 0.0, 0.0, 0.0);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockState = super.getStateForPlacement(context);
        if (blockState == null) {
            return null;
        }
        FacingBlockComponent facingComponent = (FacingBlockComponent)this.getComponentOrThrow(BlockComponentTypes.FACING);
        for (Direction facing : context.getNearestLookingDirections()) {
            if (!facing.getAxis().isHorizontal()) continue;
            blockState = facingComponent.set(blockState, facing.getOpposite());
            return blockState;
        }
        return null;
    }
}

