/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.block.base;

import com.google.common.collect.Maps;
import dev.apexstudios.apexcore.lib.component.ComponentRegistrar;
import dev.apexstudios.apexcore.lib.component.ComponentType;
import dev.apexstudios.apexcore.lib.component.block.BaseBlockComponentHolder;
import dev.apexstudios.apexcore.lib.component.block.BlockComponent;
import dev.apexstudios.apexcore.lib.component.block.BlockComponentHelper;
import dev.apexstudios.apexcore.lib.component.block.BlockComponentTypes;
import dev.apexstudios.apexcore.lib.component.block.types.FacingBlockComponent;
import dev.apexstudios.apexcore.lib.component.block.types.FluidLoggedBlockComponent;
import dev.apexstudios.apexcore.lib.component.block.types.MultiBlockComponent;
import java.util.Map;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.MustBeInvokedByOverriders;

public class FurnitureBlockComponentHolder
extends BaseBlockComponentHolder {
    private final Map<BlockState, VoxelShape> shapes = Maps.newHashMap();

    protected FurnitureBlockComponentHolder(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected VoxelShape getFurnitureShape(BlockState blockState, BlockPos pos) {
        return Shapes.block();
    }

    protected VoxelShape getShape(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapes.computeIfAbsent(blockState, $ -> this.getFurnitureShape((BlockState)$, pos));
    }

    public InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos pos, Player player, BlockHitResult result) {
        if (SharedConstants.IS_RUNNING_IN_IDE && player.isShiftKeyDown() && !this.shapes.isEmpty()) {
            player.displayClientMessage((Component)Component.literal((String)"Cleared VoxelShape cache"), true);
            this.shapes.clear();
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(blockState, level, pos, player, result);
    }

    @MustBeInvokedByOverriders
    protected void registerComponents(ComponentRegistrar<BlockComponent> registrar) {
        super.registerComponents(registrar);
        FluidLoggedBlockComponent.registerWater(registrar);
    }

    public static VoxelShape getShape(Map<Direction, VoxelShape> shapes, BlockState blockState, BlockPos pos) {
        Direction facing = ((FacingBlockComponent)BlockComponentHelper.getComponentOrThrow((BlockState)blockState, (ComponentType)BlockComponentTypes.FACING)).get(blockState);
        return FurnitureBlockComponentHolder.getShape(shapes.get(facing), blockState, pos);
    }

    public static VoxelShape getShape(VoxelShape shape, BlockState blockState, BlockPos pos) {
        MultiBlockComponent multiBlock = (MultiBlockComponent)BlockComponentHelper.getComponent((BlockState)blockState, (ComponentType)BlockComponentTypes.MULTI_BLOCK);
        if (multiBlock == null) {
            return shape;
        }
        return MultiBlockComponent.fixVoxelShape((VoxelShape)shape, (MultiBlockComponent)multiBlock, (BlockState)blockState, (BlockPos)pos);
    }
}

