/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.block.base;

import com.google.common.collect.Maps;
import dev.apexstudios.apexcore.lib.component.ComponentRegistrar;
import dev.apexstudios.apexcore.lib.component.ComponentType;
import dev.apexstudios.apexcore.lib.component.block.BlockComponent;
import dev.apexstudios.apexcore.lib.component.block.BlockComponentHelper;
import dev.apexstudios.apexcore.lib.component.block.BlockComponentTypes;
import dev.apexstudios.apexcore.lib.component.block.DoorBlockComponentHolder;
import dev.apexstudios.apexcore.lib.component.block.types.FacingBlockComponent;
import dev.apexstudios.apexcore.lib.component.block.types.FluidLoggedBlockComponent;
import dev.apexstudios.apexcore.lib.util.shapes.ApexShapes;
import dev.apexstudios.fantasyfurniture.block.base.FurnitureBlockComponentHolder;
import dev.apexstudios.fantasyfurniture.set.FurnitureSet;
import java.util.Map;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.MustBeInvokedByOverriders;

public class FurnitureDoorBlockComponentHolder
extends DoorBlockComponentHolder {
    public static final VoxelShape SHAPE = FurnitureDoorBlockComponentHolder.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)32.0, (double)16.0);
    private final Map<BlockState, VoxelShape> shapes = Maps.newHashMap();

    public FurnitureDoorBlockComponentHolder(BlockSetType type, BlockBehaviour.Properties properties) {
        super(type, properties);
    }

    public FurnitureDoorBlockComponentHolder(FurnitureSet furnitureSet, BlockBehaviour.Properties properties) {
        this(furnitureSet.blockSet(), properties);
    }

    protected VoxelShape getFurnitureShape(BlockState blockState, BlockPos pos) {
        return FurnitureDoorBlockComponentHolder.getShape(SHAPE, blockState, pos);
    }

    protected VoxelShape getShape(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapes.computeIfAbsent(blockState, $ -> this.getFurnitureShape((BlockState)$, pos));
    }

    public InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos pos, Player player, BlockHitResult result) {
        if (SharedConstants.IS_RUNNING_IN_IDE && player.isShiftKeyDown() && !this.shapes.isEmpty()) {
            player.displayClientMessage((Component)Component.literal((String)"Cleared VoxelShape cache"), true);
            this.shapes.clear();
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(blockState, level, pos, player, result);
    }

    @MustBeInvokedByOverriders
    protected void registerComponents(ComponentRegistrar<BlockComponent> registrar) {
        super.registerComponents(registrar);
        FluidLoggedBlockComponent.registerWater(registrar);
        registrar.register(BlockComponentTypes.MULTI_BLOCK, builder -> builder.with(0, 1, 0).rotatingFromComponent());
    }

    public static VoxelShape getShape(VoxelShape baseShape, BlockState blockState, BlockPos pos) {
        Direction facing = ((FacingBlockComponent)BlockComponentHelper.getComponentOrThrow((BlockState)blockState, (ComponentType)BlockComponentTypes.FACING)).get(blockState);
        Boolean open = (Boolean)blockState.getValue((Property)OPEN);
        if (open.booleanValue() && blockState.getValue((Property)HINGE) == DoorHingeSide.RIGHT) {
            facing = facing.getOpposite();
        }
        VoxelShape shape = ApexShapes.rotateHorizontal((VoxelShape)baseShape, (Direction)(open != false ? facing : facing.getCounterClockWise()));
        return FurnitureBlockComponentHolder.getShape(shape, blockState, pos);
    }
}

