/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.block.property;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;

public enum SofaConnection implements StringRepresentable
{
    LEFT("left"),
    RIGHT("right"),
    BOTH("center"),
    NONE("single"),
    CORNER_INNER("corner_inner"),
    CORNER_OUTER("corner_outer");

    public static final EnumProperty<SofaConnection> PROPERTY;
    private final String serializedName;

    private SofaConnection(String serializedName) {
        this.serializedName = serializedName;
    }

    public String getSerializedName() {
        return this.serializedName;
    }

    public boolean isCorner() {
        return this == CORNER_INNER || this == CORNER_OUTER;
    }

    public String getModelSuffix() {
        if (this.isCorner()) {
            return "_corner";
        }
        return "_" + this.serializedName;
    }

    public static BlockState setConnection(BlockGetter level, BlockPos pos, BlockState blockState, Function<BlockState, Direction> getFacing, BiFunction<BlockState, Direction, BlockState> setFacing) {
        SofaConnection connection = SofaConnection.determine(level, pos, blockState, getFacing);
        if (connection == CORNER_OUTER) {
            Direction facing = getFacing.apply(blockState);
            blockState = setFacing.apply(blockState, facing.getClockWise());
        }
        return (BlockState)blockState.setValue(PROPERTY, (Comparable)((Object)connection));
    }

    private static SofaConnection determine(BlockGetter level, BlockPos pos, BlockState blockState, Function<BlockState, Direction> getFacing) {
        boolean hasLeft = SofaConnection.canConnect(level, pos, blockState, getFacing, true);
        boolean hasRight = SofaConnection.canConnect(level, pos, blockState, getFacing, false);
        if (hasLeft && hasRight) {
            return BOTH;
        }
        if (hasLeft) {
            return SofaConnection.asCorner(level, pos, blockState, getFacing, LEFT);
        }
        if (hasRight) {
            return SofaConnection.asCorner(level, pos, blockState, getFacing, RIGHT);
        }
        return NONE;
    }

    private static boolean canConnect(BlockGetter level, BlockPos pos, BlockState blockState, Function<BlockState, Direction> getFacing, boolean left) {
        Direction facing = getFacing.apply(blockState);
        Direction offset = left ? facing.getCounterClockWise() : facing.getClockWise();
        BlockPos otherPos = pos.relative(offset);
        BlockState otherBlockState = level.getBlockState(otherPos);
        if (!otherBlockState.is(blockState.getBlock())) {
            return false;
        }
        if (getFacing.apply(otherBlockState) == facing) {
            return true;
        }
        return ((SofaConnection)((Object)otherBlockState.getValue(PROPERTY))).isCorner();
    }

    private static SofaConnection asCorner(BlockGetter level, BlockPos pos, BlockState blockState, Function<BlockState, Direction> getFacing, SofaConnection connection) {
        Direction facing = getFacing.apply(blockState);
        BlockPos frontPos = pos.relative(facing);
        BlockState frontBlockState = level.getBlockState(frontPos);
        if (!frontBlockState.is(blockState.getBlock())) {
            return connection;
        }
        Direction frontFacing = getFacing.apply(frontBlockState);
        if (frontFacing == facing.getCounterClockWise()) {
            return CORNER_INNER;
        }
        if (frontFacing.getCounterClockWise() == facing) {
            return CORNER_OUTER;
        }
        return connection;
    }

    static {
        PROPERTY = EnumProperty.create((String)"connection", SofaConnection.class);
    }
}

