/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.oven;

import dev.apexstudios.apexcore.lib.component.ComponentRegistrar;
import dev.apexstudios.apexcore.lib.component.block.entity.BaseBlockEntityComponentHolder;
import dev.apexstudios.apexcore.lib.component.block.entity.BlockEntityComponent;
import dev.apexstudios.apexcore.lib.component.block.entity.BlockEntityComponentHelper;
import dev.apexstudios.fantasyfurniture.FurnitureBlockEntities;
import dev.apexstudios.fantasyfurniture.oven.OvenData;
import dev.apexstudios.fantasyfurniture.oven.OvenMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.items.IItemHandler;

public final class OvenBlockEntity
extends BaseBlockEntityComponentHolder {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_FUEL = 1;
    public static final int SLOT_OUTPUT = 2;
    public static final int SLOTS = 3;
    final OvenData data = new OvenData();

    public OvenBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)FurnitureBlockEntities.OVEN.value(), pos, blockState);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.data.save(tag);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.data.load(tag);
    }

    protected AbstractContainerMenu createMenu(int windowId, Player player) {
        return new OvenMenu(windowId, player.getInventory(), this);
    }

    protected void registerComponents(ComponentRegistrar<BlockEntityComponent> registrar) {
        BlockEntityComponentHelper.registerInventoryComponents(registrar, builder -> builder.slot(0, slot -> slot.listener((index, inventory) -> {
            Level patt0$temp = this.level;
            if (patt0$temp instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)patt0$temp;
                this.data.cookingTotalTime = this.data.getTotalCookTime(level, (IItemHandler)inventory);
                this.data.cookingTimer = 0;
                this.setChanged();
            }
        })).slot(1, slot -> slot.validator((index, inventory, stack) -> this.level != null && stack.getBurnTime(null, this.level.fuelValues()) > 0 || stack.is(Tags.Items.BUCKETS_EMPTY) && !inventory.getStackInSlot(index).is(Tags.Items.BUCKETS_EMPTY))).slot(2, slot -> slot.validator((index, inventory, stack) -> false)));
    }

    public void serverTick(ServerLevel level, BlockPos pos, BlockState blockState) {
        this.data.serverTick(level, pos, blockState, this);
    }

    public void onRemove(BlockState blockState, Level level, BlockState newBlockState, boolean movedByPiston) {
        if (!blockState.is(newBlockState.getBlock()) && level instanceof ServerLevel) {
            ServerLevel sLevel = (ServerLevel)level;
            this.data.getRecipesToAwardAndPopExperience(sLevel, Vec3.atCenterOf((Vec3i)this.worldPosition));
        }
        super.onRemove(blockState, level, newBlockState, movedByPiston);
    }
}

