/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.oven;

import com.google.common.collect.Lists;
import dev.apexstudios.apexcore.lib.component.block.entity.BlockEntityComponentTypes;
import dev.apexstudios.apexcore.lib.component.block.entity.types.InventoryBlockEntityComponent;
import dev.apexstudios.fantasyfurniture.block.OvenBlock;
import dev.apexstudios.fantasyfurniture.oven.OvenBlockEntity;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;

public final class OvenData
implements ContainerData,
RecipeCraftingHolder {
    public static final String NBT_COOKING_TIMER = "cooking_time_spent";
    public static final String NBT_COOKING_TOTAL_TIME = "cooking_total_time";
    public static final String NBT_LIT_TIME_REMAINING = "lit_time_remaining";
    public static final String NBT_LIT_TOTAL_TIME = "lit_total_time";
    public static final String NBT_RECIPES_USED = "RecipesUsed";
    private int litTimeRemaining;
    private int litTotalTime;
    int cookingTimer;
    int cookingTotalTime;
    private final Reference2IntOpenHashMap<ResourceKey<Recipe<?>>> recipesUsed = new Reference2IntOpenHashMap();
    private final RecipeManager.CachedCheck<SingleRecipeInput, SmokingRecipe> quickCheck = RecipeManager.createCheck((RecipeType)RecipeType.SMOKING);

    void serverTick(ServerLevel level, BlockPos pos, BlockState blockState, OvenBlockEntity oven) {
        boolean hasNoFuel;
        IItemHandlerModifiable inventory = ((InventoryBlockEntityComponent)oven.getComponentOrThrow(BlockEntityComponentTypes.INVENTORY)).getItemHandler();
        boolean wasLit = this.isLit();
        boolean changed = false;
        if (this.isLit()) {
            --this.litTimeRemaining;
        }
        ItemStack fuel = inventory.getStackInSlot(1);
        ItemStack input = inventory.getStackInSlot(0);
        boolean hasNoInput = !input.isEmpty();
        boolean bl = hasNoFuel = !fuel.isEmpty();
        if (this.isLit() || hasNoFuel && hasNoInput) {
            RecipeHolder recipeholder;
            SingleRecipeInput singlerecipeinput = new SingleRecipeInput(input);
            RecipeHolder recipeHolder = recipeholder = hasNoInput ? (RecipeHolder)this.quickCheck.getRecipeFor((RecipeInput)singlerecipeinput, level).orElse(null) : null;
            if (!this.isLit() && this.canBurn(level.registryAccess(), (RecipeHolder<? extends AbstractCookingRecipe>)recipeholder, singlerecipeinput, (IItemHandler)inventory)) {
                this.litTotalTime = this.litTimeRemaining = fuel.getBurnTime(RecipeType.SMOKING, level.fuelValues());
                if (this.isLit()) {
                    changed = true;
                    ItemStack remainder = fuel.getCraftingRemainder();
                    if (!remainder.isEmpty()) {
                        inventory.setStackInSlot(1, remainder);
                    } else if (hasNoFuel) {
                        Item item = fuel.getItem();
                        fuel.shrink(1);
                        if (fuel.isEmpty()) {
                            inventory.setStackInSlot(1, item.getCraftingRemainder());
                        }
                    }
                }
            }
            if (this.isLit() && this.canBurn(level.registryAccess(), (RecipeHolder<? extends AbstractCookingRecipe>)recipeholder, singlerecipeinput, (IItemHandler)inventory)) {
                ++this.cookingTimer;
                if (this.cookingTimer == this.cookingTotalTime) {
                    this.cookingTimer = 0;
                    this.cookingTotalTime = this.getTotalCookTime(level, (IItemHandler)inventory);
                    if (this.burn(level.registryAccess(), (RecipeHolder<? extends AbstractCookingRecipe>)recipeholder, singlerecipeinput, inventory)) {
                        this.setRecipeUsed(recipeholder);
                    }
                    changed = true;
                }
            } else {
                this.cookingTimer = 0;
            }
        } else if (!this.isLit() && this.cookingTimer > 0) {
            this.cookingTimer = Mth.clamp((int)(this.cookingTimer - 2), (int)0, (int)this.cookingTotalTime);
        }
        if (wasLit != this.isLit()) {
            changed = true;
            level.setBlock(pos, (BlockState)blockState.setValue((Property)OvenBlock.LIT, (Comparable)Boolean.valueOf(this.isLit())), 3);
        }
        if (changed) {
            oven.setChanged();
        }
    }

    void save(CompoundTag tag) {
        tag.putInt(NBT_COOKING_TIMER, this.cookingTimer);
        tag.putInt(NBT_COOKING_TOTAL_TIME, this.cookingTotalTime);
        tag.putInt(NBT_LIT_TIME_REMAINING, this.litTimeRemaining);
        tag.putInt(NBT_LIT_TOTAL_TIME, this.litTotalTime);
        CompoundTag recipesUsedTag = new CompoundTag();
        this.recipesUsed.forEach((key, count) -> recipesUsedTag.putInt(key.location().toString(), count.intValue()));
        tag.put(NBT_RECIPES_USED, (Tag)recipesUsedTag);
    }

    void load(CompoundTag tag) {
        this.cookingTimer = tag.getInt(NBT_COOKING_TIMER);
        this.cookingTotalTime = tag.getInt(NBT_COOKING_TOTAL_TIME);
        this.litTimeRemaining = tag.getInt(NBT_LIT_TIME_REMAINING);
        this.litTotalTime = tag.getInt(NBT_LIT_TOTAL_TIME);
        CompoundTag recipesUsedTag = tag.getCompound(NBT_RECIPES_USED);
        for (String key : recipesUsedTag.getAllKeys()) {
            this.recipesUsed.put((Object)ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.parse((String)key)), recipesUsedTag.getInt(key));
        }
    }

    public int get(int index) {
        return switch (index) {
            case 0 -> {
                if (this.litTotalTime > Short.MAX_VALUE) {
                    yield Mth.floor((double)((double)this.litTimeRemaining / (double)this.litTotalTime * 32767.0));
                }
                yield this.litTimeRemaining;
            }
            case 1 -> Math.min((int)this.litTotalTime, (int)Short.MAX_VALUE);
            case 2 -> this.cookingTimer;
            case 3 -> this.cookingTotalTime;
            default -> -1;
        };
    }

    public void set(int index, int value) {
        switch (index) {
            case 0: {
                this.litTimeRemaining = value;
                break;
            }
            case 1: {
                this.litTotalTime = value;
                break;
            }
            case 2: {
                this.cookingTimer = value;
                break;
            }
            case 3: {
                this.cookingTotalTime = value;
            }
        }
    }

    public int getCount() {
        return 4;
    }

    public void setRecipeUsed(@Nullable RecipeHolder<?> recipe) {
        if (recipe != null) {
            this.recipesUsed.addTo((Object)recipe.id(), 1);
        }
    }

    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    private boolean isLit() {
        return this.litTimeRemaining > 0;
    }

    private boolean canBurn(RegistryAccess registryAccess, @Nullable RecipeHolder<? extends AbstractCookingRecipe> recipe, SingleRecipeInput recipeInput, IItemHandler items) {
        if (!items.getStackInSlot(0).isEmpty() && recipe != null) {
            ItemStack result = ((AbstractCookingRecipe)recipe.value()).assemble(recipeInput, (HolderLookup.Provider)registryAccess);
            if (result.isEmpty()) {
                return false;
            }
            ItemStack output = items.getStackInSlot(2);
            if (output.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)output, (ItemStack)result)) {
                return false;
            }
            int slotLimit = items.getSlotLimit(2);
            return output.getCount() + result.getCount() <= slotLimit && (output.getCount() + result.getCount() <= output.getMaxStackSize() || output.getCount() + result.getCount() <= result.getMaxStackSize());
        }
        return false;
    }

    private boolean burn(RegistryAccess registryAccess, @Nullable RecipeHolder<? extends AbstractCookingRecipe> recipe, SingleRecipeInput recipeInput, IItemHandlerModifiable items) {
        if (recipe != null && this.canBurn(registryAccess, recipe, recipeInput, (IItemHandler)items)) {
            ItemStack input = items.getStackInSlot(0);
            ItemStack result = ((AbstractCookingRecipe)recipe.value()).assemble(recipeInput, (HolderLookup.Provider)registryAccess);
            ItemStack output = items.getStackInSlot(2);
            ItemStack fuel = items.getStackInSlot(1);
            if (output.isEmpty()) {
                items.setStackInSlot(2, result.copy());
            } else if (ItemStack.isSameItemSameComponents((ItemStack)output, (ItemStack)result)) {
                output.grow(result.getCount());
            }
            if (input.is(Blocks.WET_SPONGE.asItem()) && !fuel.isEmpty() && fuel.is(Items.BUCKET)) {
                items.setStackInSlot(1, new ItemStack((ItemLike)Items.WATER_BUCKET));
            }
            input.shrink(1);
            return true;
        }
        return false;
    }

    int getTotalCookTime(ServerLevel level, IItemHandler itemHandler) {
        SingleRecipeInput input = new SingleRecipeInput(itemHandler.getStackInSlot(0));
        return this.quickCheck.getRecipeFor((RecipeInput)input, level).map(recipe -> ((SmokingRecipe)recipe.value()).cookingTime()).orElse(200);
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer player, OvenBlockEntity oven) {
        List<RecipeHolder<?>> recipes = this.getRecipesToAwardAndPopExperience(player.serverLevel(), player.position());
        NonNullList inventory = ((InventoryBlockEntityComponent)oven.getComponentOrThrow(BlockEntityComponentTypes.INVENTORY)).getItems();
        player.awardRecipes(recipes);
        recipes.forEach(recipe -> {
            if (recipe != null) {
                player.triggerRecipeCrafted(recipe, (List)inventory);
            }
        });
        this.recipesUsed.clear();
    }

    public List<RecipeHolder<?>> getRecipesToAwardAndPopExperience(ServerLevel level, Vec3 popVec) {
        ArrayList list = Lists.newArrayList();
        this.recipesUsed.reference2IntEntrySet().forEach(entry -> level.recipeAccess().byKey((ResourceKey)entry.getKey()).ifPresent(recipe -> {
            list.add(recipe);
            this.createExperience(level, popVec, entry.getIntValue(), ((AbstractCookingRecipe)recipe.value()).experience());
        }));
        return list;
    }

    private void createExperience(ServerLevel level, Vec3 popVec, int recipeIndex, float experience) {
        int i = Mth.floor((float)((float)recipeIndex * experience));
        float f = Mth.frac((float)((float)recipeIndex * experience));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        ExperienceOrb.award((ServerLevel)level, (Vec3)popVec, (int)i);
    }
}

