/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.oven;

import dev.apexstudios.apexcore.lib.component.block.entity.BlockEntityComponentTypes;
import dev.apexstudios.apexcore.lib.component.block.entity.types.InventoryBlockEntityComponent;
import dev.apexstudios.fantasyfurniture.oven.OvenBlockEntity;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public record OvenMenuContainer(OvenBlockEntity oven) implements Container
{
    private IItemHandlerModifiable getItemHandler() {
        return ((InventoryBlockEntityComponent)this.oven.getComponentOrThrow(BlockEntityComponentTypes.INVENTORY)).getItemHandler();
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer player) {
        this.oven.data.awardUsedRecipesAndPopExperience(player, this.oven);
    }

    public int getContainerSize() {
        return this.getItemHandler().getSlots();
    }

    public boolean isEmpty() {
        IItemHandlerModifiable itemHandler = this.getItemHandler();
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            if (itemHandler.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return this.getItemHandler().getStackInSlot(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        return this.getItemHandler().extractItem(slot, amount, false);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return this.removeItem(slot, this.getMaxStackSize());
    }

    public void setItem(int slot, ItemStack stack) {
        this.getItemHandler().setStackInSlot(slot, stack);
    }

    public void setChanged() {
        this.oven.setChanged();
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this.oven, (Player)player);
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return this.getItemHandler().isItemValid(slot, stack);
    }

    public void clearContent() {
        IItemHandlerModifiable itemHandler = this.getItemHandler();
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            itemHandler.setStackInSlot(i, ItemStack.EMPTY);
        }
    }
}

